/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class HttpPart {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private long m_totalPartLength;
    private Map<String, String> m_partHeaders = new HashMap<String, String>();
    private InputStream m_bodyStream;

    private HttpPart() {
    }

    public HttpPart(String name, String value) {
        this();
        this.m_partHeaders.put(CONTENT_DISPOSITION, "form-data; name=\"" + name + "\"");
        this.m_partHeaders.put(CONTENT_LENGTH, String.valueOf(value.length()));
        this.m_bodyStream = new ByteArrayInputStream(value.getBytes());
        this.m_totalPartLength = value.getBytes().length;
    }

    public HttpPart(String fieldName, File file, String contentType) throws IOException {
        this();
        String fileName = file.getName();
        this.m_partHeaders.put(CONTENT_DISPOSITION, "form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"");
        this.m_partHeaders.put(CONTENT_TYPE, contentType);
        this.m_partHeaders.put(CONTENT_LENGTH, String.valueOf(file.length()));
        this.m_bodyStream = new FileInputStream(file);
        this.m_totalPartLength = file.length();
    }

    public HttpPart(String fieldName, ZipFile file, ZipEntry entry, String contentType) throws IOException {
        this();
        String fileName = entry.getName();
        this.m_partHeaders.put(CONTENT_DISPOSITION, "form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"");
        this.m_partHeaders.put(CONTENT_TYPE, contentType);
        this.m_partHeaders.put(CONTENT_LENGTH, String.valueOf(entry.getSize()));
        this.m_bodyStream = file.getInputStream(entry);
        this.m_totalPartLength = entry.getSize();
    }

    public Map<String, String> getPartHeaders() {
        return this.m_partHeaders;
    }

    public void addHeaderField(String name, String value) {
        this.m_partHeaders.put(name, value);
    }

    public InputStream getPartBodyInputStream() {
        return this.m_bodyStream;
    }

    public long getPartLength() {
        return this.m_totalPartLength;
    }
}

