/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.http;

import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class HttpResponse {
    private int responseCode = -1;
    private Map<String, List<String>> responseHeaders;
    private byte[] content = null;

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int status) {
        this.responseCode = status;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> map) {
        this.responseHeaders = map;
    }

    public String getHeaderField(String name) {
        List<String> values = this.responseHeaders.containsKey(name) ? this.responseHeaders.get(name) : null;
        return values == null ? null : values.get(0);
    }

    public byte[] getRawContent() {
        return this.content;
    }

    public void setRawContent(byte[] content) {
        this.content = content;
    }

    public JSONObject getResponseBody() throws IOException, JSONException {
        return this.hasResponseBody() && this.getRawContent().length > 0 ? (JSONObject)this.getResponseBodyAsJSON() : new JSONObject();
    }

    public String getResponseBodyAsString() {
        if (!this.hasResponseBody()) {
            return null;
        }
        try {
            return new String(this.content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.content);
        }
    }

    public JSONArtifact getResponseBodyAsJSON() throws IOException, JSONException {
        if (!this.hasResponseBody()) {
            return null;
        }
        return JSON.parse((String)this.getResponseBodyAsString());
    }

    @SuppressSecurityTrace
    public void getResponseBodyAsFile(File destination) throws IOException {
        if (this.hasResponseBody()) {
            FileOutputStream out = new FileOutputStream(destination, false);
            out.write(this.content);
            out.flush();
            out.close();
        }
    }

    public boolean hasResponseBody() {
        return this.content != null;
    }

    public boolean isSuccess() {
        int rc = this.getResponseCode();
        return rc >= 200 && rc < 300;
    }

    public boolean isServerError() {
        int rc = this.getResponseCode();
        return rc >= 500;
    }

    public boolean isBadRequest() {
        int rc = this.getResponseCode();
        return rc >= 400 && rc < 500;
    }
}

