/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model.validation;

import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.utils.RulesUtil;
import com.ibm.appscan.common.utils.json.JsonValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomRulesValidator {
    private List<String> m_validationErrors = new ArrayList<String>();

    public CustomRulesValidator(File rulesFile) {
        this.validate(rulesFile);
    }

    public boolean isValid() {
        return this.m_validationErrors.size() == 0;
    }

    public List<String> getValidationErrors() {
        return this.m_validationErrors;
    }

    private void validate(File customRulesFile) {
        if (customRulesFile != null && customRulesFile.isFile()) {
            this.m_validationErrors = JsonValidator.validate(RulesUtil.getCustomRulesSchemaFile(), customRulesFile);
        } else {
            this.m_validationErrors.add(Messages.getMessage("err.rules.file.not.found", customRulesFile));
        }
    }
}

