/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ClasspathBuilder;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ClasspathUtil {
    public static final String CLASSPATH = "classpath";
    public static final String ADDITIONAL_CP = "additional_classpath";
    public static final String BOOTSTRAP_CLASSPATH = "bootstrap_classpath";
    public static final String EXTENSION_JARS = "extension_jars";

    @SuppressSecurityTrace
    public static String joinPaths(String ... paths) {
        return ClasspathUtil.joinRelativePaths(null, paths);
    }

    public static String joinRelativePaths(String basePath, String ... paths) {
        Set<String> set;
        if (paths != null && !(set = ClasspathBuilder.resolve(basePath, paths)).isEmpty()) {
            return ClasspathBuilder.combine(set).substring(1);
        }
        return "";
    }

    public static void appendToClasspath(String path, IScanTargetMinProxy proxy, boolean prepend) {
        if (path != null && !path.trim().isEmpty()) {
            ClasspathBuilder builder = new ClasspathBuilder(proxy);
            builder.appendToClasspath(path, prepend);
            builder.commit();
        }
    }

    public static void appendToClasspath(String path, IScanTargetMinProxy proxy) {
        ClasspathUtil.appendToClasspath(path, proxy, false);
    }

    public static String makeRelative(File parent, File current, String classpath) {
        String[] entries = classpath.split(File.pathSeparator);
        for (int i = 0; i < entries.length; ++i) {
            String entry = PathUtil.makeRelative(parent, current, entries[i]);
            entries[i] = entry.isEmpty() ? "." : entry;
        }
        return ClasspathUtil.joinPaths(entries);
    }

    public static String generateSmallClassPath(String classpath) {
        StringBuilder ret = new StringBuilder();
        String[] entries = classpath.split(File.pathSeparator);
        HashSet<String> cp_entries = new HashSet<String>();
        for (int i = 0; i < entries.length; ++i) {
            File file = new File(entries[i]);
            if (file.getParentFile() != null && file.getName().endsWith(".jar")) {
                cp_entries.add(file.getParentFile().getAbsolutePath() + File.separator + "*");
                continue;
            }
            cp_entries.add(file.getAbsolutePath());
        }
        for (String string : cp_entries) {
            ret.append(string);
            ret.append(File.pathSeparator);
        }
        if (ret.length() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }
}

