/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.utils.CryptoUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class FipsUtil {
    public static boolean FIPS_ENABLED = false;

    public static void enableFIPS() throws ReflectiveOperationException, SecurityException, GeneralSecurityException {
        if (!FIPS_ENABLED) {
            System.setProperty("org.bouncycastle.fips.approved_only", "true");
            Class<?> c = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            Provider p = (Provider)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            Security.insertProviderAt(p, 1);
            Security.insertProviderAt((Provider)new BouncyCastleJsseProvider("fips:BCFIPS"), 2);
            System.setProperty("ssl.SocketFactory.provider", "org.bouncycastle.jsse.provider.SSLSocketFactoryImpl");
            System.setProperty("ssl.ServerSocketFactory.provider", "org.bouncycastle.jsse.provider.SSLServerSocketFactoryImpl");
            System.setProperty("ssl.KeyManagerFactory.algorithm", "PKIX");
            System.setProperty("ssl.TrustManagerFactory.algorithm", "PKIX");
            TrustManager[] trustManagers = null;
            String certpath = System.getenv("DART_CHC_ROOT_CA_CERT_PATH");
            if (certpath != null && new File(certpath).isFile()) {
                try (FileInputStream is2 = new FileInputStream(new File(certpath));){
                    Certificate cacert = CertificateFactory.getInstance("X.509").generateCertificate(new BufferedInputStream(is2));
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(null, null);
                    keyStore.setCertificateEntry(Integer.toString(1), cacert);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    trustManagers = trustManagerFactory.getTrustManagers();
                }
                catch (IOException is2) {
                    // empty catch block
                }
            }
            SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
            sslContext.init(null, trustManagers, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            CryptoUtils.enableFips();
            FIPS_ENABLED = true;
        }
    }
}

