/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.hcl.appscan.common.scm.ScmUtil;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.VersionInfo;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.ChecksumUtil;
import com.ibm.appscan.common.utils.CryptoUtils;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PackageUtil {
    private static final String AES = "AES";
    private static final String AES_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String INTERNAL_DAT = "internal.dat";
    private static final String INTERNAL_SCAN = "internal.scan";
    private static final String OSO_FILE = ".opensourceonly";
    private static final String SAO_FILE = ".staticanalysisonly";
    private static final String VERSION_FILE_PATH = CommonCore.getDirectoryLocator().getProductRoot() + "version.info";

    private static Cipher createKeyAndCipher(ZipOutputStream zip) throws IOException, GeneralSecurityException {
        SecretKey key = KeyGenerator.getInstance(AES).generateKey();
        byte[] keyBytes = key.getEncoded();
        Cipher cipher = CryptoUtils.getCipher(AES_CIPHER);
        cipher.init(1, key);
        byte[] ivBytes = cipher.getIV();
        byte[] combinedBytes = new byte[keyBytes.length + ivBytes.length];
        System.arraycopy(keyBytes, 0, combinedBytes, 0, keyBytes.length);
        System.arraycopy(ivBytes, 0, combinedBytes, keyBytes.length, ivBytes.length);
        byte[] encryptedBytes = CryptoUtils.rsaEncrypt(combinedBytes);
        ZipEntry entry = new ZipEntry(INTERNAL_DAT);
        entry.setMethod(0);
        entry.setSize(encryptedBytes.length);
        entry.setCrc(ChecksumUtil.calculateCRC(encryptedBytes));
        zip.putNextEntry(entry);
        zip.write(encryptedBytes);
        return cipher;
    }

    public static void pack(File directory, File destination, boolean tryEncrypt) throws IOException {
        PackageUtil.pack(directory, destination, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(File inputFile, File destination, boolean tryEncrypt, boolean includeScm) throws IOException {
        block11: {
            ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
            try {
                zip.putNextEntry(new ZipEntry("version.info"));
                IOUtil.write(new File(VERSION_FILE_PATH), zip);
                if (SystemUtil.isOpenSourceOnly()) {
                    zip.putNextEntry(new ZipEntry(OSO_FILE));
                }
                if (SystemUtil.isStaticAnalysisOnly()) {
                    zip.putNextEntry(new ZipEntry(SAO_FILE));
                }
                if (tryEncrypt && SystemUtil.shouldEncrypt() && CryptoUtils.canEncrypt()) {
                    Cipher cipher = PackageUtil.createKeyAndCipher(zip);
                    CipherOutputStream stream = new CipherOutputStream(zip, cipher);
                    try {
                        zip.putNextEntry(new ZipEntry(INTERNAL_SCAN));
                        PackageUtil.zipScanFile(inputFile, stream, includeScm);
                        break block11;
                    }
                    finally {
                        IOUtil.close(stream);
                    }
                }
                CommonCore.getIOConsole().println(Messages.getMessage("warn.no.encrypt", new Object[0]));
                zip.putNextEntry(new ZipEntry(INTERNAL_SCAN));
                PackageUtil.zipScanFile(inputFile, zip, includeScm);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            finally {
                IOUtil.close(zip);
            }
        }
    }

    public static void pack(File directory, File destination) throws IOException {
        PackageUtil.pack(directory, destination, true);
    }

    private static void zipScanFile(File source, OutputStream zip, boolean includeScm) throws IOException {
        if (source.isDirectory()) {
            ArchiveUtil.zip(source, zip);
        } else {
            File[] fileArray;
            File scmSettings;
            File file = scmSettings = includeScm ? PackageUtil.getScmSettingsFile(source.getParentFile()) : null;
            if (scmSettings != null) {
                File[] fileArray2 = new File[2];
                fileArray2[0] = source;
                fileArray = fileArray2;
                fileArray2[1] = scmSettings;
            } else {
                File[] fileArray3 = new File[1];
                fileArray = fileArray3;
                fileArray3[0] = source;
            }
            File[] files = fileArray;
            ArchiveUtil.zip(files, zip);
        }
    }

    private static File getScmSettingsFile(File directory) throws IOException {
        File scmSettings = new File(directory, ".scmsettings");
        if (scmSettings.exists() && scmSettings.isFile()) {
            return scmSettings;
        }
        File currentDirectory = new File(System.getProperty("user.dir"));
        ScmUtil.initialize(currentDirectory, new NullProgress());
        if (ScmUtil.getRepositoryUrl() != null) {
            File newScmSettings = new File(currentDirectory, ".scmsettings");
            ScmUtil.writeScmSettings(newScmSettings);
            return newScmSettings;
        }
        return null;
    }

    @SuppressSecurityTrace
    private static Cipher createCipher(byte[] keyBytes, String keyID) throws IOException, GeneralSecurityException {
        byte[] decryptedBytes = CryptoUtils.rsaDecrypt(keyBytes, keyID);
        int len = decryptedBytes.length / 2;
        Cipher cipher = CryptoUtils.getCipher(AES_CIPHER);
        cipher.init(2, (Key)new SecretKeySpec(decryptedBytes, 0, len, AES), new IvParameterSpec(decryptedBytes, len, len));
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decryptAndUnzip(InputStream in, File directory, Cipher cipher) throws IOException, GeneralSecurityException, AppScanException {
        CipherInputStream stream = new CipherInputStream(in, cipher);
        try {
            ArchiveUtil.unzip((InputStream)stream, directory, new String[0]);
        }
        finally {
            IOUtil.close(stream);
        }
    }

    public static void unpack(File source, File directory) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            ZipEntry keyEntry;
            ZipEntry entry = zip.getEntry(INTERNAL_SCAN);
            if (entry == null) {
                ArchiveUtil.unzip(source, directory, new String[0]);
                return;
            }
            ZipEntry propertiesEntry = zip.getEntry("job.properties");
            if (propertiesEntry != null) {
                File destFile = new File(directory.getParentFile(), "job.properties");
                Files.copy(zip.getInputStream(propertiesEntry), Paths.get(destFile.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            if ((keyEntry = zip.getEntry(INTERNAL_DAT)) == null) {
                ArchiveUtil.unzip(zip.getInputStream(entry), directory, new String[0]);
                return;
            }
            byte[] keyBytes = new byte[(int)keyEntry.getSize()];
            zip.getInputStream(keyEntry).read(keyBytes);
            ZipEntry versionEntry = zip.getEntry("version.info");
            if (versionEntry == null) {
                throw new IOException(Messages.getMessage("err.invalid.archive", new Object[0]));
            }
            VersionInfo version = new VersionInfo(zip.getInputStream(versionEntry));
            Cipher cipher = PackageUtil.createCipher(keyBytes, version.getKeyID());
            PackageUtil.decryptAndUnzip(zip.getInputStream(entry), directory, cipher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(File source) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            ZipEntry entry = zip.getEntry("version.info");
            VersionInfo vi = new VersionInfo(zip.getInputStream(entry));
            String string = vi.getVersion();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEncrypted(File source) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            ZipEntry entry = zip.getEntry(INTERNAL_DAT);
            boolean bl = entry != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpenSourceOnly(File source) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            ZipEntry entry = zip.getEntry(OSO_FILE);
            boolean bl = entry != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStaticAnalysisOnly(File source) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            ZipEntry entry = zip.getEntry(SAO_FILE);
            boolean bl = entry != null;
            return bl;
        }
    }
}

