/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils.json;

import com.ibm.appscan.common.utils.json.JsonReader;
import com.networknt.schema.Error;
import com.networknt.schema.InputFormat;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonValidator {
    public static boolean isValid(String jsonSchema, String jsonContent) {
        return JsonValidator.validate(jsonSchema, jsonContent).size() == 0;
    }

    public static boolean isValid(File jsonSchema, File jsonContent) {
        try {
            String schema = JsonReader.readIntoString(jsonSchema);
            String content = JsonReader.readIntoString(jsonContent);
            return JsonValidator.validate(schema, content).size() == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<String> validate(File jsonSchema, File jsonContent) {
        try {
            String schema = JsonReader.readIntoString(jsonSchema);
            String content = JsonReader.readIntoString(jsonContent);
            return JsonValidator.validate(schema, content);
        }
        catch (IOException e) {
            return Arrays.asList(e.getMessage());
        }
    }

    public static List<String> validate(String jsonSchema, String jsonContent) {
        ArrayList<String> errors = new ArrayList<String>();
        SchemaRegistry schemaRegistry = SchemaRegistry.withDialect((Dialect)Dialects.getDraft202012());
        Schema schema = schemaRegistry.getSchema(jsonSchema);
        for (Error error : schema.validate(jsonContent, InputFormat.JSON)) {
            errors.add(error.toString());
        }
        return errors;
    }
}

