/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.hcl.appscan.common.scm.ScmUtil;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.event.IScanChangedListener;
import com.ibm.appscan.common.model.event.IScanErrorListener;
import com.ibm.appscan.common.model.event.ScanChangedEvent;
import com.ibm.appscan.common.model.event.ScanErrorEvent;
import com.ibm.appscan.common.model.utils.VisitingWriter;
import com.ibm.appscan.common.model.xml.IrsWriter;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.PackageUtil;
import com.ibm.appscan.common.utils.PresetUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.common.model.ConfiguredScanWriter;
import com.ibm.appscan.internal.common.model.CustomTargetInfoReader;
import com.ibm.appscan.internal.common.model.DisposeVisitor;
import com.ibm.appscan.internal.common.model.IErrorObserver;
import com.ibm.appscan.internal.common.model.ScanLogManager;
import com.ibm.appscan.internal.common.model.ScanTarget;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;

public final class Scan
implements IScan,
IErrorObserver {
    private List<IScanChangedListener> m_changeListeners = new CopyOnWriteArrayList<IScanChangedListener>();
    private List<IScanErrorListener> m_errorListeners = new CopyOnWriteArrayList<IScanErrorListener>();
    private LinkedList<IScanTarget> m_targets = new LinkedList();
    private List<String> m_toDelete = new ArrayList<String>();
    boolean m_incomplete = false;
    private boolean m_dirty = false;
    private SaveLocation m_prevLocation = null;
    private SaveLocation m_location = null;
    private Map<String, CustomTargetInfo> m_customTargetInfos = null;
    private ScanLogManager m_logManager = new ScanLogManager(this);

    @Override
    public void addScanChangedListener(IScanChangedListener listener) {
        this.m_changeListeners.add(listener);
    }

    @Override
    public void removeScanChangedListener(IScanChangedListener listener) {
        this.m_changeListeners.remove(listener);
    }

    @Override
    public void addScanErrorListener(IScanErrorListener listener) {
        this.m_errorListeners.add(listener);
    }

    @Override
    public void removeScanErrorListener(IScanErrorListener listener) {
        this.m_errorListeners.remove(listener);
    }

    @Override
    public ScanTarget newScanTarget(ScanTargetStrategy strategy) {
        return new ScanTarget(this, strategy);
    }

    boolean contains(final IScanTarget query) {
        final boolean[] found = new boolean[]{false};
        this.accept(new ScanModelVisitor(){

            @Override
            public void visit(IScanTarget target) {
                if (target.equals(query)) {
                    found[0] = true;
                }
            }
        });
        return found[0];
    }

    @Override
    public synchronized boolean addScanTarget(IScanTarget target) {
        if (target.getParent() == null && !this.contains(target)) {
            this.m_targets.addFirst(target);
            this.fireScanTargetAdded(target);
            this.setTransformed(false);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeScanTarget(IScanTarget target) {
        if (this.getState() != ITransformable.State.TRANSFORMED && this.m_targets.remove(target)) {
            this.m_dirty = true;
            this.m_toDelete.add(target.getWorkingDirectoryName());
            this.getCustomTargetInfos().remove(target.getPath());
            ScanChangedEvent event = new ScanChangedEvent(this, target);
            for (IScanChangedListener listener : this.m_changeListeners) {
                listener.scanTargetRemoved(event);
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<IScanTarget> getScanTargets() {
        return Collections.unmodifiableList(this.m_targets);
    }

    @Override
    public boolean isEmpty() {
        return this.m_targets.isEmpty();
    }

    @Override
    public boolean isIncomplete() {
        return this.m_incomplete;
    }

    @Override
    public boolean isDirty() {
        return this.m_dirty;
    }

    @Override
    public void markAsClean() {
        this.m_dirty = false;
    }

    private void internalSetSaveLocation(SaveLocation location) {
        if (this.m_prevLocation == null && this.m_location != null && !this.m_location.equals(location)) {
            this.m_prevLocation = this.m_location;
        }
        this.m_location = location;
    }

    @Override
    public void setSaveLocation(SaveLocation location) {
        if (location != null && this.getState() != ITransformable.State.TRANSFORMED) {
            this.internalSetSaveLocation(location);
        }
    }

    @Override
    public SaveLocation getSaveLocation() {
        return this.m_location == null ? this.m_prevLocation : this.m_location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void internalSave(SaveLocation location, boolean transferWorkLocation, IProgress progress) throws IOException {
        if (location == null) {
            throw new IOException(Messages.getMessage("no.save.location", new Object[0]));
        }
        if (this.m_prevLocation != null) {
            this.dispose(this.m_prevLocation, transferWorkLocation ? location : null, progress);
        }
        VisitingWriter writer = new VisitingWriter((IScanModelVisitable)this, location, (ModelWriter)new ConfiguredScanWriter(this.m_customTargetInfos));
        writer.write(progress);
        this.m_dirty = false;
        File dir = location.getWorkLocation();
        try {
            for (String name : this.m_toDelete) {
                File workingDir = new File(dir, name);
                if (!workingDir.exists()) continue;
                DirectoryUtil.delete(new File(dir, name));
            }
        }
        finally {
            this.m_toDelete.clear();
        }
    }

    @Override
    public void save(IProgress progress) throws IOException {
        this.internalSave(this.m_location, true, progress);
        this.m_logManager.init();
    }

    @Override
    public void saveTo(IScan newScan, IProgress progress) throws IOException {
        if (newScan.getState() != ITransformable.State.NEW) {
            throw new IOException(Messages.getMessage("err.saveto", new Object[0]));
        }
        this.internalSave(newScan.getSaveLocation(), false, progress);
    }

    @Override
    public ILogManager getLogManager() {
        return this.m_logManager;
    }

    void fireScanTargetModified(IScanTarget target) {
        this.m_dirty = true;
        ScanChangedEvent event = new ScanChangedEvent(this, target);
        for (IScanChangedListener listener : this.m_changeListeners) {
            listener.scanTargetModified(event);
        }
    }

    void fireScanTargetAdded(IScanTarget target) {
        this.m_dirty = true;
        ScanChangedEvent event = new ScanChangedEvent(this, target);
        for (IScanChangedListener listener : this.m_changeListeners) {
            listener.scanTargetAdded(event);
        }
    }

    private void fireScanStateChanged() {
        ScanChangedEvent event = new ScanChangedEvent(this, null);
        for (IScanChangedListener listener : this.m_changeListeners) {
            listener.scanStateChanged(event);
        }
    }

    @Override
    public void setTransformed(boolean transform) {
        if (this.getState() == ITransformable.State.CONFIGURED && transform) {
            this.internalSetSaveLocation(null);
            this.accept(new ScanModelVisitor(){

                @Override
                public void visit(IScanTarget target) {
                    target.setTransformed(true);
                }
            });
            this.fireScanStateChanged();
        } else if (this.getState() == ITransformable.State.TRANSFORMED && !transform) {
            this.m_location = this.m_prevLocation;
            this.m_prevLocation = null;
            this.fireScanStateChanged();
        }
    }

    @Override
    public ITransformable.State getState() {
        if (this.m_location == null && this.m_prevLocation != null) {
            return ITransformable.State.TRANSFORMED;
        }
        if (this.m_location != null && !this.m_targets.isEmpty()) {
            return ITransformable.State.CONFIGURED;
        }
        return ITransformable.State.NEW;
    }

    private void readCustomTargetInfo(File directory) {
        File file = new File(directory, ".customtargetinfo");
        if (file.exists()) {
            CustomTargetInfoReader reader = new CustomTargetInfoReader(file, this.m_customTargetInfos);
            try {
                reader.read();
            }
            catch (FileNotFoundException e) {
                this.m_logManager.log(new Message(e));
            }
            catch (XMLStreamException e) {
                this.m_customTargetInfos.clear();
                this.m_logManager.log(new Message(e));
            }
        }
    }

    private synchronized Map<String, CustomTargetInfo> getCustomTargetInfos() {
        if (this.m_customTargetInfos == null) {
            this.m_customTargetInfos = new Hashtable<String, CustomTargetInfo>();
            if (this.m_location != null) {
                this.readCustomTargetInfo(this.m_location.getWorkLocation());
            } else if (this.m_prevLocation != null) {
                this.readCustomTargetInfo(this.m_prevLocation.getWorkLocation());
            }
        }
        return this.m_customTargetInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomTargetInfo getCustomTargetInfo(String targetPath) {
        Map<String, CustomTargetInfo> infos;
        Map<String, CustomTargetInfo> map = infos = this.getCustomTargetInfos();
        synchronized (map) {
            CustomTargetInfo info = infos.get(targetPath);
            if (info == null) {
                info = new CustomTargetInfo();
                infos.put(targetPath, info);
            }
            return info;
        }
    }

    @Override
    public IScanModelVisitable getParent() {
        return null;
    }

    @Override
    public void accept(ScanModelVisitor visitor) {
        visitor.visit(this);
        for (IScanTarget target : this.m_targets) {
            target.accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public void notifyIncrement(IScanTarget target) {
        if (target.getErrorManager().getTotalErrors() == 1L) {
            ScanErrorEvent event = new ScanErrorEvent(this, target);
            for (IScanErrorListener listener : this.m_errorListeners) {
                listener.errorOccurred(event);
            }
        }
    }

    @Override
    public void notifyDecrement(IScanTarget target, int count) {
        if (target.getErrorManager().getTotalErrors() == 0L) {
            ScanErrorEvent event = new ScanErrorEvent(this, target);
            for (IScanErrorListener listener : this.m_errorListeners) {
                listener.errorsCleared(event);
            }
        }
    }

    private IScanTarget getScaTarget() {
        IScanTarget thirdPartyLibTarget = null;
        for (IScanTarget target : this.getScanTargets()) {
            if (!"ThirdPartyLib".equals(target.getName())) continue;
            thirdPartyLibTarget = target;
            break;
        }
        return thirdPartyLibTarget;
    }

    private boolean isScaTargetEmpty() {
        IScanTarget scaTarget = this.getScaTarget();
        int scaFileCount = scaTarget != null ? scaTarget.getScanFiles().size() : 0;
        return scaFileCount == 0;
    }

    private void dispose(SaveLocation location, SaveLocation newLocation, IProgress progress) throws IOException {
        boolean clearAll;
        boolean bl = clearAll = newLocation == null;
        if (clearAll) {
            this.accept(new DisposeVisitor(true, progress));
        }
        if (location != null) {
            this.m_logManager.close();
            File directory = location.getWorkLocation();
            if (directory.exists()) {
                File stager;
                if (SystemUtil.shouldDeleteFiles() && (stager = new File(directory, "stage")).exists()) {
                    try {
                        DirectoryUtil.delete(stager);
                    }
                    catch (IOException e) {
                        CommonCore.getIOConsole().println(e.getMessage());
                        stager.deleteOnExit();
                    }
                }
                try {
                    new IrsWriter().write(directory);
                }
                catch (IOException | ParserConfigurationException | TransformerException e) {
                    CommonCore.getIOConsole().println(e.getMessage());
                }
                File[] customsettingsFiles = DirectoryUtil.getMatchingFiles(directory, "custom.apsettings");
                if (customsettingsFiles.length == 0) {
                    PresetUtil.checkPresetHint(directory);
                }
                if (SystemUtil.isSecretsScanningDisabled()) {
                    new File(directory, ".nosecrets").createNewFile();
                }
                if (SystemUtil.isSecretsScanningEnabled()) {
                    new File(directory, ".secrets").createNewFile();
                }
                if (SystemUtil.isSecretsOnly()) {
                    new File(directory, ".secretsonly").createNewFile();
                }
                if (ScmUtil.getRepositoryUrl() != null) {
                    File scmSettings = new File(directory, ".scmsettings");
                    ScmUtil.writeScmSettings(scmSettings);
                }
                if (this.isScaTargetEmpty()) {
                    SystemUtil.setStaticAnalysisOnly();
                }
                PackageUtil.pack(directory, location.getFile());
                if (clearAll) {
                    if (SystemUtil.shouldDeleteScanFile()) {
                        System.clearProperty("DELETE_IRX");
                        DirectoryUtil.delete(location.getFile());
                    }
                    if (SystemUtil.shouldDeleteFiles()) {
                        DirectoryUtil.delete(directory);
                    }
                } else {
                    newLocation.copyWorkLocation(location);
                }
            }
        }
        this.m_prevLocation = null;
    }

    @Override
    public synchronized void close(IProgress progress) throws IOException {
        this.dispose(this.getSaveLocation(), null, progress);
        this.m_changeListeners.clear();
        this.m_errorListeners.clear();
        this.m_targets.clear();
        this.m_toDelete.clear();
        this.m_dirty = false;
        this.m_location = null;
        this.m_customTargetInfos = null;
    }
}

