/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.util.LRUMap;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.DeadEndVariable;
import com.ibm.wala.andromeda.core.TaintAnalyzer;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.management.AnalysisOptions;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Variable {
    private static final String SYSTEM_COLLECTIONS_IDICTIONARY = "LSystem/Collections/IDictionary";
    private static final String SYSTEM_WEB_SESSION_STATE_HTTP_SESSION_STATE = "LSystem/Web/SessionState/HttpSessionState";
    private final IMethod method;
    private final Context context;
    private final int varID;
    private final List<FieldReference> accessPath;
    private final boolean DEBUG = false;
    private int age = -1;
    private static final TypeReference JAVA_SESSION_TYPE_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)TypeName.string2TypeName((String)"Ljavax/servlet/http/HttpSession"));
    private static IClass mapClass;
    private static IClass httpSessionClass;
    private static Map<Pair<IMethod, Integer>, TypeReference> declaredTypesCache;
    private static final Map<FieldReference, Set<List<FieldReference>>> accessPaths;
    private static final int RECURSION_UNROLLING_BOUND = 2;
    private static final int ACCESS_PATH_LENGTH_BOUND = 3;
    public static final FieldReference DOT_STAR;
    public static final FieldReference ANONYMOUS;
    private static final List<FieldReference> DOT_STAR_ACCESS_PATH;
    private static final boolean PARANOID = false;
    public static final int UNINITIALIZED_AGE = -1;
    public static final int BASE_AGE = 10;

    protected Variable(IMethod method, Context ctxt, int varID, List<FieldReference> accessPath) {
        this.method = method;
        this.context = ctxt;
        this.varID = varID;
        this.accessPath = accessPath == null ? null : Collections.unmodifiableList(accessPath);
    }

    public static Variable failOrCreate(IMethod method, int varID, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis langServices) {
        return Variable.failOrCreate(method, (Context)Everywhere.EVERYWHERE, varID, accessPath, langServices);
    }

    public static Variable failOrCreate(IMethod method, Context ctxt, int varID, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis langServices) {
        boolean valid = true;
        if (method.getDeclaringClass().getClassLoader().getLanguage().equals(Language.JAVA)) {
            if (!(valid &= Variable.checkForNonTrivialAccessPathOnPrimitive(method, ctxt, varID, accessPath, langServices))) {
                return new DeadEndVariable(method, ctxt, varID);
            }
            if (!(valid &= Variable.checkForTaintOnConst(method, ctxt, varID))) {
                return new DeadEndVariable(method, ctxt, varID);
            }
        }
        if (!(valid &= AnalysisOptions.getPropagationPolicy().allowsAccessPath(accessPath))) {
            return new DeadEndVariable(method, ctxt, varID);
        }
        List<FieldReference> ap1 = Variable.computeAccessPathApproximation(method, ctxt, varID, accessPath, method.getClassHierarchy(), langServices);
        List<FieldReference> ap2 = Variable.accountForTransitiveFields(method, ctxt, varID, ap1, langServices);
        List<FieldReference> ap3 = Variable.reuseExisting(ap2);
        return new Variable(method, ctxt, varID, ap3);
    }

    private static List<FieldReference> accountForTransitiveFields(IMethod m, Context ctxt, int varID, List<FieldReference> ap, ILanguageSpecificServicesForFastanalysis langServices) {
        TypeReference t = Variable.getVariableDeclaredType(m, ctxt, varID, langServices);
        if (t != null && t.isReferenceType() && (ap == null || ap.size() == 0)) {
            return Variable.dotStarAccessPath();
        }
        return ap;
    }

    private static List<FieldReference> reuseExisting(List<FieldReference> ap) {
        if (ap == null || ap.isEmpty()) {
            return ap;
        }
        Set S = MapUtil.findOrCreateSet(accessPaths, (Object)ap.get(0));
        S.add(ap);
        return ap;
    }

    private static boolean checkForNonTrivialAccessPathOnPrimitive(IMethod method, Context ctxt, int varID, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis langServices) {
        if (accessPath != null) {
            assert (accessPath.size() > 0);
            TypeReference tr = Variable.getVariableDeclaredType(method, ctxt, varID, langServices);
            if (tr != null && tr.isPrimitiveType()) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkForTaintOnConst(IMethod method, Context c, int varID) {
        SymbolTable sb;
        IR ir;
        return varID == -1 || (ir = TaintAnalysisCache.soleInstance().getIR(method, c)) == null || !(sb = ir.getSymbolTable()).isConstant(varID);
    }

    public static boolean isArrayAccessQualifier(FieldReference fr) {
        return fr.equals((Object)ANONYMOUS) || fr.getDeclaringClass().equals((Object)TypeReference.Boolean) && fr.getFieldType().equals((Object)TypeReference.Int);
    }

    public static boolean isMapAccessQualifier(FieldReference fr) {
        return fr.equals((Object)ANONYMOUS) || fr.getDeclaringClass().equals((Object)TypeReference.Boolean) && fr.getFieldType().equals((Object)TypeReference.JavaLangString);
    }

    public static FieldReference getArrayAccessQualifier(int index) {
        return FieldReference.findOrCreate((TypeReference)TypeReference.Boolean, (Atom)Atom.findOrCreateUnicodeAtom((String)String.valueOf(index)), (TypeReference)TypeReference.Int);
    }

    public static FieldReference getMapAccessQualifier(String key) {
        return FieldReference.findOrCreate((TypeReference)TypeReference.Boolean, (Atom)Atom.findOrCreateUnicodeAtom((String)key), (TypeReference)TypeReference.JavaLangString);
    }

    public static List<FieldReference> dotStarAccessPath() {
        return DOT_STAR_ACCESS_PATH;
    }

    public static List<FieldReference> getAccessPathSegment(List<FieldReference> accessPath, int startIndex) {
        return Variable.getAccessPathSegment(accessPath, startIndex, accessPath.size() - 1);
    }

    public static List<FieldReference> getAccessPathSegment(List<FieldReference> accessPath, int startIndex, int endIndex) {
        if (startIndex >= accessPath.size()) {
            FieldReference fr = accessPath.get(accessPath.size() - 1);
            if (fr.equals((Object)DOT_STAR)) {
                return Variable.dotStarAccessPath();
            }
            return Variable.dotStarAccessPath();
        }
        if (endIndex >= accessPath.size()) {
            return null;
        }
        if (startIndex > endIndex) {
            return null;
        }
        ArrayList<FieldReference> result = new ArrayList<FieldReference>(endIndex - startIndex + 1);
        for (int index = startIndex; index <= endIndex; ++index) {
            result.add(accessPath.get(index));
        }
        return result;
    }

    public static TypeReference getVariableType(Variable var, ILanguageSpecificServicesForFastanalysis langServices) {
        return Variable.getVariableDeclaredType(var.getMethod(), var.getContext(), var.getVarID(), langServices);
    }

    private static Pair<Boolean, TypeReference> getVariableDeclaredTypeJS(IMethod m, Context ctxt, Set<Integer> history, SSAInstruction defInstr, Language l, ILanguageSpecificServicesForFastanalysis langServices) {
        if (defInstr instanceof JavaScriptCheckReference) {
            Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + defInstr.getClass().getName()));
        } else {
            if (defInstr instanceof JavaScriptInstanceOf) {
                Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + defInstr.getClass().getName()));
                return Pair.make((Object)true, (Object)JavaScriptTypes.Boolean);
            }
            if (defInstr instanceof JavaScriptPropertyRead) {
                JavaScriptPropertyRead read = (JavaScriptPropertyRead)defInstr;
                TypeReference tr = Variable.getVariableDeclaredType(m, ctxt, read.getMemberRef(), history, langServices);
                return Pair.make((Object)true, (Object)tr);
            }
            if (defInstr instanceof JavaScriptPropertyWrite) {
                Assertions.UNREACHABLE((String)("ERROR: A JavaScriptPropertyWrite does not have a def, so we should not be here: " + defInstr.toString()));
            } else {
                if (defInstr instanceof JavaScriptTypeOfInstruction) {
                    return Pair.make((Object)true, (Object)JavaScriptTypes.String);
                }
                if (defInstr instanceof JavaScriptWithRegion) {
                    Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + defInstr.getClass().getName()));
                } else if (defInstr instanceof AstAssertInstruction) {
                    Assertions.UNREACHABLE((String)("ERROR: An AstAssertInstruction does not have a def, so we should not be here: " + defInstr.getClass().getName()));
                } else {
                    if (defInstr instanceof AstGlobalRead) {
                        return Pair.make((Object)false, null);
                    }
                    if (defInstr instanceof AstGlobalWrite) {
                        Assertions.UNREACHABLE((String)("ERROR: An AstGlobalWrite does not have a def, so we should not be here: " + defInstr.getClass().getName()));
                    } else {
                        if (defInstr instanceof AstLexicalRead) {
                            AstLexicalRead read = (AstLexicalRead)defInstr;
                            return Pair.make((Object)true, null);
                        }
                        if (defInstr instanceof AstLexicalWrite) {
                            Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + defInstr.getClass().getName()));
                        } else {
                            if (defInstr instanceof EachElementGetInstruction) {
                                EachElementGetInstruction get = (EachElementGetInstruction)defInstr;
                                return Pair.make((Object)true, null);
                            }
                            if (defInstr instanceof EachElementHasNextInstruction) {
                                return Pair.make((Object)true, (Object)JavaScriptTypes.Boolean);
                            }
                            if (defInstr instanceof AstEchoInstruction) {
                                Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + defInstr.getClass().getName()));
                            } else if (defInstr instanceof AstIsDefinedInstruction) {
                                return Pair.make((Object)true, (Object)JavaScriptTypes.Boolean);
                            }
                        }
                    }
                }
            }
        }
        return Pair.make((Object)false, null);
    }

    private static Pair<Boolean, TypeReference> getVariableDeclaredTypeStandardWALA(IMethod m, Context ctxt, Set<Integer> history, SSAInstruction defInstr, Language l, ILanguageSpecificServicesForFastanalysis langServices) {
        if (defInstr instanceof SSACheckCastInstruction) {
            return Pair.make((Object)true, (Object)((SSACheckCastInstruction)defInstr).getDeclaredResultType());
        }
        if (defInstr instanceof SSAPhiInstruction) {
            HashSet typeReferences = HashSetFactory.make();
            for (int index = 0; index < defInstr.getNumberOfUses(); ++index) {
                TypeReference currentPhiPred = Variable.getVariableDeclaredType(m, ctxt, defInstr.getUse(index), history, langServices);
                if (currentPhiPred == null) continue;
                typeReferences.add(currentPhiPred);
            }
            if (typeReferences.size() > 0) {
                Iterator iter = typeReferences.iterator();
                TypeReference leastTR = (TypeReference)iter.next();
                IClassHierarchy cha = m.getClassHierarchy();
                while (iter.hasNext()) {
                    TypeReference current = (TypeReference)iter.next();
                    leastTR = cha.getLeastCommonSuperclass(current, leastTR);
                }
                return Pair.make((Object)true, (Object)leastTR);
            }
            return Pair.make((Object)true, null);
        }
        if (defInstr instanceof SSAGetInstruction) {
            return Pair.make((Object)true, (Object)((SSAGetInstruction)defInstr).getDeclaredFieldType());
        }
        if (defInstr instanceof SSAAbstractUnaryInstruction) {
            return Pair.make((Object)true, (Object)Variable.getVariableDeclaredType(m, ctxt, defInstr.getUse(0), history, langServices));
        }
        if (defInstr instanceof SSAArrayLengthInstruction) {
            return Pair.make((Object)true, (Object)Variable.getIntegerType(l));
        }
        if (defInstr instanceof SSAArrayLoadInstruction) {
            return Pair.make((Object)true, (Object)((SSAArrayLoadInstruction)defInstr).getElementType());
        }
        if (defInstr instanceof SSABinaryOpInstruction) {
            TypeReference A = Variable.getVariableDeclaredType(m, ctxt, defInstr.getUse(0), history, langServices);
            TypeReference B = Variable.getVariableDeclaredType(m, ctxt, defInstr.getUse(1), history, langServices);
            if (A != null && B != null) {
                return Pair.make((Object)true, (Object)m.getClassHierarchy().getLeastCommonSuperclass(A, B));
            }
            if (A != null) {
                return Pair.make((Object)true, (Object)A);
            }
            if (B != null) {
                return Pair.make((Object)true, (Object)B);
            }
            return Pair.make((Object)true, null);
        }
        if (defInstr instanceof SSAComparisonInstruction) {
            return Pair.make((Object)true, (Object)Variable.getBooleanType(l));
        }
        if (defInstr instanceof SSAConversionInstruction) {
            return Pair.make((Object)true, (Object)((SSAConversionInstruction)defInstr).getToType());
        }
        if (defInstr instanceof SSAInstanceofInstruction) {
            return Pair.make((Object)true, (Object)Variable.getBooleanType(l));
        }
        if (defInstr instanceof SSAGetCaughtExceptionInstruction) {
            return Pair.make((Object)true, (Object)Variable.getRootExceptionType(l));
        }
        if (defInstr instanceof SSALoadMetadataInstruction) {
            return Pair.make((Object)true, (Object)((SSALoadMetadataInstruction)defInstr).getType());
        }
        if (defInstr instanceof SSANewInstruction) {
            return Pair.make((Object)true, (Object)((SSANewInstruction)defInstr).getConcreteType());
        }
        if (defInstr instanceof SSAAbstractInvokeInstruction) {
            return Pair.make((Object)true, (Object)((SSAAbstractInvokeInstruction)defInstr).getDeclaredResultType());
        }
        if (defInstr instanceof SSAAddressOfInstruction) {
            return Pair.make((Object)true, (Object)Variable.getIntegerType(l));
        }
        Assertions.UNREACHABLE((String)("ERROR: did not expect def instruction " + defInstr));
        return Pair.make((Object)false, null);
    }

    private static TypeReference getVariableDeclaredType(IMethod m, Context ctxt, int varID, Set<Integer> history, ILanguageSpecificServicesForFastanalysis langServices) {
        if (varID == -1) {
            return m.getReturnType();
        }
        if (varID <= m.getNumberOfParameters()) {
            assert (varID > 0) : "ERROR: formal parameters are 1-based!";
            return m.getParameterType(varID - 1);
        }
        if (history.contains(varID)) {
            return null;
        }
        history.add(varID);
        Language l = m.getDeclaringClass().getClassLoader().getLanguage();
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, ctxt);
        if (du != null) {
            Pair<Boolean, TypeReference> ret;
            SSAInstruction defInstr = du.getDef(varID);
            if (defInstr == null) {
                IR ir = TaintAnalysisCache.soleInstance().getIR(m, ctxt);
                SymbolTable sb = ir.getSymbolTable();
                if (varID == -1) {
                    return m.getReturnType();
                }
                if (langServices.isParameter(varID, sb.getNumberOfParameters())) {
                    return m.getParameterType(varID - 1);
                }
                if (sb.isConstant(varID)) {
                    if (sb.isBooleanConstant(varID)) {
                        return Variable.getBooleanType(l);
                    }
                    if (sb.isDoubleConstant(varID)) {
                        return Variable.getDoubleType(l);
                    }
                    if (sb.isFloatConstant(varID)) {
                        return Variable.getFloatType(l);
                    }
                    if (sb.isIntegerConstant(varID)) {
                        return Variable.getIntegerType(l);
                    }
                    if (sb.isLongConstant(varID)) {
                        return Variable.getLongType(l);
                    }
                    if (sb.isNullConstant(varID)) {
                        return Variable.getNullType(l);
                    }
                    if (sb.isNumberConstant(varID)) {
                        return Variable.getNumberType(l);
                    }
                    if (sb.isStringConstant(varID)) {
                        return Variable.getStringType(l);
                    }
                    Assertions.UNREACHABLE();
                    return null;
                }
                return null;
            }
            if (TaintAnalyzer.isJavaScript(m)) {
                ret = Variable.getVariableDeclaredTypeJS(m, ctxt, history, defInstr, l, langServices);
                if (((Boolean)ret.fst).booleanValue()) {
                    return (TypeReference)ret.snd;
                }
            }
            ret = Variable.getVariableDeclaredTypeStandardWALA(m, ctxt, history, defInstr, l, langServices);
            if (((Boolean)ret.fst).booleanValue()) {
                return (TypeReference)ret.snd;
            }
            Assertions.UNREACHABLE((String)"There is already an assertion in a called function that will assure that we never get here");
            return null;
        }
        return null;
    }

    private static TypeReference getRootExceptionType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.JavaLangException;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.SystemException;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Undefined;
        }
        return null;
    }

    private static TypeReference getStringType(Language l) {
        return l.getStringType();
    }

    private static TypeReference getNumberType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (String)"Ljava/lang/Number");
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Number;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    private static TypeReference getNullType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Null;
        }
        if (l == CLRLanguage.lang) {
            return null;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Null;
        }
        return null;
    }

    private static TypeReference getLongType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Long;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.Int64;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Number;
        }
        return null;
    }

    private static TypeReference getIntegerType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Int;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.Int32;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Number;
        }
        return null;
    }

    private static TypeReference getFloatType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Float;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.Float32;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Number;
        }
        return null;
    }

    private static TypeReference getDoubleType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Double;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.Float64;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Number;
        }
        return null;
    }

    private static TypeReference getBooleanType(Language l) {
        if (l == Language.JAVA) {
            return TypeReference.Boolean;
        }
        if (l == CLRLanguage.lang) {
            return CLRTypeReference.Boolean;
        }
        if (l == JavaScriptLoader.JS) {
            return JavaScriptTypes.Boolean;
        }
        return null;
    }

    private static TypeReference getVariableDeclaredType(IMethod m, Context ctxt, int varID, ILanguageSpecificServicesForFastanalysis langServices) {
        Pair p = Pair.make((Object)m, (Object)varID);
        TypeReference result = declaredTypesCache.get(p);
        if (result == null) {
            result = Variable.getVariableDeclaredType(m, ctxt, varID, HashSetFactory.make(), langServices);
            declaredTypesCache.put((Pair<IMethod, Integer>)p, result);
        }
        return result;
    }

    private static List<FieldReference> computeAccessPathApproximation(IMethod m, Context ctxt, int varID, List<FieldReference> accessPath, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis langServices) {
        List<FieldReference> result = accessPath;
        if (result != null) {
            if (Variable.isExcessivelyLong(result = Variable.normalizeAccessPath(result))) {
                result = Variable.constrainAccessPath(result);
            }
            if (Variable.isRecursive(result, cha)) {
                result = Variable.dotStarAccessPath();
            }
        }
        if (Variable.isMisqualifiedSpecialContainerAccessPath(m, ctxt, varID, result, langServices)) {
            ArrayList<FieldReference> modifiedResult = new ArrayList<FieldReference>(result == null ? 1 : result.size() + 1);
            modifiedResult.add(0, ANONYMOUS);
            if (result != null) {
                modifiedResult.addAll(result);
            }
            result = modifiedResult;
        }
        return result;
    }

    public static boolean isMethodResult(Variable var) {
        SSAInstruction defInstr;
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(var.getMethod(), var.getContext());
        return du != null && (defInstr = du.getDef(var.getVarID())) != null && defInstr instanceof SSAAbstractInvokeInstruction;
    }

    public static boolean isStaticField(Variable var) {
        SSAInstruction defInstr;
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(var.getMethod(), var.getContext());
        if (du != null && (defInstr = du.getDef(var.getVarID())) != null && defInstr instanceof SSAGetInstruction) {
            return ((SSAGetInstruction)defInstr).isStatic();
        }
        return false;
    }

    public static boolean isReturnValue(Variable v) {
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(v.getMethod(), v.getContext());
        if (du != null) {
            Iterator instrIter = du.getUses(v.getVarID());
            while (instrIter.hasNext()) {
                SSAInstruction instr = (SSAInstruction)instrIter.next();
                if (!(instr instanceof SSAReturnInstruction)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<FieldReference> constrainAccessPath(List<FieldReference> path) {
        assert (path.size() > 3);
        ArrayList<FieldReference> result = new ArrayList<FieldReference>(path.size());
        for (int index = 0; index < 3; ++index) {
            result.add(path.get(index));
        }
        result.add(DOT_STAR);
        return result;
    }

    private static boolean isExcessivelyLong(List<FieldReference> accessPath) {
        assert (accessPath != null);
        return accessPath.size() > 3;
    }

    private static boolean isRecursive(List<FieldReference> accessPath, final IClassHierarchy cha) {
        TreeMap<FieldReference, Integer> countingMap = new TreeMap<FieldReference, Integer>(new Comparator<FieldReference>(){

            @Override
            public int compare(FieldReference object1, FieldReference object2) {
                return Variable.areFieldReferencesCompatible(object1, object2, cha) ? 0 : 1;
            }
        });
        Iterator<Object> iterator = accessPath.iterator();
        while (iterator.hasNext()) {
            FieldReference fr;
            Integer count = (Integer)countingMap.get(fr = iterator.next());
            countingMap.put(fr, count == null ? 1 : (Integer)countingMap.get(fr) + 1);
        }
        iterator = countingMap.values().iterator();
        while (iterator.hasNext()) {
            int fieldCount = (Integer)iterator.next();
            if (fieldCount <= 2) continue;
            return true;
        }
        return false;
    }

    private static boolean isMisqualifiedSpecialContainerAccessPath(IMethod m, Context ctxt, int varID, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis langServices) {
        TypeReference varType = Variable.getVariableDeclaredType(m, ctxt, varID, langServices);
        Language l = m.getDeclaringClass().getClassLoader().getLanguage();
        if (varType != null && Variable.isSpecialContainerType(l, varType, m.getClassHierarchy())) {
            if (accessPath == null) {
                return true;
            }
            assert (accessPath.size() > 0);
            FieldReference firstAccessPathElement = accessPath.get(0);
            if (!Variable.isArrayAccessQualifier(firstAccessPathElement) && !Variable.isMapAccessQualifier(firstAccessPathElement)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecialContainerType(Language l, TypeReference varType, IClassHierarchy cha) {
        if (varType.isArrayType()) {
            return true;
        }
        IClass c = cha.lookupClass(varType);
        if (c != null) {
            if (mapClass == null) {
                if (l == Language.JAVA) {
                    mapClass = cha.lookupClass(TypeReference.JavaUtilMap);
                } else if (l == CLRLanguage.lang) {
                    mapClass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_COLLECTIONS_IDICTIONARY));
                } else {
                    assert (l == JavaScriptLoader.JS);
                    mapClass = null;
                }
            }
            if (mapClass != null && cha.isAssignableFrom(mapClass, c)) {
                return true;
            }
            if (httpSessionClass == null) {
                if (l == Language.JAVA) {
                    httpSessionClass = cha.lookupClass(JAVA_SESSION_TYPE_REF);
                } else if (l == CLRLanguage.lang) {
                    httpSessionClass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)c.getClassLoader().getReference(), (String)SYSTEM_WEB_SESSION_STATE_HTTP_SESSION_STATE));
                } else {
                    assert (l == JavaScriptLoader.JS);
                    httpSessionClass = null;
                }
            }
            if (httpSessionClass != null && cha.isAssignableFrom(httpSessionClass, c)) {
                return true;
            }
        }
        return false;
    }

    private static List<FieldReference> normalizeAccessPath(List<FieldReference> accessPath) {
        assert (accessPath != null);
        int indexOfDotStar = accessPath.indexOf(DOT_STAR);
        if (indexOfDotStar >= 0 && indexOfDotStar < accessPath.size() - 1) {
            ArrayList<FieldReference> result = new ArrayList<FieldReference>(indexOfDotStar + 1);
            for (int index = 0; index <= indexOfDotStar; ++index) {
                result.add(accessPath.get(index));
            }
            return result;
        }
        return accessPath;
    }

    private static boolean hasExcessiveRecursionInPrefix(List<FieldReference> accessPath, IClassHierarchy cha) {
        int accessPathSize = accessPath.size();
        boolean checkForMatches = true;
        boolean proceedToNextPatternLength = true;
        int numberOfMatches = 0;
        int patternLength = 1;
        while ((double)patternLength <= Math.ceil(accessPathSize / 2)) {
            int prefixIndex;
            int startIndex = prefixIndex = 0;
            while (checkForMatches) {
                boolean isMatch = Variable.compareAccessPathSegments(accessPath, startIndex += patternLength, prefixIndex, patternLength, cha);
                proceedToNextPatternLength &= !isMatch;
                numberOfMatches = isMatch ? numberOfMatches + 1 : numberOfMatches;
                checkForMatches = startIndex < accessPathSize && numberOfMatches < 2;
            }
            if (!proceedToNextPatternLength) break;
            ++patternLength;
        }
        return numberOfMatches >= 2;
    }

    private static boolean hasExcessiveRecursionInSuffix(List<FieldReference> accessPath, IClassHierarchy cha) {
        int accessPathSize = accessPath.size();
        boolean checkForMatches = true;
        boolean proceedToNextPatternLength = true;
        int numberOfMatches = 0;
        int patternLength = 1;
        while ((double)patternLength <= Math.ceil(accessPathSize / 2)) {
            int suffixIndex;
            int startIndex = suffixIndex = accessPathSize - patternLength;
            while (checkForMatches) {
                boolean isMatch = Variable.compareAccessPathSegments(accessPath, startIndex -= patternLength, suffixIndex, patternLength, cha);
                proceedToNextPatternLength &= !isMatch;
                numberOfMatches = isMatch ? numberOfMatches + 1 : numberOfMatches;
                checkForMatches = startIndex > 0 && numberOfMatches < 2;
            }
            if (!proceedToNextPatternLength) break;
            ++patternLength;
        }
        return numberOfMatches >= 2;
    }

    private static boolean compareAccessPathSegments(List<FieldReference> accessPath, int startIndex, int refIndex, int patternLength, IClassHierarchy cha) {
        if (startIndex < 0 || refIndex < 0 || refIndex >= accessPath.size() || startIndex >= accessPath.size()) {
            return false;
        }
        for (int i = startIndex; i < startIndex + patternLength; ++i) {
            for (int j = refIndex; j < refIndex + patternLength; ++j) {
                if (Variable.areFieldReferencesCompatible(accessPath.get(i), accessPath.get(j), cha)) continue;
                return false;
            }
        }
        return true;
    }

    public IMethod getMethod() {
        return this.method;
    }

    public MethodReference getMethodRef() {
        return this.method.getReference();
    }

    public int getVarID() {
        return this.varID;
    }

    public List<FieldReference> getAccessPath() {
        if (this.accessPath == null) {
            return null;
        }
        return this.accessPath;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this.method);
        result.append(":");
        result.append(this.context == null ? "NULL" : this.context.toString());
        result.append(",");
        result.append(this.varID);
        result.append(",");
        if (this.accessPath == null) {
            result.append("---");
        } else {
            for (int index = 0; index < this.accessPath.size(); ++index) {
                FieldReference current = this.accessPath.get(index);
                if (current.equals((Object)DOT_STAR)) {
                    result.append("*");
                } else if (current.equals((Object)ANONYMOUS)) {
                    result.append("?");
                } else {
                    result.append(current.getName().toString());
                }
                if (index >= this.accessPath.size() - 1) continue;
                result.append(".");
            }
        }
        result.append(")");
        return result.toString();
    }

    private int getAccessPathHashCode(List<FieldReference> accessPath) {
        int result = 0;
        if (accessPath != null) {
            for (FieldReference fr : accessPath) {
                result += fr.getName().hashCode();
                result += fr.getFieldType().hashCode();
            }
        }
        return result;
    }

    public static boolean isFakeField(FieldReference fr) {
        return fr.equals((Object)DOT_STAR) || Variable.isArrayAccessQualifier(fr) || Variable.isMapAccessQualifier(fr);
    }

    public static boolean areFieldReferencesCompatible(FieldReference firstFieldReference, FieldReference secondFieldReference, IClassHierarchy cha) {
        if (firstFieldReference == null) {
            Assertions.UNREACHABLE();
        }
        if (secondFieldReference == null) {
            Assertions.UNREACHABLE();
        }
        if (Variable.isFakeField(firstFieldReference) && Variable.isFakeField(secondFieldReference)) {
            return firstFieldReference.equals((Object)secondFieldReference);
        }
        if (firstFieldReference.equals((Object)DOT_STAR) || secondFieldReference.equals((Object)DOT_STAR)) {
            return true;
        }
        if (secondFieldReference.getFieldType().equals((Object)firstFieldReference.getFieldType()) && secondFieldReference.getName().equals((Object)firstFieldReference.getName())) {
            IClass firstClass = cha.lookupClass(firstFieldReference.getDeclaringClass());
            IClass secondClass = cha.lookupClass(secondFieldReference.getDeclaringClass());
            if (firstClass != null && secondClass != null && (cha.isAssignableFrom(firstClass, secondClass) || cha.isAssignableFrom(secondClass, firstClass))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSubsumedBy(List<FieldReference> ap1, List<FieldReference> ap2, IClassHierarchy cha) {
        if (ap1 == null && ap2 == null) {
            return true;
        }
        if (ap1 != null && ap2 == null) {
            return true;
        }
        if (ap1 == null && ap2 != null) {
            return false;
        }
        if (Variable.areAccessPathsCompatible(ap1, ap2, cha)) {
            boolean isDotStarAccessPath1 = Variable.isDotStarAccessPath(ap1);
            boolean isDotStarAccessPath2 = Variable.isDotStarAccessPath(ap2);
            if (isDotStarAccessPath1 && isDotStarAccessPath2) {
                return ap1.indexOf(DOT_STAR) <= ap2.indexOf(DOT_STAR);
            }
            if (isDotStarAccessPath1 && !isDotStarAccessPath2) {
                return true;
            }
            return isDotStarAccessPath1 || !isDotStarAccessPath2;
        }
        return false;
    }

    public static boolean areAccessPathsCompatible(List<FieldReference> accessPath1, List<FieldReference> accessPath2, IClassHierarchy cha) {
        if (Variable.isDotStarAccessPath(accessPath1) || Variable.isDotStarAccessPath(accessPath2)) {
            return Variable.areDotStarAccessPathsCompatible(accessPath1, accessPath2, cha);
        }
        return Variable.areNonDotStartAccessPathsCompatible(accessPath1, accessPath2, cha);
    }

    private static boolean areNonDotStartAccessPathsCompatible(List<FieldReference> accessPath1, List<FieldReference> accessPath2, IClassHierarchy cha) {
        if (accessPath1 != null) assert (!accessPath1.contains(DOT_STAR));
        if (accessPath2 != null) assert (!accessPath2.contains(DOT_STAR));
        if (accessPath1 != null && accessPath2 != null) {
            if (accessPath1.size() == accessPath2.size()) {
                for (int index = 0; index < accessPath1.size(); ++index) {
                    if (Variable.areFieldReferencesCompatible(accessPath1.get(index), accessPath2.get(index), cha)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (accessPath1 != null && accessPath2 == null) {
            return false;
        }
        return accessPath1 != null || accessPath2 == null;
    }

    private static boolean isDotStarAccessPath(List<FieldReference> accessPath) {
        return accessPath != null && accessPath.contains(DOT_STAR);
    }

    private static boolean areDotStarAccessPathsCompatible(List<FieldReference> accessPath1, List<FieldReference> accessPath2, IClassHierarchy cha) {
        assert (Variable.isDotStarAccessPath(accessPath1) || Variable.isDotStarAccessPath(accessPath2));
        if (accessPath2 == null) {
            return accessPath1 != null && accessPath1.size() > 0 && accessPath1.get(0).equals((Object)DOT_STAR);
        }
        if (accessPath1 == null) {
            return accessPath2 != null && accessPath2.size() > 0 && accessPath2.get(0).equals((Object)DOT_STAR);
        }
        int indexOfDotStar1 = accessPath1.indexOf(DOT_STAR);
        int loopUntil1 = indexOfDotStar1 == -1 ? accessPath1.size() : indexOfDotStar1;
        int indexOfDotStar2 = accessPath2.indexOf(DOT_STAR);
        int loopUntil2 = indexOfDotStar2 == -1 ? accessPath2.size() : indexOfDotStar2;
        int loopUntil = Math.min(loopUntil1, loopUntil2);
        for (int index = 0; index < loopUntil; ++index) {
            if (Variable.areFieldReferencesCompatible(accessPath1.get(index), accessPath2.get(index), cha)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + this.varID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return this.varID == other.varID;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    public Context getContext() {
        return this.context;
    }

    static {
        declaredTypesCache = new LRUMap<Pair<IMethod, Integer>, TypeReference>(100);
        accessPaths = HashMapFactory.make();
        DOT_STAR = FieldReference.findOrCreate((TypeReference)TypeReference.Boolean, (Atom)Atom.findOrCreateUnicodeAtom((String)"invalid"), (TypeReference)TypeReference.Boolean);
        ANONYMOUS = FieldReference.findOrCreate((TypeReference)TypeReference.Boolean, (Atom)Atom.findOrCreateUnicodeAtom((String)"anonymous"), (TypeReference)TypeReference.Boolean);
        DOT_STAR_ACCESS_PATH = new ArrayList<FieldReference>(1);
        DOT_STAR_ACCESS_PATH.add(DOT_STAR);
    }
}

