/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTaintRule {
    protected final Collection<MethodReference> sourceRefs = HashSetFactory.make();
    protected final Collection<MethodReference> sinkRefs = HashSetFactory.make();
    protected final Collection<MethodReference> sanitizerRefs = HashSetFactory.make();
    protected final IClassHierarchy cha;
    protected final Map<Selector, Set<IClass>> sinkMethodResolutionMap = HashMapFactory.make();
    protected final Map<Selector, Set<IClass>> sourceMethodResolutionMap = HashMapFactory.make();
    protected final Map<Selector, Set<IClass>> sanitizerMethodResolutionMap = HashMapFactory.make();

    protected AbstractTaintRule(IClassHierarchy cha) {
        this.cha = cha;
    }

    public Collection<MethodReference> getSourceRefs() {
        return this.sourceRefs;
    }

    public Collection<MethodReference> getSinkRefs() {
        return this.sinkRefs;
    }

    public Collection<MethodReference> getSanitizerRefs() {
        return this.sanitizerRefs;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public boolean accepts(MethodReference sourceMR, MethodReference sinkMR) {
        return this.acceptsSource(sourceMR) && this.acceptsSink(sinkMR);
    }

    public boolean acceptsSource(MethodReference sourceMR) {
        Set<IClass> srcRange = this.sourceMethodResolutionMap.get(sourceMR.getSelector());
        if (srcRange != null) {
            IClass srcClass = this.cha.lookupClass(sourceMR.getDeclaringClass());
            return this.isAssignableFromAny(srcClass, srcRange);
        }
        return false;
    }

    public boolean acceptsSink(MethodReference sinkMR) {
        Set<IClass> sinkRange = this.sinkMethodResolutionMap.get(sinkMR.getSelector());
        if (sinkRange != null) {
            IClass sinkClass = this.cha.lookupClass(sinkMR.getDeclaringClass());
            return this.isAssignableFromAny(sinkClass, sinkRange);
        }
        return false;
    }

    public boolean acceptsSanitizer(MethodReference sanitizerMR) {
        Set<IClass> sanitizerRange = this.sanitizerMethodResolutionMap.get(sanitizerMR.getSelector());
        if (sanitizerRange != null) {
            IClass sanitizerClass = this.cha.lookupClass(sanitizerMR.getDeclaringClass());
            return this.isAssignableFromAny(sanitizerClass, sanitizerRange);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SOURCES:\n");
        buf.append(this.sourceRefs);
        buf.append("\nSANITIZERS:\n");
        buf.append(this.sanitizerRefs);
        buf.append("\nSINKS:\n");
        buf.append(this.sinkRefs);
        return buf.toString();
    }

    private boolean isAssignableFromAny(IClass klass, Set<IClass> classes) {
        assert (klass != null) : "ERROR: cannot check assignability for null class";
        for (IClass c : classes) {
            if (!this.cha.isAssignableFrom(c, klass)) continue;
            return true;
        }
        return false;
    }
}

