/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.harness.CompareResults;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutputTable {
    private static String TXT_OUTPUT_NAME = "output_table.txt";
    private static String LATEX_OUTPUT_NAME = "output_table.tex";

    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException {
        String line;
        if (args.length != 1) {
            System.out.println("Please pass in the folder where the result files are!");
            return;
        }
        String resultsFolderPath = args[0];
        File resultsFolder = new File(resultsFolderPath);
        File[] allFiles = resultsFolder.listFiles();
        HashMap m = HashMapFactory.make();
        for (File f : allFiles) {
            String fName = f.getName();
            if (!fName.startsWith("results")) continue;
            String key = fName.substring(0, fName.indexOf(95));
            File[] F = (File[])m.get(key);
            if (F == null) {
                F = new File[2];
                m.put(key, F);
            }
            if (fName.endsWith("with")) {
                F[0] = f;
                continue;
            }
            assert (fName.endsWith("without"));
            F[1] = f;
        }
        File statsFile = new File(resultsFolderPath, "taint_runner_stats_with_summaries.txt");
        BufferedReader br = new BufferedReader(new FileReader(statsFile));
        int idx = 1;
        HashMap taintRunnerStats = HashMapFactory.make();
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) continue;
            taintRunnerStats.put(idx++, new TaintRunnerStats(line));
        }
        br.close();
        File codeGenStatsFile = new File(resultsFolderPath, "code_gen_time.txt");
        br = new BufferedReader(new FileReader(codeGenStatsFile));
        idx = 1;
        HashMap codeGenTimes = HashMapFactory.make();
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) continue;
            long codeGenTime = Long.parseLong(line.split(" ")[0]);
            codeGenTimes.put(idx++, codeGenTime);
        }
        br.close();
        LinkedList<TableRow> tableRows = new LinkedList<TableRow>();
        for (Map.Entry e : m.entrySet()) {
            ObjectInputStream resWthoutStream;
            Set resultsWthout;
            File withFrameworks = ((File[])e.getValue())[0];
            File wthoutFrameworks = ((File[])e.getValue())[1];
            if (withFrameworks == null || wthoutFrameworks == null) continue;
            int keyAsInt = Integer.valueOf(((String)e.getKey()).substring("results".length()));
            TaintRunnerStats withFrameworksStats = (TaintRunnerStats)taintRunnerStats.get(keyAsInt * 2);
            TaintRunnerStats withoutFrameworksStats = (TaintRunnerStats)taintRunnerStats.get(keyAsInt * 2 - 1);
            long codeGenTime = (Long)codeGenTimes.get(keyAsInt);
            ObjectInputStream resWthStream = new ObjectInputStream(new FileInputStream(withFrameworks));
            Set resultsWth = (Set)resWthStream.readObject();
            if (!(resultsWth instanceof HashSet)) {
                resultsWth = HashSetFactory.make((Collection)resultsWth);
            }
            if (!((resultsWthout = (Set)(resWthoutStream = new ObjectInputStream(new FileInputStream(wthoutFrameworks))).readObject()) instanceof HashSet)) {
                resultsWthout = HashSetFactory.make((Collection)resultsWthout);
            }
            int numResultsWith = resultsWth.size();
            int numResultsWithout = resultsWthout.size();
            CompareResults.ComparisonResult comparison = CompareResults.compare(resultsWth, resultsWthout);
            int numResultsInCommon = comparison.inBoth;
            int numResultsWithOnly = comparison.onlyInLhs;
            int numResultsWithoutOnly = comparison.onlyInRhs;
            TableRow tr = new TableRow(withFrameworksStats.appName, numResultsWith, withFrameworksStats.cgSize, (long)withFrameworksStats.time + codeGenTime, numResultsWithout, withoutFrameworksStats.cgSize, withoutFrameworksStats.time, numResultsInCommon, numResultsWithOnly, numResultsWithoutOnly);
            tableRows.add(tr);
        }
        OutputTable.printLatexTable(tableRows);
        OutputTable.printTxtTable(tableRows);
    }

    private static void printLatexTable(List<TableRow> rows) throws IOException {
        FileWriter fw = new FileWriter(LATEX_OUTPUT_NAME);
        fw.write("\n\n\n\n\n");
        fw.write(TableRow.latexHeader());
        fw.write("\n");
        for (TableRow tr : rows) {
            fw.write(tr.toLatexRow());
            fw.write("\n");
        }
        fw.write(TableRow.latexFooter());
        fw.write("\n");
        fw.write("\n\n\n\n\n");
        fw.close();
    }

    private static void printTxtTable(List<TableRow> rows) throws IOException {
        FileWriter fw = new FileWriter(TXT_OUTPUT_NAME);
        fw.write(TableRow.txtHeader());
        fw.write("\n");
        for (TableRow tr : rows) {
            fw.write(tr.toTxtRow());
            fw.write("\n");
        }
        fw.close();
    }

    public static class TableRow {
        private final String appName;
        private final int numResultsWith;
        private final int cgSizeWith;
        private final long timeWith;
        private final int numResultsWithout;
        private final int cgSizeWithout;
        private final long timeWithout;
        private final int numResultsInCommon;
        private final int numResultsWithOnly;
        private final int numResultsWithoutOnly;

        private static String lineForTxtFile(String c1, String c2, String c3, String c4, String c5, String c6, String c7, String c8, String c9, String c10, String c11) {
            return String.format("%1$20s%2$13s%3$15s%4$12s%5$16s%6$19s%7$15s%8$20s%9$20s%10$20s%11$20s", c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11);
        }

        public static String txtHeader() {
            return TableRow.lineForTxtFile("App name", "# res. with", "cg size with", "time with", "# res. without", "cg size without", "time without", "# res. in common", "w/o - w # results", "w/o - w cg size", "w/o - w time");
        }

        public static String latexHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append("\\begin{table*}");
            sb.append("\n");
            sb.append("\\begin{center}");
            sb.append("\n");
            sb.append("\\begin{tabular}{|c|c|c|c|c|c|c|c|c|}");
            sb.append("\n");
            sb.append("\\hline");
            sb.append("\n");
            sb.append("\\multirow{2}{*}{Benchmark} & \\multicolumn{4}{c|}{With Frameworks} & \\multicolumn{4}{c|}{Without Frameworks}\\\\");
            sb.append("\n");
            sb.append("\\cline{2-9}");
            sb.append("\n");
            sb.append("\\  & Issues & Excl. (TP / FP) & CG Size & Time (s)  & Issues & Excl. (TP / FP) & CG Size & Time (s) \\\\");
            sb.append("\n");
            sb.append("\\hline");
            sb.append("\n");
            sb.append("\\hline");
            sb.append("\n");
            return sb.toString();
        }

        public static String latexFooter() {
            StringBuilder sb = new StringBuilder();
            sb.append("\\end{tabular}\n");
            sb.append("\\end{center}\n");
            sb.append("\\caption{Data on number of issues reported, call graph size, and running time for each of our benchmarks analyzed with and without frameworks support.  The ``Excl. (TP / FP)'' column gives the number of issues reported exclusively in that configuration (with or without frameworks), additionally categorized into the number of true and false positives.}");
            sb.append("\\label{tab:results}\n");
            sb.append("\\end{table*}");
            return sb.toString();
        }

        public TableRow(String appName, int numResultsWith, int cgSizeWith, long timeWith, int numResultsWithout, int cgSizeWithout, long timeWithout, int numResultsInCommon, int numResultsWithOnly, int numResultsWithoutOnly) {
            this.appName = appName;
            this.numResultsWith = numResultsWith;
            this.cgSizeWith = cgSizeWith;
            this.timeWith = timeWith;
            this.numResultsWithout = numResultsWithout;
            this.cgSizeWithout = cgSizeWithout;
            this.timeWithout = timeWithout;
            this.numResultsInCommon = numResultsInCommon;
            this.numResultsWithOnly = numResultsWithOnly;
            this.numResultsWithoutOnly = numResultsWithoutOnly;
        }

        public String toTxtRow() {
            return TableRow.lineForTxtFile(this.getAppName(), Integer.toString(this.numResultsWith), Integer.toString(this.cgSizeWith), Long.toString(this.timeWith), Integer.toString(this.numResultsWithout), Integer.toString(this.cgSizeWithout), Long.toString(this.timeWithout), Integer.toString(this.numResultsInCommon), Integer.toString(this.numResultsWithout - this.numResultsWith), Integer.toString(this.cgSizeWithout - this.cgSizeWith), Long.toString(this.timeWithout - this.timeWith));
        }

        public String toLatexRow() {
            StringBuilder row = new StringBuilder();
            row.append("\\bench{" + this.getAppName() + "}");
            row.append(" & ");
            row.append(this.numResultsWith);
            row.append(" & ");
            row.append(this.numResultsWithOnly);
            if (this.numResultsWithOnly == 0) {
                row.append(" (0 / 0)");
            } else {
                row.append(" ( / )");
            }
            row.append(" & ");
            row.append(this.cgSizeWith);
            row.append(" & ");
            row.append(Math.round((double)this.timeWith / 1000.0));
            row.append(" & ");
            row.append(this.numResultsWithout);
            row.append(" & ");
            row.append(this.numResultsWithoutOnly);
            if (this.numResultsWithoutOnly == 0) {
                row.append(" (0 / 0)");
            } else {
                row.append(" ( / )");
            }
            row.append(" & ");
            row.append(this.cgSizeWithout);
            row.append(" & ");
            row.append(Math.round((double)this.timeWithout / 1000.0));
            row.append("\\\\");
            row.append("\n");
            row.append("\\hline\n");
            return row.toString();
        }

        private String getAppName() {
            return this.appName.equals("Cisco") ? "AppA" : this.appName;
        }
    }

    public static class TaintRunnerStats {
        public String appName;
        public int time;
        public int cgSize;
        public int numResults;

        public TaintRunnerStats(String line) {
            String[] lineParts = line.split(",");
            if (lineParts.length != 4) {
                throw new RuntimeException("The line did not have 4 parts and it should have: " + line);
            }
            String longAppName = lineParts[0];
            this.appName = longAppName.substring(longAppName.lastIndexOf(47) + 1);
            if (this.appName.endsWith("Scope.txt")) {
                this.appName = this.appName.substring(0, this.appName.length() - "Scope.txt".length());
            }
            this.time = Integer.parseInt(lineParts[1].trim());
            this.cgSize = Integer.parseInt(lineParts[2].trim());
            this.numResults = Integer.parseInt(lineParts[3].trim());
        }
    }
}

