/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.modular;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.incremental.SummaryCache;
import com.ibm.wala.andromeda.lang.DotNetServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.modular.ConcreteResolutionEnumerator;
import com.ibm.wala.andromeda.modular.ContextualSummary;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.loader.csharp.CSharpInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.BFSPathFinder;
import com.ibm.wala.util.io.FileProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.jar.JarFile;

public class FlowAnalyzerRunner {
    private final IClassHierarchy cha;
    private final ILangServices langServices;
    private final ILanguageSpecificServicesForFastanalysis fastLangServices;
    private final ConcreteResolutionEnumerator enumerator;
    private OfflineSpecification spec;

    public FlowAnalyzerRunner(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fast_lang_services) {
        this.cha = cha;
        this.langServices = langServices;
        this.fastLangServices = fast_lang_services;
        this.enumerator = new ConcreteResolutionEnumerator(cha);
        this.spec = this.loadOfflineSpecification();
    }

    public static void main0(String[] args) throws ClassHierarchyException, InvalidClassFileException, IOException {
        block5: {
            FlowAnalyzerRunner runner;
            ClassHierarchy cha;
            String language;
            block4: {
                String analysisScopePath = args[1];
                language = args[0];
                cha = null;
                runner = null;
                if (!language.equals("DOTNET")) break block4;
                CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> scope = FlowAnalyzerRunner.getDotNetAnalysisScope(analysisScopePath);
                cha = ClassHierarchy.make(scope, (ClassLoaderFactory)((ClassLoaderFactory)scope), (Language)CLRLanguage.lang);
                runner = new FlowAnalyzerRunner((IClassHierarchy)cha, ILangServices.DOTNET, DotNetServicesForFastanalysis.DOTNET);
                for (IClass c : cha) {
                    if (!c.getClassLoader().getReference().getName().toString().toLowerCase().contains("system.web")) continue;
                    for (IMethod m : c.getAllMethods()) {
                        if (m.isNative() || m.isAbstract() || !m.isPublic() || !m.getDeclaringClass().getName().toString().toLowerCase().contains("system/web") || !runner.isEligibleForSummary(m)) continue;
                        runner.summarizeTaintPropagation(m);
                    }
                }
                break block5;
            }
            if (!language.equals("JAVA")) break block5;
            AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
            scope.addToScope(ClassLoaderReference.Primordial, new JarFile(args[2]));
            cha = ClassHierarchy.make((AnalysisScope)scope);
            runner = new FlowAnalyzerRunner((IClassHierarchy)cha, ILangServices.JAVA, JavaServicesForFastanalysis.JAVA);
            for (IClass c : cha) {
                if (c.isInterface() || c.isPrivate() || !c.isReferenceType()) continue;
                for (IMethod m : c.getDeclaredMethods()) {
                    if (!m.isPublic() || m.isAbstract() || m.isSynthetic() || m.isNative() || !runner.isEligibleForSummary(m) || !m.getSignature().startsWith(args[3])) continue;
                    runner.summarizeTaintPropagation(m);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException, InvalidClassFileException {
        ClassHierarchy cha = null;
        FlowAnalyzerRunner runner = null;
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        scope.addToScope(ClassLoaderReference.Primordial, new JarFile("C:\\Java\\jdk6_06\\jre\\lib\\rt.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\servlet-api.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\jasper-compiler.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\jasper-compiler-jdt.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\jasper-runtime.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\jsp-api.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\naming-factory-dbcp.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\naming-factory.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("D:\\webgoat\\naming-resources.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\activation.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\axis-ant.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\axis.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\catalina.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\commons-discovery-0.2.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\commons-logging-1.0.4.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\dsn.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\ecs-1.4.2.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\hsqldb.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\imap.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\j2h.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\jaxrpc.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\jta-spec1_0_1.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\jtds-1.2.2.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\mail.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\mailapi.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\ojdbc14.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\pop3.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\saaj.jar"));
        scope.addToScope(ClassLoaderReference.Extension, new JarFile("C:\\temp\\taintWorkspace\\webgoat-5.1-20080213\\main\\project\\WebContent\\WEB-INF\\lib\\smtp.jar"));
        cha = ClassHierarchy.make((AnalysisScope)scope);
        runner = new FlowAnalyzerRunner((IClassHierarchy)cha, ILangServices.JAVA, JavaServicesForFastanalysis.JAVA);
        Collection<IMethod> methods = FlowAnalyzer.parseMethods((IClassHierarchy)cha, "C:\\temp\\libraryCallees.txt", (Language)Language.JAVA);
        for (IMethod m : methods) {
            if (!runner.isEligibleForSummary(m)) continue;
            runner.summarizeTaintPropagation(m);
        }
    }

    public void summarizeTaintPropagation(IMethod m) throws ClassHierarchyException, InvalidClassFileException, IOException {
        TICallGraph cg = TICallGraph.buildCG(m, new TICallGraph.VirtualResolutionOptions(1, 1, true, false, false), OfflineSpecification.loadDefaultSpec(this.cha, this.langServices, this.fastLangServices), this.langServices, AccuracyLevel.getDefaultUnboundedLevel());
        final HashMap node2priority = HashMapFactory.make((int)cg.getNumberOfNodes());
        PriorityQueue<CGNode> pq = new PriorityQueue<CGNode>(1, new Comparator<CGNode>(){

            @Override
            public int compare(CGNode n1, CGNode n2) {
                return ((Integer)node2priority.get(n1)).compareTo((Integer)node2priority.get(n2));
            }
        });
        this.assignPriorities(cg, node2priority, pq);
        this.resolve(pq);
    }

    private void assignPriorities(TICallGraph cg, Map<CGNode, Integer> node2priority, PriorityQueue<CGNode> pq) {
        Collection<CGNode> leaves = this.getLeaves(cg);
        for (CGNode n : cg) {
            if (leaves.contains(n)) {
                node2priority.put(n, 0);
                continue;
            }
            int priority = 0;
            for (CGNode leaf : leaves) {
                BFSPathFinder pf = new BFSPathFinder((Graph)cg, (Object)n, (Object)leaf);
                List path = pf.find();
                if (path == null) continue;
                priority = Math.max(priority, path.size());
            }
            if (priority == 0) {
                priority = Integer.MAX_VALUE;
            }
            node2priority.put(n, priority);
            pq.add(n);
        }
    }

    private Collection<CGNode> getLeaves(TICallGraph cg) {
        Collection<CGNode> leaves = cg.getLeaves();
        for (CGNode n : cg) {
            IMethod m = n.getMethod();
            if (!this.spec.hasSpecForMethod(m)) continue;
            leaves.add(n);
        }
        return leaves;
    }

    private void resolve(PriorityQueue<CGNode> pq) throws InvalidClassFileException, ClassHierarchyException, IOException {
        while (!pq.isEmpty()) {
            CGNode n = pq.poll();
            IMethod m = n.getMethod();
            if (this.spec.hasSpecForMethod(m) || !this.isEligibleForSummary(m)) continue;
            Iterator<List<TypeReference>> iterator = this.enumerator.getIterator(m);
            SummaryCache.TaintRelationSet s = new SummaryCache.TaintRelationSet(this.cha, this.fastLangServices);
            while (iterator.hasNext()) {
                FlowAnalyzer fa = new FlowAnalyzer(this.cha, this.langServices, this.fastLangServices, this.spec);
                List<TypeReference> rawPA = iterator.next();
                List<IClass> pa = FlowAnalyzer.resolveClasses(rawPA, this.cha);
                Set<SummaryCache.TaintRelation> newS = fa.summarizeTaintPropagation(m, pa);
                if (newS == null) continue;
                s.addAll(newS);
            }
            if (!m.isPublic() && !m.isProtected()) continue;
            ContextualSummary cs = new ContextualSummary(m, s, null);
            FlowAnalyzer.documentSummary(cs, this.cha, this.fastLangServices);
        }
    }

    private static CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> getDotNetAnalysisScope(String scopeFileName) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(scopeFileName));
            String line = "";
            if (!in.ready()) {
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                files.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SetOfClasses exclusions = new SetOfClasses(){
            private final Collection<String> exclusionsList = this.parseExclusionsFile("dat/exclusions.dotnet.dat");
            private static final long serialVersionUID = 1L;

            private Collection<String> parseExclusionsFile(String exclusionsFile) {
                HashSet result = HashSetFactory.make();
                try {
                    FileProvider fp = new FileProvider();
                    File f = fp.getFile(exclusionsFile);
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    String line = "";
                    if (!in.ready()) {
                        throw new IOException();
                    }
                    while ((line = in.readLine()) != null) {
                        if (line.trim().length() == 0) continue;
                        result.add(line);
                    }
                    in.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return result;
            }

            public boolean contains(String klassName) {
                for (String exclusion : this.exclusionsList) {
                    if (!klassName.startsWith(exclusion)) continue;
                    return true;
                }
                return false;
            }

            public void add(String klass) {
                Assertions.UNREACHABLE();
            }
        };
        Iterator itr = files.iterator();
        String sysLine = (String)itr.next();
        String sysPath = sysLine.substring(sysLine.indexOf(44) + 1);
        File sysAssembly = new File(sysPath);
        HashSet appAssemblies = HashSetFactory.make();
        HashSet libAssemblies = HashSetFactory.make();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            int indexOfFirstComma = line.indexOf(44);
            String appOrLib = line.substring(0, indexOfFirstComma);
            String path = line.substring(indexOfFirstComma + 1);
            if (appOrLib.equals("app")) {
                appAssemblies.add(new File(path));
                continue;
            }
            assert (appOrLib.equals("lib"));
            libAssemblies.add(new File(path));
        }
        CSharpInterface i = new CSharpInterface();
        i.clearCaches();
        CLRAnalysisScope scope = new CLRAnalysisScope(sysAssembly, (Set)libAssemblies, (Set)appAssemblies, exclusions, (LowLevelInterface)i);
        return scope;
    }

    private boolean isEligibleForSummary(IMethod m) throws IOException {
        if (m.getNumberOfParameters() <= 1) {
            return false;
        }
        if (FlowAnalyzerRunner.hasSummary(m)) {
            return false;
        }
        for (int index = 0; index < m.getNumberOfParameters(); ++index) {
            TypeReference t = m.getParameterType(index);
            if (this.langServices.equals(ILangServices.DOTNET)) {
                if (t.equals((Object)CLRTypeReference.SystemObject)) {
                    return false;
                }
                if (!t.equals((Object)TypeReference.findOrCreateArrayOf((TypeReference)CLRTypeReference.SystemObject))) continue;
                return false;
            }
            if (!this.langServices.equals(ILangServices.JAVA)) continue;
            if (t.equals((Object)TypeReference.JavaLangObject) || t.equals((Object)TypeReference.JavaLangThrowable)) {
                return false;
            }
            if (!t.equals((Object)TypeReference.findOrCreateArrayOf((TypeReference)TypeReference.JavaLangObject))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSummary(IMethod m) throws IOException {
        BufferedReader in;
        boolean result = false;
        try {
            in = new BufferedReader(new FileReader("c:/temp/autoSummaries.txt"));
        }
        catch (FileNotFoundException e) {
            System.err.println("Summary file not found");
            return false;
        }
        String f = "";
        if (!in.ready()) {
            throw new IOException();
        }
        while ((f = in.readLine()) != null) {
            if (f.trim().length() == 0 || !f.contains(m.getSignature())) continue;
            result = true;
            break;
        }
        in.close();
        return result;
    }

    private void documentSummary(IMethod m, Set<SummaryCache.TaintRelation> trs) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter("c:/temp/autoSummaries.txt", true));
        if (trs != null && !trs.isEmpty()) {
            for (SummaryCache.TaintRelation relation : trs) {
                String r = m.getSignature() + "\t" + relation.getPrecondition() + "\t" + relation.getPostcondition();
                System.err.println("\t" + r);
                bw.write(r + "\r\n");
            }
        } else {
            String r = m.getSignature() + "\tnone\tnone";
            System.err.println("\t" + r);
            bw.write(r + "\r\n");
        }
        bw.close();
    }

    private static String prettyPrint(List<IClass> pointerAnalysis) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int index = 0; index < pointerAnalysis.size(); ++index) {
            String current = pointerAnalysis.get(index) == null ? "---" : pointerAnalysis.get(index).getName().toString();
            sb.append(current);
            if (index >= pointerAnalysis.size() - 1) continue;
            sb.append(',');
        }
        sb.append('>');
        return sb.toString();
    }

    private OfflineSpecification loadOfflineSpecification() {
        String offlineSpecFile = this.langServices.getOfflineSpecificationFile();
        try {
            File f = TaintFileProvider.getFile((String)offlineSpecFile);
            File autoSummariesFile = new File(FlowAnalyzer.AUTO_SUMMARIES_FILE_NAME);
            return OfflineSpecification.load(f, autoSummariesFile, this.cha, this.langServices.getLanguage(), this.fastLangServices);
        }
        catch (IOException e) {
            System.err.println("Failed to load offline specification " + offlineSpecFile + ": " + e);
            return null;
        }
    }
}

