/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules;

import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.misc.FactPair;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ISinkFilter;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class BoundedReceiverBasedSinkFilter
implements ISinkFilter {
    private final ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> supergraph;
    private final ISinkReceiverVerifier verifier;
    private final int bound;
    private final ILanguageSpecificServicesForFastanalysis langServices;

    public BoundedReceiverBasedSinkFilter(ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> supergraph, ISinkReceiverVerifier verifier, int bound, ILanguageSpecificServicesForFastanalysis lang_services) {
        this.supergraph = supergraph;
        this.verifier = verifier;
        this.bound = bound;
        this.langServices = lang_services;
    }

    @Override
    public boolean acceptsSink(FactPair allegedSink) {
        return this.isSinkKosher(allegedSink);
    }

    private boolean isSinkKosher(FactPair allegedSink) {
        HashSet candidates = HashSetFactory.make();
        HashSet worklist = HashSetFactory.make();
        HashSet visited = HashSetFactory.make();
        SSAInstruction seedInstr = allegedSink.getBB().getLastInstruction();
        worklist.add(Pair.make((Object)Pair.make((Object)allegedSink.getBB().getNode(), (Object)seedInstr.getUse(0)), (Object)0));
        while (!worklist.isEmpty()) {
            Iterator iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                Pair current = (Pair)iter.next();
                if (visited.contains(current.fst)) continue;
                visited.add(current.fst);
                CGNode context = (CGNode)((Pair)current.fst).fst;
                int ssaVar = (Integer)((Pair)current.fst).snd;
                int depth = (Integer)current.snd;
                IR ir = context.getIR();
                SymbolTable sb = ir.getSymbolTable();
                if (this.langServices.isParameter(ssaVar, sb.getNumberOfParameters())) {
                    if (depth < this.bound) {
                        worklist.addAll(this.getActualParameters(context, ssaVar, depth));
                        continue;
                    }
                    candidates.add(current.fst);
                    continue;
                }
                DefUse du = new DefUse(ir);
                SSAInstruction def = du.getDef(ssaVar);
                if (def instanceof SSAAbstractInvokeInstruction) {
                    candidates.add(current.fst);
                    continue;
                }
                if (def instanceof SSAPhiInstruction) {
                    for (int use = 0; use < def.getNumberOfUses(); ++use) {
                        worklist.add(Pair.make((Object)Pair.make((Object)context, (Object)use), (Object)depth));
                    }
                    continue;
                }
                if (def instanceof SSANewInstruction) {
                    candidates.add(current.fst);
                    continue;
                }
                if (def instanceof SSAGetInstruction) {
                    candidates.add(current.fst);
                    continue;
                }
                if (def instanceof SSACheckCastInstruction) {
                    worklist.add(Pair.make((Object)Pair.make((Object)context, (Object)def.getUse(0)), (Object)depth));
                    continue;
                }
                if (def instanceof SSAArrayLoadInstruction) {
                    candidates.add(current.fst);
                    continue;
                }
                Assertions.UNREACHABLE();
            }
        }
        for (Pair candidate : candidates) {
            if (!this.verifier.accepts((Pair<CGNode, Integer>)candidate)) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends Pair<Pair<CGNode, Integer>, Integer>> getActualParameters(CGNode context, int ssaVar, int depth) {
        BasicBlockInContext[] entriesForProcedure;
        HashSet result = HashSetFactory.make();
        for (BasicBlockInContext entry : entriesForProcedure = (BasicBlockInContext[])this.supergraph.getEntriesForProcedure((Object)context)) {
            Iterator invocationsIter = this.supergraph.getPredNodes((Object)entry);
            while (invocationsIter.hasNext()) {
                BasicBlockInContext invocation = (BasicBlockInContext)invocationsIter.next();
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)invocation.getLastInstruction();
                int var = invoke.getUse(ssaVar - 1);
                CGNode pred = (CGNode)this.supergraph.getProcOf((Object)invocation);
                result.add(Pair.make((Object)Pair.make((Object)pred, (Object)var), (Object)(depth + 1)));
            }
        }
        return result;
    }

    @Override
    public boolean applies(IRawTaintRule taintRule, FactPair allegedSink) {
        return this.verifier.isInteresting(taintRule, allegedSink);
    }

    public static interface ISinkReceiverVerifier {
        public boolean accepts(Pair<CGNode, Integer> var1);

        public boolean isInteresting(IRawTaintRule var1, FactPair var2);
    }
}

