/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.golang;

import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.golang.IGoLangConstants;
import com.ibm.appscan.internal.discovery.golang.GoLangStrategy;
import java.io.File;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoLangCollector
extends BaseCustomCollector
implements IGoLangConstants {
    public GoLangCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "GoLangCollector";
    }

    protected String getFileExtensionSetName() {
        return "golang";
    }

    protected boolean acceptFile(File file) {
        Matcher venDir = Pattern.compile("[\\/\\\\]?vendor[\\/\\\\]?", 2).matcher(file.getParent());
        if (FileUtil.getBaseName((File)file).endsWith("_test") || !SystemUtil.isThirdParty() && venDir.find()) {
            return false;
        }
        return super.acceptFile(file);
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new GoLangStrategy(root, this.getScanFiles());
    }
}

