/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.generic;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DispatchResolver {
    private final IClassHierarchy cha;
    private final Map<TargetCacheKey, Set<IMethod>> targetCache = HashMapFactory.make();

    public static DispatchResolver make(IClassHierarchy cha) {
        return new DispatchResolver(cha);
    }

    private DispatchResolver(IClassHierarchy cha) {
        this.cha = cha;
    }

    public Set<IMethod> computePossibleTargets(CallSiteReference site, TypeAbstraction receiverType) {
        if (site.isSpecial() || site.isStatic()) {
            IMethod m = this.cha.resolveMethod(site.getDeclaredTarget());
            return m == null ? Collections.emptySet() : Collections.singleton(m);
        }
        if (receiverType == null || receiverType.equals((Object)TypeAbstraction.TOP) || receiverType.getTypeReference().equals((Object)TypeReference.JavaLangObject)) {
            return HashSetFactory.make((Collection)this.cha.getPossibleTargets(site.getDeclaredTarget()));
        }
        if (receiverType instanceof PointType) {
            IMethod resolved = this.cha.resolveMethod(this.cha.lookupClass(receiverType.getTypeReference()), site.getDeclaredTarget().getSelector());
            assert (resolved != null) : "couldn't resolve method " + site.getDeclaredTarget() + " for receiver type " + receiverType.getTypeReference();
            return Collections.singleton(resolved);
        }
        if (receiverType instanceof ConeType) {
            return HashSetFactory.make(this.getPossibleTargetsFromCHA(site.getDeclaredTarget(), receiverType.getTypeReference()));
        }
        if (receiverType instanceof SetType) {
            HashSet result = HashSetFactory.make();
            Iterator typeIter = ((SetType)receiverType).iteratePoints();
            while (typeIter.hasNext()) {
                TypeReference ref = (TypeReference)typeIter.next();
                IMethod resolved = this.cha.resolveMethod(this.cha.lookupClass(ref), site.getDeclaredTarget().getSelector());
                assert (resolved != null);
                result.add(resolved);
            }
            return result;
        }
        assert (false) : "need to handle " + receiverType + " class " + receiverType.getClass();
        return null;
    }

    public Set<IMethod> getPossibleTargetsFromCHA(MethodReference target, TypeReference ref) {
        TargetCacheKey key = new TargetCacheKey(this.cha, target, ref);
        Set<IMethod> result = this.targetCache.get(key);
        if (result == null) {
            result = this.filterAbstractMethods(this.cha.getPossibleTargets(this.cha.lookupClass(ref), target));
            this.targetCache.put(key, result);
        }
        return result;
    }

    private Set<IMethod> filterAbstractMethods(Set<IMethod> possibleTargets) {
        HashSet result = HashSetFactory.make((int)possibleTargets.size());
        for (IMethod m : possibleTargets) {
            if (m.isAbstract()) continue;
            result.add(m);
        }
        return result;
    }

    private static class TargetCacheKey {
        private final IClassHierarchy cha;
        private final MethodReference declaredTarget;
        private final TypeReference type;

        private TargetCacheKey(IClassHierarchy cha, MethodReference declaredTarget, TypeReference type) {
            this.cha = cha;
            this.declaredTarget = declaredTarget;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cha == null ? 0 : this.cha.hashCode());
            result = 31 * result + (this.declaredTarget == null ? 0 : this.declaredTarget.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TargetCacheKey other = (TargetCacheKey)obj;
            if (this.cha == null ? other.cha != null : !this.cha.equals(other.cha)) {
                return false;
            }
            if (this.declaredTarget == null ? other.declaredTarget != null : !this.declaredTarget.equals((Object)other.declaredTarget)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }
}

