/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.generic;

import com.ibm.appscan.frameworks.analyzers.generic.DispatchResolver;
import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public class StringConstantFlow {
    private static final Logger logger = TaintLogger.i().getLogger();
    final AnalysisCache cache;
    final DispatchResolver dispatchResolver;
    final int maxCallDepth;
    final IR intraprocIR;
    final DefUse intraprocDU;

    public static StringConstantFlow make(AnalysisCache cache, DispatchResolver dispatchResolver, int maxCallDepth) {
        return new StringConstantFlow(cache, null, null, dispatchResolver, maxCallDepth);
    }

    public static StringConstantFlow makeIntraproc(IR ir, DefUse du) {
        return new StringConstantFlow(null, ir, du, null, 0);
    }

    private StringConstantFlow(AnalysisCache cache, IR intraprocIR, DefUse intraprocDU, DispatchResolver dispatchResolver, int maxCallDepth) {
        this.cache = cache;
        this.intraprocIR = intraprocIR;
        this.intraprocDU = intraprocDU;
        this.dispatchResolver = dispatchResolver;
        this.maxCallDepth = maxCallDepth;
    }

    public Collection<String> findIntraprocStringsFlowingToVar(int valNum) {
        return (Collection)this.findIntraprocStringConstants((int)valNum, (IR)this.intraprocIR, (DefUse)this.intraprocDU).fst;
    }

    public Collection<String> findStringsFlowingToVar(IMethod m, int valNum) {
        IR ir = this.cache != null ? LangIndependentWalaUtil.getIR(m, this.cache) : this.intraprocIR;
        DefUse du = this.cache != null ? LangIndependentWalaUtil.getDU(ir, this.cache) : this.intraprocDU;
        return this.findStringConstantsRec(valNum, ir, du, 0);
    }

    private Collection<String> findStringConstantsRec(int valNum, IR ir, DefUse du, int curDepth) {
        Pair<Collection<String>, Collection<SSAAbstractInvokeInstruction>> intraprocResult = this.findIntraprocStringConstants(valNum, ir, du);
        Collection constants = (Collection)intraprocResult.fst;
        if (curDepth < this.maxCallDepth) {
            TypeInference ti = TypeInference.make((IR)ir, (boolean)false);
            for (SSAAbstractInvokeInstruction instr : (Collection)intraprocResult.snd) {
                TypeAbstraction type = null;
                CallSiteReference site = instr.getCallSite();
                if (site.isDispatch()) {
                    type = ti.getType(instr.getReceiver());
                }
                Set<IMethod> targets = this.dispatchResolver.computePossibleTargets(site, type);
                for (IMethod callee : targets) {
                    IR calleeIR = LangIndependentWalaUtil.getIR(callee, this.cache);
                    HashSet returnedValNums = HashSetFactory.make();
                    for (SSAInstruction calleeInstr : Iterator2Iterable.make((Iterator)calleeIR.iterateNormalInstructions())) {
                        if (!(calleeInstr instanceof SSAReturnInstruction)) continue;
                        returnedValNums.add(calleeInstr.getUse(0));
                    }
                    Iterator iterator = returnedValNums.iterator();
                    while (iterator.hasNext()) {
                        int returnedValNum = (Integer)iterator.next();
                        constants.addAll(this.findStringConstantsRec(returnedValNum, calleeIR, LangIndependentWalaUtil.getDU(calleeIR, this.cache), curDepth + 1));
                    }
                }
            }
        }
        return constants;
    }

    private Pair<Collection<String>, Collection<SSAAbstractInvokeInstruction>> findIntraprocStringConstants(int valNum, IR ir, DefUse du) {
        HashSet constants = HashSetFactory.make();
        HashSet sitesDefingVal = HashSetFactory.make();
        HashSet handled = HashSetFactory.make();
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        handled.add(valNum);
        worklist.add(valNum);
        SymbolTable symbolTable = ir.getSymbolTable();
        while (!worklist.isEmpty()) {
            int curValNum = (Integer)worklist.remove();
            if (symbolTable.isConstant(curValNum)) {
                Object constantValue = symbolTable.getConstantValue(curValNum);
                if (constantValue == null) continue;
                assert (constantValue instanceof String) : "found non-String constant " + constantValue;
                constants.add((String)constantValue);
                continue;
            }
            SSAInstruction def = du.getDef(curValNum);
            if (def instanceof SSAPhiInstruction) {
                SSAPhiInstruction phi = (SSAPhiInstruction)def;
                for (int i = 0; i < phi.getNumberOfUses(); ++i) {
                    int phiUse = phi.getUse(i);
                    if (!handled.add(phiUse)) continue;
                    worklist.add(phiUse);
                }
                continue;
            }
            if (def instanceof SSAAbstractInvokeInstruction) {
                sitesDefingVal.add((SSAAbstractInvokeInstruction)def);
                continue;
            }
            logger.debug((Object)("not handling String def statement " + def));
        }
        return Pair.make((Object)constants, (Object)sitesDefingVal);
    }
}

