/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.TaintTrainerSingle;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class TaintTrainerEnsemble {
    private ArrayList<Integer> m_seeds;
    private ArrayList<TaintTrainerSingle> m_trainers;
    private ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> m_features;

    public TaintTrainerEnsemble(ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> f, ArrayList<Integer> seeds) {
        this.m_seeds = seeds;
        this.m_features = f;
    }

    public ArrayList<TaintTrainerSingle> getTrainers() {
        if (this.m_trainers == null) {
            this.m_trainers = new ArrayList();
            for (int seed : this.m_seeds) {
                this.m_trainers.add(new TaintTrainerSingle(this.m_features, seed));
            }
        }
        return this.m_trainers;
    }

    public String testMethod(Method m) throws MarkupException, VDBException, IfaException {
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (TaintTrainerSingle t : this.getTrainers()) {
            LinkedHashMap<Double, Double> probs = t.getSortedProbabilities(m);
            Iterator iterator = ((HashMap)probs).keySet().iterator();
            while (iterator.hasNext()) {
                double key = (Double)iterator.next();
                if (!results.containsKey(t.getIdMap().get((int)key))) {
                    results.put(t.getIdMap().get((int)key), 0.0);
                }
                double temp = results.get(t.getIdMap().get((int)key));
                results.put(t.getIdMap().get((int)key), temp += (Double)((HashMap)probs).get(key) / (double)this.getTrainers().size());
            }
        }
        LinkedHashMap<String, Double> ret = this.getSortedPrediction(results);
        for (String key : ret.keySet()) {
            Taint t = this.getTaintFromString(key);
            if (!t.isValidForMethod(m)) continue;
            return key;
        }
        return ret.keySet().iterator().next();
    }

    public String getProbabilityString(Method m) throws MarkupException, VDBException {
        StringBuffer ret = new StringBuffer();
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (TaintTrainerSingle t : this.getTrainers()) {
            ret.append("\t");
            ret.append(t.getSeed());
            ret.append(System.getProperty("line.separator"));
            LinkedHashMap<Double, Double> probs = t.getSortedProbabilities(m);
            for (double key : probs.keySet()) {
                if (!results.containsKey(t.getIdMap().get((int)key))) {
                    results.put(t.getIdMap().get((int)key), 0.0);
                }
                double temp = (Double)results.get(t.getIdMap().get((int)key));
                results.put(t.getIdMap().get((int)key), temp += probs.get(key) / (double)this.getTrainers().size());
                ret.append("\t");
                ret.append("\t");
                ret.append(t.getIdMap().get((int)key));
                ret.append(":");
                ret.append(probs.get(key));
                ret.append(System.getProperty("line.separator"));
            }
        }
        ret.append("\tTotal:");
        ret.append(System.getProperty("line.separator"));
        for (String key : results.keySet()) {
            ret.append("\t");
            ret.append("\t");
            ret.append(key);
            ret.append(":");
            ret.append(results.get(key));
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString();
    }

    public LinkedHashMap<String, Double> getSortedPrediction(HashMap<String, Double> map) {
        LinkedList<Map.Entry<String, Double>> list = new LinkedList<Map.Entry<String, Double>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return Double.compare(o2.getValue(), o1.getValue());
            }
        });
        LinkedHashMap<String, Double> sortedMap = new LinkedHashMap<String, Double>();
        for (Map.Entry entry : list) {
            if ((Double)entry.getValue() == 0.0) continue;
            sortedMap.put((String)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }

    public ArrayList<Taint> getTaintsFromString(String markupString) throws MarkupException {
        ArrayList<Taint> ret = new ArrayList<Taint>();
        if (markupString.contains(";")) {
            for (String t : markupString.split(";")) {
                ret.add(this.getTaintFromString(t));
            }
        } else {
            ret.add(this.getTaintFromString(markupString));
        }
        return ret;
    }

    public Taint getTaintFromString(String t) throws MarkupException {
        String ret;
        String dst;
        String src;
        if (t.contains("-")) {
            src = t.split("-")[0];
            dst = t.split("-")[1];
            ret = t.split("-")[2];
            src = src.replaceAll("=", "-");
            src = src.replaceAll("_", ",");
            dst = dst.replaceAll("=", "-");
            dst = dst.replaceAll("_", ",");
        } else {
            src = "none";
            dst = "none";
            ret = "0";
        }
        try {
            return new Taint(src, dst, ret.equals("1"));
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
    }
}

