/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SimpleSTSCopier;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.util.collections.Bag;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CFLReachability {
    private IAutomaton lastResult = null;
    protected final MonitorUtil.IProgressMonitor monitor;

    public CFLReachability(MonitorUtil.IProgressMonitor monitor) {
        this.monitor = monitor == null ? AUtil.nullProgressMonitor : monitor;
    }

    private static boolean isSimplified(IContextFreeGrammar cfg) {
        for (IProductionRule rule : cfg.getRules()) {
            int size = rule.getRight().size();
            if (size <= 2) continue;
            return false;
        }
        return true;
    }

    public IAutomaton analyze(IAutomaton automaton, IContextFreeGrammar cfg, ITransitionFactory factory) {
        return this.analyze(automaton, cfg, false, factory, null);
    }

    public IAutomaton analyze(IAutomaton automaton, IContextFreeGrammar cfg, ITransitionFactory factory, IVariableFactory<IVariable> varFactory) {
        return this.analyze(automaton, cfg, false, factory, varFactory);
    }

    protected boolean doneAnalysis(Collection<ITransition> transitions, IAutomaton fst, IContextFreeGrammar cfg) {
        Set<IState> finalStates = fst.getFinalStates();
        IState initState = fst.getInitialState();
        IVariable startSymbol = cfg.getStartSymbol();
        for (ITransition t : transitions) {
            if (!t.getPreState().equals(initState) || !finalStates.contains(t.getPostState()) || !t.getInputSymbol().equals(startSymbol)) continue;
            return true;
        }
        return false;
    }

    public IAutomaton analyze(IAutomaton automaton, IContextFreeGrammar cfg, boolean optimize, ITransitionFactory factory, IVariableFactory<IVariable> varFactory) {
        IAutomaton result = (IAutomaton)automaton.copy(SimpleSTSCopier.defaultCopier);
        Automatons.eliminateEpsilonTransitions(result);
        Automatons.eliminateUnreachableStates(result);
        Automatons.reduceTransitions(result);
        IContextFreeGrammar reducedCfg = Grammars.reduceTerminals(cfg);
        cfg = (IContextFreeGrammar)Grammars.expand(reducedCfg, Automatons.collectTerminals(result));
        if (optimize) {
            CFLReachability.optimize(result, cfg);
        }
        if (!CFLReachability.isSimplified(cfg)) {
            cfg = (IContextFreeGrammar)cfg.copy(SimpleGrammarCopier.defaultCopier);
            Grammars.simplifyRules(cfg, varFactory);
        }
        this.addTransitions(result, cfg, factory);
        this.lastResult = result;
        return result;
    }

    private List<IProductionRule> sortRules(IContextFreeGrammar cfg) {
        LinkedList<IProductionRule> l = new LinkedList<IProductionRule>();
        HashSet<IVariable> vs = new HashSet<IVariable>();
        IVariable v = cfg.getStartSymbol();
        this.sortRules(cfg, v, l, vs);
        return l;
    }

    private void sortRules(IContextFreeGrammar cfg, IVariable v, List<IProductionRule> l, Set<IVariable> vs) {
        if (vs.contains(v)) {
            return;
        }
        vs.add(v);
        for (IProductionRule r : cfg.getRules(v)) {
            for (ISymbol s : r.getRight()) {
                if (!(s instanceof IVariable)) continue;
                this.sortRules(cfg, (IVariable)s, l, vs);
            }
            l.add(r);
        }
    }

    private void addTransitions(IAutomaton result, IContextFreeGrammar cfg, ITransitionFactory factory) {
        HashSet<ITransition> prevTransitions = new HashSet<ITransition>(result.getTransitions());
        HashSet<ITransition> newTransitions = new HashSet<ITransition>();
        List<IProductionRule> rules = this.sortRules(cfg);
        do {
            newTransitions.clear();
            for (IProductionRule rule : rules) {
                this.addTransitionFor(result, cfg, rule, newTransitions, prevTransitions, factory);
            }
            result.getTransitions().addAll(newTransitions);
            prevTransitions.clear();
            prevTransitions.addAll(newTransitions);
        } while (!this.doneAnalysis(newTransitions, result, cfg) && !newTransitions.isEmpty());
    }

    private void addTransitionFor(IAutomaton result, IContextFreeGrammar cfg, IProductionRule rule, Collection<ITransition> newTransitions, Collection<ITransition> prevTransitions, ITransitionFactory factory) {
        if (this.monitor.isCanceled()) {
            throw CancelRuntimeException.make((String)"While adding transition");
        }
        if (rule.isEpsilonRule()) {
            this.addTransitionForEpsilonRule(result, rule, newTransitions, prevTransitions, factory);
        } else {
            ArrayList<ITransition> ts = new ArrayList<ITransition>(result.getTransitions());
            HashSet<ITransition> nt = new HashSet<ITransition>();
            for (ITransition t : ts) {
                nt.clear();
                this.addTransitionFor(result, t, rule, nt, prevTransitions, factory);
                result.getTransitions().addAll(nt);
                newTransitions.addAll(nt);
                prevTransitions.addAll(nt);
            }
        }
    }

    private void addTransitionForEpsilonRule(IAutomaton result, IProductionRule rule, Collection<ITransition> newTransitions, Collection<ITransition> prevTransitions, ITransitionFactory factory) {
        for (IState state : result.getStates()) {
            if (this.isAlreadyAdded(state, state, rule.getLeft(), Collections.emptyList(), Collections.emptyList(), rule, result, newTransitions)) continue;
            AnalysisTransition newTrans = factory.createTransition(state, state, rule.getLeft(), Collections.emptyList(), rule, Collections.emptyList());
            newTransitions.add(newTrans);
            prevTransitions.add(newTrans);
        }
    }

    private void addTransitionFor(IAutomaton result, ITransition trans, IProductionRule rule, Collection<ITransition> newTransitions, Collection<ITransition> prevTransitions, ITransitionFactory factory) {
        boolean isNew = prevTransitions.contains(trans);
        ISymbol right0 = rule.getRight(0);
        if (trans.accept(right0, IMatchContext.DummyContext)) {
            if (rule.getRight().size() == 1) {
                if (!isNew) {
                    return;
                }
                List<ISymbol> output = trans.transit(right0);
                List<ITransition> assocTransitions = Arrays.asList(trans);
                if (!this.isAlreadyAdded(trans.getPreState(), trans.getPostState(), rule.getLeft(), output, assocTransitions, rule, result, newTransitions)) {
                    AnalysisTransition newTrans = factory.createTransition(trans.getPreState(), trans.getPostState(), rule.getLeft(), output, rule, assocTransitions);
                    newTransitions.add(newTrans);
                }
            } else {
                for (ITransition trans2 : result.getAcceptTransitions(trans.getPostState(), rule.getRight(1))) {
                    if (!isNew && !prevTransitions.contains(trans2)) continue;
                    ISymbol right1 = rule.getRight(1);
                    ArrayList<ISymbol> output = new ArrayList<ISymbol>();
                    List<ISymbol> output1 = trans.transit(right0);
                    output.addAll(output1);
                    List<ISymbol> output2 = trans2.transit(right1);
                    output.addAll(output2);
                    List<ITransition> assocTransitions = Arrays.asList(trans, trans2);
                    if (this.isAlreadyAdded(trans.getPreState(), trans2.getPostState(), rule.getLeft(), output, assocTransitions, rule, result, newTransitions)) continue;
                    AnalysisTransition newTrans = factory.createTransition(trans.getPreState(), trans2.getPostState(), rule.getLeft(), output, rule, assocTransitions);
                    newTransitions.add(newTrans);
                }
            }
        }
    }

    protected boolean isAlreadyAdded(IState preState, IState postState, ISymbol s, List<ISymbol> out, List<ITransition> assocTransitions, IProductionRule rule, IAutomaton automaton, Collection<ITransition> newTransitions) {
        if (this.monitor.isCanceled()) {
            throw CancelRuntimeException.make((String)"during CFL translation");
        }
        Bag l = new Bag();
        l.addAll(automaton.getTransitions(preState));
        for (ITransition t : newTransitions) {
            if (!t.getPreState().equals(preState)) continue;
            l.add(t);
        }
        for (ITransition t : l) {
            if (!t.getPostState().equals(postState) || !t.getInputSymbol().equals(s)) continue;
            return true;
        }
        return false;
    }

    protected List<ISymbol> calculateOutputSymbols(IState preState, IState postState, ISymbol s, List<ISymbol> out, List<ITransition> assocTransitions, IProductionRule rule, IAutomaton automaton, Set<ITransition> newTransitions) {
        return out;
    }

    public static boolean isNotReachable(IAutomaton automaton, IContextFreeGrammar cfg) {
        return false;
    }

    public static boolean isReachable(IAutomaton automaton, IContextFreeGrammar cfg, Collection<? extends IVariable> nonterminals, MonitorUtil.IProgressMonitor monitor) {
        if (CFLReachability.isNotReachable(automaton, cfg)) {
            return false;
        }
        return CFLReachability.isReachableCore(automaton, cfg, nonterminals, monitor);
    }

    public static boolean isReachableCore(IAutomaton automaton, IContextFreeGrammar cfg, Collection<? extends IVariable> nonterminals, MonitorUtil.IProgressMonitor monitor) {
        CFLReachability analyzer = new CFLReachability(monitor);
        IAutomaton result = analyzer.analyze(automaton, cfg, true, new SimpleTransitionFactory(), null);
        IState initState = result.getInitialState();
        Set<IState> finalStates = result.getFinalStates();
        for (ITransition trans : result.getTransitions()) {
            if (!initState.equals(trans.getPreState()) || !finalStates.contains(trans.getPostState()) || !nonterminals.contains(trans.getInputSymbol())) continue;
            return true;
        }
        return false;
    }

    public static boolean isReachable(IAutomaton automaton, IContextFreeGrammar cfg, IVariable[] nonterminals, MonitorUtil.IProgressMonitor monitor) {
        return CFLReachability.isReachable(automaton, cfg, AUtil.set(nonterminals), monitor);
    }

    public static boolean isReachable(IAutomaton automaton, IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        return CFLReachability.isReachable(automaton, cfg, new IVariable[]{cfg.getStartSymbol()}, monitor);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, IAutomaton automaton, MonitorUtil.IProgressMonitor monitor) {
        return CFLReachability.isReachable(automaton, cfg, monitor);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, IAutomaton automaton) {
        return CFLReachability.containsSome(cfg, automaton, null);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, ISymbol[] symbols, MonitorUtil.IProgressMonitor monitor) {
        Automaton automaton = Automatons.createAutomaton(symbols);
        return CFLReachability.containsSome(cfg, automaton, monitor);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, ISymbol[] symbols) {
        return CFLReachability.containsSome(cfg, symbols, null);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, List<? extends ISymbol> symbols, MonitorUtil.IProgressMonitor monitor) {
        ISymbol[] ary = new ISymbol[symbols.size()];
        symbols.toArray(ary);
        return CFLReachability.containsSome(cfg, ary, monitor);
    }

    public static boolean containsSome(IContextFreeGrammar cfg, List<? extends ISymbol> symbols) {
        return CFLReachability.containsSome(cfg, symbols, null);
    }

    public static Collection<ISymbol> collectTerminals(IAutomaton a, IGrammar g) {
        HashSet<ISymbol> allSymbols = new HashSet<ISymbol>();
        HashSet<ISymbol> terminals = new HashSet<ISymbol>();
        allSymbols.addAll(Automatons.collectTerminals(a));
        allSymbols.addAll(Grammars.collectTerminals(g));
        for (ISymbol s : allSymbols) {
            if (s instanceof IVariable) {
                System.err.println("should not contain the variable: " + s);
                continue;
            }
            terminals.add(RangeSymbol.unrange(s));
        }
        return terminals;
    }

    public static boolean containsAll(IAutomaton automaton, IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        Collection<ISymbol> terminals = CFLReachability.collectTerminals(automaton, cfg);
        IAutomaton a = Automatons.createComplement(automaton, terminals = RangeSymbol.splitSymbols(terminals));
        return !CFLReachability.isReachable(a, cfg, monitor);
    }

    public static boolean containsAll(IAutomaton automaton, IContextFreeGrammar cfg) {
        return CFLReachability.containsAll(automaton, cfg, null);
    }

    public static boolean containsAll(ISymbol[] symbols, IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        Automaton automaton = Automatons.createAutomaton(symbols);
        return CFLReachability.containsAll(automaton, cfg, monitor);
    }

    public static boolean containsAll(ISymbol[] symbols, IContextFreeGrammar cfg) {
        return CFLReachability.containsAll(symbols, cfg);
    }

    public static boolean containsAll(List<ISymbol> symbols, IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        ISymbol[] ary = new ISymbol[symbols.size()];
        symbols.toArray(ary);
        return CFLReachability.containsAll(ary, cfg, monitor);
    }

    public static boolean containsAll(List<ISymbol> symbols, IContextFreeGrammar cfg) {
        return CFLReachability.containsAll(symbols, cfg, null);
    }

    public static void optimize(IAutomaton automaton, IContextFreeGrammar cfg) {
        CFLReachability.optimizeAutomaton(automaton, cfg);
        CFLReachability.optimizeGrammar(automaton, cfg);
    }

    private static void optimizeAutomaton(IAutomaton automaton, IContextFreeGrammar cfg) {
    }

    private static void optimizeGrammar(IAutomaton fst, IContextFreeGrammar cfg) {
    }

    public IAutomaton getLastResult() {
        return this.lastResult;
    }

    public static class SimpleTransitionFactory
    extends AbstractTransitionFactory {
        @Override
        public AnalysisTransition createTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IProductionRule rule, List<ITransition> assocTransitions) {
            return new AnalysisTransition(preState, postState, inputSymbol, outputSymbols);
        }
    }

    public static abstract class AbstractTransitionFactory
    implements ITransitionFactory {
        @Override
        public abstract AnalysisTransition createTransition(IState var1, IState var2, ISymbol var3, List<ISymbol> var4, IProductionRule var5, List<ITransition> var6);

        public AnalysisTransition createTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, IProductionRule rule, ITransition[] assocTransitions) {
            return this.createTransition(preState, postState, inputSymbol, AUtil.list(outputSymbols), rule, AUtil.list(assocTransitions));
        }

        public AnalysisTransition createTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, IProductionRule rule, ITransition assocTransition) {
            return this.createTransition(preState, postState, inputSymbol, outputSymbols, rule, new ITransition[]{assocTransition});
        }

        public AnalysisTransition createTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, IProductionRule rule, ITransition assocTransition1, ITransition assocTransition2) {
            return this.createTransition(preState, postState, inputSymbol, outputSymbols, rule, new ITransition[]{assocTransition1, assocTransition2});
        }
    }

    public static interface ITransitionFactory {
        public AnalysisTransition createTransition(IState var1, IState var2, ISymbol var3, List<ISymbol> var4, IProductionRule var5, List<ITransition> var6);
    }

    public static class AnalysisTransition
    extends Transition {
        public AnalysisTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols) {
            super(preState, postState, inputSymbol, outputSymbols);
        }

        public AnalysisTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols) {
            super(preState, postState, inputSymbol, outputSymbols);
        }

        @Override
        public boolean accept(ISymbol s, IMatchContext ctx) {
            if (this.getInputSymbol().equals(s)) {
                ctx.put(this.getInputSymbol(), s);
                return true;
            }
            return false;
        }

        @Override
        public List<ISymbol> transit(ISymbol s) {
            List<ISymbol> l = this.getOutputSymbols();
            if (l.isEmpty()) {
                return l;
            }
            if (s instanceof IVariable) {
                return Arrays.asList(s);
            }
            return this.getOutputSymbols();
        }
    }
}

