/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.VariableWrapper;
import com.ibm.wala.automaton.util.collections.Bag;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CFLTranslator
extends CFLReachability {
    private IAutomaton transducer;

    public CFLTranslator(IAutomaton transducer, MonitorUtil.IProgressMonitor monitor) {
        super(monitor);
        this.transducer = transducer;
    }

    public IContextFreeGrammar translate(IContextFreeGrammar cfg) {
        return this.translate(cfg, null);
    }

    @Override
    protected boolean doneAnalysis(Collection<ITransition> transitions, IAutomaton fst, IContextFreeGrammar cfg) {
        return false;
    }

    public IContextFreeGrammar translate(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        final FreshVariableFactory vf = varFactory == null ? new FreshVariableFactory(cfg) : varFactory;
        ProductionRuleTransitionFactory factory = new ProductionRuleTransitionFactory();
        IAutomaton result = this.analyze(this.transducer, cfg, factory, varFactory);
        DMap<StatedVariable, IVariable> m = new DMap<StatedVariable, IVariable>(){

            @Override
            protected IVariable create(StatedVariable key) {
                return vf.createVariable(Grammars.variablePrefix);
            }
        };
        Set<IProductionRule> rules = CFLTranslator.collectRules(result, this.transducer.getInitialState(), this.transducer.getFinalStates(), cfg.getStartSymbol(), m);
        Object startSymbol = vf.createVariable(Grammars.variablePrefix);
        IState initState = result.getInitialState();
        if (result.getFinalStates().size() == 1) {
            IVariable v = (IVariable)m.get(StatedVariable.make(cfg.getStartSymbol(), initState, result.getFinalStates().iterator().next()));
            startSymbol = v;
        } else {
            for (IState finalState : result.getFinalStates()) {
                StatedVariable key = StatedVariable.make(cfg.getStartSymbol(), initState, finalState);
                if (!m.containsKey(key)) continue;
                IVariable v = (IVariable)m.get(key);
                rules.add(new ProductionRule((IVariable)startSymbol, (ISymbol)v));
            }
        }
        if (rules.isEmpty()) {
            ProductionRule rule = new ProductionRule((IVariable)startSymbol, new ISymbol[0]);
            rules.add(rule);
        }
        ContextFreeGrammar cfg2 = new ContextFreeGrammar((IVariable)startSymbol, (Collection<IProductionRule>)rules);
        return cfg2;
    }

    @Override
    protected boolean isAlreadyAdded(IState preState, IState postState, ISymbol s, List<ISymbol> out, List<ITransition> assocTransitions, IProductionRule rule, IAutomaton automaton, Collection<ITransition> newTransitions) {
        if (this.monitor.isCanceled()) {
            throw CancelRuntimeException.make((String)"during CFL translation");
        }
        s = StatedVariable.make((IVariable)s, preState, postState);
        Bag l = new Bag();
        l.addAll(automaton.getTransitions(preState));
        for (ITransition t : newTransitions) {
            if (!t.getPreState().equals(preState)) continue;
            l.add(t);
        }
        for (ITransition t : l) {
            if (t instanceof ProductionRuleTransition) {
                ProductionRuleTransition pt = (ProductionRuleTransition)t;
                if (!pt.getPreState().equals(preState) || !pt.getPostState().equals(postState) || !pt.getInputSymbol().equals(s) || !pt.getOutputSymbols().equals(out) || !pt.getProductionRule().equals(rule)) continue;
                pt.getBaseTransitions().add(assocTransitions);
                return true;
            }
            if (!t.getPreState().equals(preState) || !t.getPostState().equals(postState) || !t.getInputSymbol().equals(s)) continue;
            return true;
        }
        return false;
    }

    private static Set<IProductionRule> collectRules(IAutomaton automaton, IState initState, Set<IState> finalState, IVariable startSymbol, DMap<StatedVariable, IVariable> m) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        for (ITransition t : automaton.getTransitions()) {
            StatedVariable sv;
            ISymbol s = t.getInputSymbol();
            if (!(s instanceof StatedVariable) || !(sv = (StatedVariable)s).getVariable().equals(startSymbol) || !sv.src.equals(automaton.getInitialState()) || !automaton.getFinalStates().contains(sv.dst)) continue;
            CFLTranslator.collectRules((ProductionRuleTransition)t, rules, m);
        }
        return rules;
    }

    private static Set<IProductionRule> collectRules(ProductionRuleTransition pt, Set<IProductionRule> rules, DMap<StatedVariable, IVariable> m) {
        for (ITransition iTransition : pt.getAllBaseTransition()) {
            ProductionRuleTransition bpt;
            if (!(iTransition instanceof ProductionRuleTransition) || (bpt = (ProductionRuleTransition)iTransition).getOutputSymbols().isEmpty() && bpt.getBaseTransitions().isEmpty()) continue;
            IVariable left = m.get((IVariable)bpt.getInputSymbol());
            ArrayList<ISymbol> right = new ArrayList<ISymbol>();
            for (ISymbol s : bpt.getOutputSymbols()) {
                if (s instanceof StatedVariable) {
                    s = m.get(s);
                }
                right.add(s);
            }
            ProductionRule rule = new ProductionRule(left, right);
            rules.add(rule);
        }
        return rules;
    }

    public static IContextFreeGrammar translate(IAutomaton transducer, IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        return new CFLTranslator(transducer, monitor).translate(cfg, varFactory);
    }

    public static class StatedVariable
    extends VariableWrapper {
        public final IState src;
        public final IState dst;

        protected StatedVariable(IVariable v, IState src, IState dst) {
            super(v);
            this.src = src;
            this.dst = dst;
        }

        public static StatedVariable make(IVariable v, IState src, IState dst) {
            return new StatedVariable(v, src, dst);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.src + "," + this.dst + "]";
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.src.hashCode() * 13 + this.dst.hashCode() * 29;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof StatedVariable)) {
                return false;
            }
            StatedVariable other = (StatedVariable)obj;
            return super.equals(other) && this.src.equals(other.src) && this.dst.equals(other.dst);
        }
    }

    public static class ProductionRuleTransitionFactory
    extends CFLReachability.AbstractTransitionFactory {
        @Override
        public CFLReachability.AnalysisTransition createTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IProductionRule rule, List<ITransition> assocTransitions) {
            inputSymbol = StatedVariable.make((IVariable)inputSymbol, preState, postState);
            return new ProductionRuleTransition(preState, postState, inputSymbol, outputSymbols, rule, assocTransitions);
        }
    }

    public static class ProductionRuleTransition
    extends CFLReachability.AnalysisTransition {
        private IProductionRule rule;
        private List<List<ITransition>> baseTransitions;

        public ProductionRuleTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IProductionRule rule, List<ITransition> assocTransitions) {
            super(preState, postState, inputSymbol, outputSymbols);
            this.rule = rule;
            this.baseTransitions = new ArrayList<List<ITransition>>();
            this.baseTransitions.add(assocTransitions);
        }

        public ProductionRuleTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IProductionRule rule) {
            super(preState, postState, inputSymbol, outputSymbols);
            this.rule = rule;
            this.baseTransitions = new ArrayList<List<ITransition>>();
        }

        public ProductionRuleTransition(ProductionRuleTransition transition) {
            this(transition.getPreState(), transition.getPostState(), transition.getInputSymbol(), transition.getOutputSymbols(), transition.getProductionRule());
            this.baseTransitions.addAll(transition.getBaseTransitions());
        }

        public IProductionRule getProductionRule() {
            return this.rule;
        }

        @Override
        public boolean accept(ISymbol s, IMatchContext ctx) {
            if (s instanceof IVariable && ((StatedVariable)this.getInputSymbol()).getVariable().equals(s)) {
                ctx.put(this.getInputSymbol(), s);
                return true;
            }
            return super.accept(s, ctx);
        }

        @Override
        public List<ISymbol> transit(ISymbol s) {
            List<ISymbol> l = this.getOutputSymbols();
            if (l.isEmpty()) {
                return l;
            }
            if (s instanceof IVariable) {
                return Arrays.asList(StatedVariable.make((IVariable)s, this.getPreState(), this.getPostState()));
            }
            return this.getOutputSymbols();
        }

        public List<List<ITransition>> getBaseTransitions() {
            return this.baseTransitions;
        }

        public List<ProductionRuleTransition> getAllBaseTransitions(List<ProductionRuleTransition> l) {
            if (l.contains(this)) {
                return l;
            }
            l.add(this);
            for (List<ITransition> ts : this.baseTransitions) {
                for (ITransition t : ts) {
                    if (!(t instanceof ProductionRuleTransition)) continue;
                    ProductionRuleTransition pt = (ProductionRuleTransition)t;
                    pt.getAllBaseTransitions(l);
                }
            }
            return l;
        }

        public List<ProductionRuleTransition> getAllBaseTransition() {
            return this.getAllBaseTransitions(new ArrayList<ProductionRuleTransition>());
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.rule.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass().equals(obj.getClass())) {
                ProductionRuleTransition trans = (ProductionRuleTransition)obj;
                return super.equals(obj) && this.rule.equals(trans.rule) && this.baseTransitions.equals(trans.baseTransitions);
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + "#{rule:" + this.rule + "}";
        }
    }
}

