/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.IVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProductionRule
implements IProductionRule {
    private IVariable left;
    private List<ISymbol> sequence;
    private int hashCode;

    public ProductionRule(IVariable left, List<? extends ISymbol> sequence) {
        this.init(left, sequence);
    }

    public ProductionRule(IVariable left, ISymbol ... sequence) {
        this.init(left, Arrays.asList(sequence));
    }

    public ProductionRule(IVariable left, ISymbol right) {
        this(left, new ISymbol[]{right});
    }

    public ProductionRule(IProductionRule rule) {
        this.init(rule.getLeft(), rule.getRight());
    }

    private void init(IVariable left, List<? extends ISymbol> sequence) {
        this.left = left;
        this.sequence = Collections.unmodifiableList(new ArrayList<ISymbol>(sequence));
        this.hashCode = 0;
    }

    @Override
    public IVariable getLeft() {
        return this.left;
    }

    public void setLeft(IVariable left) {
        this.left = left;
    }

    @Override
    public List<ISymbol> getRight() {
        return this.sequence;
    }

    @Override
    public ISymbol getRight(int index) {
        return this.sequence.get(index);
    }

    @Override
    public void traverseSymbols(ISymbolVisitor visitor) {
        this.left.traverse(visitor);
        for (ISymbol s : this.sequence) {
            s.traverse(visitor);
        }
    }

    @Override
    public void traverse(IRuleVisitor visitor) {
        visitor.onVisit(this);
    }

    @Override
    public boolean isEpsilonRule() {
        return this.sequence.isEmpty();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + (this.left == null ? 0 : this.left.hashCode());
            this.hashCode = 31 * this.hashCode + (this.sequence == null ? 0 : this.sequence.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductionRule other = (ProductionRule)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        Iterator<ISymbol> i = this.getRight().iterator();
        while (i.hasNext()) {
            ISymbol symbol = i.next();
            buff.append(symbol);
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return this.left.toString() + " -> " + buff.toString();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IProductionRule copy(IRuleCopier copier) {
        IProductionRule rule = copier.copy(this);
        if (rule instanceof ProductionRule) {
            ProductionRule prule = (ProductionRule)rule;
            IVariable sym = copier.copyLeft(prule.left);
            List l = (List)copier.copyRight(prule.sequence, new ArrayList<ISymbol>());
            if (!(sym instanceof IVariable)) {
                System.err.println(prule.left);
                System.err.println(prule);
                System.err.println(sym);
                System.err.println(l);
            }
            prule.left = sym;
            prule.sequence = l;
            prule.hashCode = 0;
        }
        return rule;
    }
}

