/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IGrammarSymbol;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.grammar.tree.RTLComparator;
import com.ibm.wala.automaton.grammar.tree.TreeGrammar;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.tree.BinaryTreeVariable;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;

public class RTGSymbol
implements IBinaryTree,
IGrammarSymbol {
    private ITreeGrammar tg;

    public RTGSymbol(ITreeGrammar tg) {
        this.tg = tg;
    }

    public ITreeGrammar getTreeGrammar() {
        return this.tg;
    }

    @Override
    public String getName() {
        return this.tg.toString();
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof RTGSymbol) {
            ITreeGrammar tg2 = ((RTGSymbol)symbol).getTreeGrammar();
            return RTLComparator.defaultComparator.contains(this.tg, tg2);
        }
        if (symbol instanceof IBinaryTree) {
            BinaryTreeVariable v = new BinaryTreeVariable("G");
            TreeGrammar tg2 = new TreeGrammar((IBinaryTreeVariable)v, (IProductionRule[])new ProductionRule[]{new ProductionRule((IVariable)v, symbol)});
            return RTLComparator.defaultComparator.contains(this.tg, tg2);
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        return this.matches(symbol, context) || symbol.matches(this, context);
    }

    public int hashCode() {
        return this.tg.hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        RTGSymbol tgSym = (RTGSymbol)obj;
        return this.tg.equals(tgSym.tg);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof RTGSymbol) {
            RTGSymbol tgSym = (RTGSymbol)s;
            if (copier instanceof IGrammarCopier) {
                IGrammarCopier gCopier = (IGrammarCopier)copier;
                tgSym.tg = (ITreeGrammar)gCopier.copy(tgSym.tg);
            }
        }
        return s;
    }

    public String toString() {
        return "RTGSymbol(" + this.tg.toString() + ")";
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public ISymbol getLabel() {
        return this.tg.getStartSymbol();
    }

    @Override
    public IGrammar getGrammar() {
        return this.tg;
    }
}

