/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPatternCompiler;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IntersectionPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.Transition;

public class StringPatternCompiler
extends AbstractPatternCompiler<IAutomaton> {
    @Override
    public IAutomaton onComplement(ComplementPattern pattern) {
        return Automatons.createComplement((IAutomaton)this.compile(pattern.getPattern()));
    }

    @Override
    public IAutomaton onConcatenation(ConcatenationPattern pattern) {
        return Automatons.createConcatenation((IAutomaton)this.compile(pattern.getHead()), (IAutomaton)this.compile(pattern.getTail()));
    }

    @Override
    public IAutomaton onEmpty(EmptyPattern pattern) {
        return Automatons.createAutomaton(new ISymbol[0]);
    }

    @Override
    public IAutomaton onIntersection(IntersectionPattern pattern) {
        return Automatons.createIntersection((IAutomaton)this.compile(pattern.getLeft()), (IAutomaton)this.compile(pattern.getRight()));
    }

    @Override
    public IAutomaton onIteration(IterationPattern pattern) {
        int i;
        IPattern pat = pattern.getPattern();
        int lower = pattern.getLower();
        int upper = pattern.getUpper();
        IAutomaton a = null;
        IAutomaton b = null;
        for (i = 0; i < lower; ++i) {
            a = a == null ? (IAutomaton)this.compile(pat) : Automatons.createConcatenation(a, (IAutomaton)this.compile(pat));
        }
        if (upper >= 0) {
            while (i < upper) {
                b = b == null ? (IAutomaton)this.compile(pat) : Automatons.createConcatenation(b, (IAutomaton)this.compile(pat));
                for (IState fin : b.getFinalStates()) {
                    Transition t = new Transition(b.getInitialState(), fin);
                    b.getTransitions().add(t);
                }
                ++i;
            }
        } else {
            b = (IAutomaton)this.compile(pat);
            for (IState fin : b.getFinalStates()) {
                Transition t = new Transition(fin, b.getInitialState());
                b.getTransitions().add(t);
            }
            b.getFinalStates().clear();
            b.getFinalStates().add(b.getInitialState());
        }
        if (a == null) {
            a = b;
        } else if (b != null) {
            a = Automatons.createConcatenation(a, b);
        }
        return a;
    }

    @Override
    public IAutomaton onSymbol(SymbolPattern pattern) {
        ISymbol s = pattern.getSymbol();
        return Automatons.createAutomaton(new ISymbol[]{s});
    }

    @Override
    public IAutomaton onUnion(UnionPattern pattern) {
        return Automatons.createUnion((IAutomaton)this.compile(pattern.getLeft()), (IAutomaton)this.compile(pattern.getRight()));
    }

    @Override
    public IAutomaton onVariableBinding(VariableBindingPattern pattern) {
        return (IAutomaton)this.compile(pattern.getPattern());
    }

    @Override
    public IAutomaton onVariableReference(VariableReferencePattern pattern) {
        return (IAutomaton)this.compile(SymbolPattern.ANY_STRING_PATTERN);
    }
}

