/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.CFGSymbol;
import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCompiler;
import com.ibm.wala.automaton.regex.string.StringPatternCompiler;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.util.MonitorUtil;
import java.util.List;

public class StringPatternSymbol
implements ISymbol {
    public static final IPatternCompiler<IAutomaton> defaultCompiler = new StringPatternCompiler();
    IPattern pattern;
    IAutomaton compiledPattern;
    IPatternCompiler<IAutomaton> compiler;
    MonitorUtil.IProgressMonitor monitor;

    public StringPatternSymbol(IPattern pattern, IPatternCompiler<IAutomaton> compiler, MonitorUtil.IProgressMonitor monitor) {
        this.pattern = pattern;
        this.compiler = compiler;
        this.compiledPattern = pattern == null ? null : compiler.compile(pattern);
        this.monitor = monitor;
    }

    public StringPatternSymbol(IPattern pattern, MonitorUtil.IProgressMonitor monitor) {
        this(pattern, defaultCompiler, monitor);
    }

    public IAutomaton getCompiledPattern() {
        return this.compiledPattern;
    }

    public IPattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getName() {
        return this.pattern.toString();
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StringPatternSymbol) {
            StringPatternSymbol sps = (StringPatternSymbol)symbol;
            IContextFreeGrammar cfg = Grammars.toCFG(sps.compiledPattern);
            if (CFLReachability.containsAll(this.compiledPattern, cfg, this.monitor)) {
                context.put(this, sps);
                return true;
            }
            return false;
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol strSym = (StringSymbol)symbol;
            List<CharSymbol> cs = strSym.toCharSymbols();
            if (this.compiledPattern.accept(cs)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfgSymbol = (CFGSymbol)symbol;
            if (CFLReachability.containsAll(this.compiledPattern, cfgSymbol.getGrammar(), this.monitor)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (this.compiledPattern.accept(AUtil.list(symbol))) {
            context.put(this, symbol);
            return true;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StringPatternSymbol) {
            StringPatternSymbol sps = (StringPatternSymbol)symbol;
            IContextFreeGrammar cfg = Grammars.toCFG(sps.compiledPattern);
            if (CFLReachability.containsSome(cfg, this.compiledPattern, this.monitor)) {
                context.put(this, sps);
                return true;
            }
            return false;
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol strSym = (StringSymbol)symbol;
            List<CharSymbol> cs = strSym.toCharSymbols();
            if (this.compiledPattern.accept(cs)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfgSymbol = (CFGSymbol)symbol;
            if (CFLReachability.containsSome(cfgSymbol.getGrammar(), this.compiledPattern, this.monitor)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (this.compiledPattern.accept(AUtil.list(symbol))) {
            context.put(this, symbol);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.compiledPattern.hashCode() + this.compiler.hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        StringPatternSymbol ps = (StringPatternSymbol)obj;
        return this.pattern.equals(ps.pattern) && this.compiledPattern.equals(ps.compiledPattern) && this.compiler.equals(this.compiler);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof StringPatternSymbol) {
            StringPatternSymbol ps = (StringPatternSymbol)s;
            if (copier instanceof ISTSCopier) {
                ISTSCopier scopier = (ISTSCopier)copier;
                ps.compiledPattern = (IAutomaton)scopier.copy(ps.compiledPattern);
            }
        }
        return s;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

