/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateCopier;
import com.ibm.wala.automaton.string.State;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CompositeState
extends State {
    Set<IState> states;

    public CompositeState(String name, IState[] states) {
        this(name, AUtil.set(states));
    }

    public CompositeState(String name, Set<IState> states) {
        super(name);
        this.states = new HashSet<IState>(states);
    }

    @Override
    public IState copy(IStateCopier copier) {
        IState s = super.copy(copier);
        if (s instanceof CompositeState) {
            CompositeState cs = (CompositeState)s;
            cs.states = (Set)copier.copyStates(cs.states, new HashSet<IState>());
        }
        return s;
    }

    public Iterator<IState> getStates() {
        return this.states.iterator();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.states.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            CompositeState cs = (CompositeState)obj;
            return this.states.equals(cs.states);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        Iterator<IState> i = this.states.iterator();
        while (i.hasNext()) {
            IState s = i.next();
            buff.append(s);
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        return super.toString() + "(" + buff + ")";
    }
}

