/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.tree.IParentTree;
import com.ibm.wala.automaton.tree.ITree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Tree
implements IParentTree {
    private List<ITree> children;
    private ISymbol label;

    public Tree(ISymbol label, List<ITree> children) {
        this.label = label;
        this.children = children == null ? new ArrayList<ITree>() : new ArrayList<ITree>(children);
    }

    public Tree(String label, List<ITree> children) {
        this((ISymbol)new StringSymbol(label), children);
    }

    public Tree(ISymbol label, ITree[] children) {
        this(label);
        for (int i = 0; i < children.length; ++i) {
            this.addChild(children[i]);
        }
    }

    public Tree(String label, ITree[] children) {
        this((ISymbol)new StringSymbol(label), children);
    }

    public Tree(ISymbol label) {
        this(label, (List<ITree>)null);
    }

    public Tree(String label) {
        this(new StringSymbol(label));
    }

    @Override
    public List<ITree> getChildren() {
        return this.children;
    }

    @Override
    public ISymbol getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Tree tree = (Tree)obj;
        if (!this.label.equals(tree.getLabel())) {
            return false;
        }
        int size = this.children.size();
        if (size != tree.children.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            ITree child2;
            ITree child1 = this.getChild(i);
            if (child1.equals(child2 = tree.getChild(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (!(symbol instanceof IParentTree)) {
            return false;
        }
        IParentTree tree = (IParentTree)symbol;
        if (!this.label.matches(tree.getLabel(), ctx)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ITree child2;
            ITree child1 = this.getChild(i);
            if (!(i < tree.size() ? !child1.matches(child2 = tree.getChild(i), ctx) : !child1.matches(null, ctx))) continue;
            return false;
        }
        ctx.put(this, symbol);
        return true;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (!(symbol instanceof IParentTree)) {
            return false;
        }
        IParentTree tree = (IParentTree)symbol;
        if (!this.label.possiblyMatches(tree.getLabel(), ctx)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ITree child2;
            ITree child1 = this.getChild(i);
            if (!(i < tree.size() ? !child1.possiblyMatches(child2 = tree.getChild(i), ctx) : !child1.possiblyMatches(null, ctx))) continue;
            return false;
        }
        ctx.put(this, symbol);
        return true;
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        this.label.traverse(visitor);
        for (ITree child : this.children) {
            child.traverse(visitor);
        }
        visitor.onLeave(this);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof Tree) {
            Tree t = (Tree)s;
            t.label = copier.copySymbolReference(t, t.label);
            ArrayList<ITree> children = new ArrayList<ITree>();
            for (ISymbol u : copier.copySymbolReferences(t, t.children, new ArrayList<ISymbol>())) {
                children.add((ITree)u);
            }
            t.children = children;
        }
        return s;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public ITree getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public void addChild(ITree symbol) {
        this.children.add(symbol);
    }

    @Override
    public void addChildren(Collection<? extends ITree> children) {
        Iterator<? extends ITree> i = children.iterator();
        while (i.hasNext()) {
            this.addChild(i.next());
        }
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Iterator<ITree> i = this.children.iterator();
        while (i.hasNext()) {
            ITree t = i.next();
            buff.append(t == null ? "#null" : t.toString());
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        return this.label.toString() + "[" + buff.toString() + "]";
    }
}

