/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.tree.BinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import com.ibm.wala.automaton.tree.IParentTree;
import com.ibm.wala.automaton.tree.ITree;
import com.ibm.wala.automaton.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TreeAutomatons {
    public static IBinaryTree binarize(ITree tree, AbstractBinarizationCopier copier) {
        return (IBinaryTree)tree.copy(copier);
    }

    public static IBinaryTree binarize(ITree tree) {
        return TreeAutomatons.binarize(tree, (AbstractBinarizationCopier)BinarizationCopier.defaultCopier);
    }

    public static IBinaryTree binarize(Collection<ITree> trees, AbstractBinarizationCopier copier) {
        Collection<ISymbol> c = copier.copySymbols(trees, new ArrayList<ISymbol>());
        Iterator<ISymbol> i = c.iterator();
        if (i.hasNext()) {
            return (IBinaryTree)i.next();
        }
        return null;
    }

    public static IBinaryTree binarize(Collection<ITree> trees) {
        return TreeAutomatons.binarize(trees, (AbstractBinarizationCopier)BinarizationCopier.defaultCopier);
    }

    public static List<ITree> unbinarize(IBinaryTree tree, AbstractUnbinarizationCopier copier) {
        BinaryTree bt = new BinaryTree("_", tree, null);
        IParentTree t = (IParentTree)bt.copy(copier);
        return t.getChildren();
    }

    public static List<ITree> unbinarize(IBinaryTree tree) {
        return TreeAutomatons.unbinarize(tree, UnbinarizationCopier.defaultCopier);
    }

    public static class UnbinarizationCopier
    extends AbstractUnbinarizationCopier {
        public static final UnbinarizationCopier defaultCopier = new UnbinarizationCopier();

        @Override
        protected IParentTree createTree(ISymbol s) {
            return new Tree(s);
        }
    }

    public static class BinarizationCopier
    extends AbstractBinarizationCopier {
        public static final BinarizationCopier defaultCopier = new BinarizationCopier();

        @Override
        protected IParentBinaryTree createBinaryTree(ISymbol s) {
            return new BinaryTree(s);
        }
    }

    public static abstract class AbstractUnbinarizationCopier
    implements ISymbolCopier {
        protected abstract IParentTree createTree(ISymbol var1);

        @Override
        public ISymbol copy(ISymbol symbol) {
            IParentBinaryTree bt = (IParentBinaryTree)symbol;
            IBinaryTree lbt = bt.getLeft();
            IParentTree t = this.createTree(bt.getLabel());
            t.getChildren().addAll(this.copyAll(lbt));
            return t;
        }

        @Override
        public IVariable copyVariable(IVariable var) {
            return (IVariable)this.copy(var);
        }

        public Collection<ITree> copyAll(IBinaryTree bt) {
            List<ITree> l = null;
            if (bt.equals(BinaryTree.LEAF)) {
                return new ArrayList<ITree>();
            }
            if (bt instanceof IParentBinaryTree) {
                IParentBinaryTree pbt = (IParentBinaryTree)bt;
                l = pbt.getRight() == null ? new ArrayList<ITree>() : (List)this.copyAll(pbt.getRight());
                l.add(0, (ITree)this.copy(pbt));
                return l;
            }
            throw new AssertionError((Object)"should not reach this code.");
        }

        @Override
        public Collection<ISymbol> copySymbols(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
            throw new AssertionError((Object)"should not reach this code.");
        }

        @Override
        public String copyName(String name) {
            return name;
        }

        @Override
        public ISymbol copySymbolReference(ISymbol parent, ISymbol symbol) {
            throw new AssertionError((Object)"should not reach this code.");
        }

        @Override
        public Collection<ISymbol> copySymbolReferences(ISymbol parent, Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
            throw new AssertionError((Object)"should not reach this code.");
        }
    }

    public static abstract class AbstractBinarizationCopier
    implements ISymbolCopier {
        protected abstract IParentBinaryTree createBinaryTree(ISymbol var1);

        @Override
        public ISymbol copy(ISymbol symbol) {
            IParentTree t = (IParentTree)symbol;
            IBinaryTree cbt = this.copyAll(t.getChildren().iterator());
            IParentBinaryTree bt = this.createBinaryTree(t.getLabel());
            bt.setLeft(cbt);
            return bt;
        }

        @Override
        public IVariable copyVariable(IVariable var) {
            return (IVariable)this.copy(var);
        }

        private IBinaryTree copy(ISymbol tree, Iterator<? extends ISymbol> siblings) {
            IParentBinaryTree t = (IParentBinaryTree)tree.copy(this);
            if (siblings.hasNext()) {
                IParentTree r = (IParentTree)siblings.next();
                IBinaryTree br = this.copy(r, siblings);
                t.setRight(br);
            }
            return t;
        }

        private IBinaryTree copyAll(Iterator<? extends ISymbol> i) {
            if (i.hasNext()) {
                return this.copy(i.next(), i);
            }
            return null;
        }

        @Override
        public String copyName(String name) {
            return name;
        }

        @Override
        public Collection<ISymbol> copySymbols(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
            IBinaryTree bt = this.copyAll(symbols.iterator());
            result.add(bt);
            return result;
        }

        @Override
        public ISymbol copySymbolReference(ISymbol parent, ISymbol symbol) {
            throw new AssertionError((Object)"should not reach this code.");
        }

        @Override
        public Collection<ISymbol> copySymbolReferences(ISymbol parent, Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
            throw new AssertionError((Object)"should not reach this code.");
        }
    }
}

