/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.labeledgraph;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.graph.EdgeManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleEdgeManager<T>
implements EdgeManager<T> {
    private final Map<T, Set<T>> succs;
    private final Map<T, Set<T>> preds;

    public SimpleEdgeManager(int initialCapacity) {
        this.succs = new HashMap<T, Set<T>>(initialCapacity);
        this.preds = new HashMap<T, Set<T>>(initialCapacity);
    }

    public void addEdge(T src, T dst) {
        Set s = MapUtil.findOrCreateSet(this.succs, src);
        s.add(dst);
        s = MapUtil.findOrCreateSet(this.preds, dst);
        s.add(src);
    }

    public int getPredNodeCount(T N) {
        Set<T> s = this.preds.get(N);
        if (s == null) {
            return 0;
        }
        return s.size();
    }

    public Iterator<T> getPredNodes(T N) {
        Set<T> s = this.preds.get(N);
        if (s == null) {
            return EmptyIterator.instance();
        }
        return s.iterator();
    }

    public int getSuccNodeCount(T N) {
        Set<T> s = this.succs.get(N);
        if (s == null) {
            return 0;
        }
        return s.size();
    }

    public Iterator<T> getSuccNodes(T N) {
        Set<T> s = this.succs.get(N);
        if (s == null) {
            return EmptyIterator.instance();
        }
        return s.iterator();
    }

    public boolean hasEdge(T src, T dst) {
        Set<T> s = this.succs.get(src);
        if (s == null) {
            return false;
        }
        return s.contains(dst);
    }

    public void removeAllIncidentEdges(T node) {
        this.removeIncomingEdges(node);
        this.removeOutgoingEdges(node);
    }

    public void removeEdge(T src, T dst) {
        Set s = MapUtil.findOrCreateSet(this.succs, src);
        s.remove(dst);
        s = MapUtil.findOrCreateSet(this.preds, dst);
        s.remove(src);
    }

    public void removeIncomingEdges(T node) {
        Set<T> s = this.preds.get(node);
        if (s == null) {
            return;
        }
        s.clear();
    }

    public void removeOutgoingEdges(T node) {
        Set<T> s = this.succs.get(node);
        if (s == null) {
            return;
        }
        s.clear();
    }
}

