/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.jsp.compilers;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.discovery.jsp.Messages;
import com.ibm.appscan.internal.discovery.jsp.compilers.ServletMappings;
import java.io.File;
import java.io.FilenameFilter;

public abstract class BaseJSPCompiler {
    public static final String JSP_COMPILER_KEY = "jsp_compiler";
    public static final String WEB_SERVER_TYPE = "web_server_type";
    public static final String JSP_COMPILER_NONE = "NONE";
    public static final String JSP_COMPILER_DEFAULT = "Default Tomcat JSP Compiler";
    private String m_serverClasspath;
    protected IScanTargetMinProxy m_proxy;
    protected File m_webapp;
    protected File m_outDir;
    private boolean m_success = false;
    private ServletMappings m_mappings = null;

    protected BaseJSPCompiler(String[] classpathEntries) {
        this.m_serverClasspath = ClasspathUtil.joinPaths((String[])classpathEntries);
    }

    public final String getServerClasspath() {
        return this.m_serverClasspath;
    }

    public abstract String getServerType();

    public void init(IScanTargetMinProxy proxy, File webapp, File outDir) {
        this.m_proxy = proxy;
        this.m_webapp = webapp;
        this.m_outDir = outDir;
    }

    protected final void initMappings(File descriptor) {
        if (descriptor.exists()) {
            this.m_mappings = new ServletMappings(descriptor);
            try {
                this.m_mappings.read();
            }
            catch (Exception e) {
                this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract boolean run(IProgress var1) throws Exception;

    public final void exec(IProgress progress) {
        this.m_outDir.mkdirs();
        try {
            this.m_success = this.run(progress);
        }
        catch (Exception e) {
            this.m_proxy.getErrorManager().reportError(Messages.getMessage("err.jsp.compiler", new Object[0]), (Throwable)e);
        }
        ClasspathUtil.appendToClasspath((String)this.m_serverClasspath, (IScanTargetMinProxy)this.m_proxy);
    }

    public final boolean isSuccess() {
        return this.m_success;
    }

    private File[] getCompiledClasses(String clazz) {
        File primaryClass = new File(this.m_outDir, clazz);
        if (primaryClass.exists()) {
            int size;
            final String primaryClassName = primaryClass.getName();
            File[] innerClasses = primaryClass.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int dollar;
                    return name.toLowerCase().endsWith(".class") && (dollar = name.indexOf(36)) != -1 && primaryClassName.equals((name = name.substring(0, dollar)) + ".class");
                }
            });
            if (innerClasses == null || (size = innerClasses.length) == 0) {
                return new File[]{primaryClass};
            }
            File[] classes = new File[size + 1];
            classes[0] = primaryClass;
            System.arraycopy(innerClasses, 0, classes, 1, size);
            return classes;
        }
        return new File[0];
    }

    public File[] getCompiledClasses(String jspPath, IProgress progress) {
        String clazz;
        if (this.m_mappings != null && (clazz = this.m_mappings.getServletClass('/' + jspPath)) != null) {
            return this.getCompiledClasses(clazz.replace('.', '/') + ".class");
        }
        return new File[0];
    }
}

