/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Bytecode;
import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.types.TypeReference;
import java.util.Set;

public class CILConversionInstruction
implements IConversionInstruction {
    private final Translator.RuntimeType fromType;
    private final Translator.RuntimeType toType;
    private final TypeReference toTypeRef;
    private final Set<Bytecode.Flag> flags;

    CILConversionInstruction(Set<Bytecode.Flag> flags, Translator.RuntimeType fromType, Translator.RuntimeType toType, TypeReference toTypeRef) {
        this.fromType = fromType;
        this.toType = toType;
        this.toTypeRef = toTypeRef;
        this.flags = flags;
    }

    public String toString() {
        return "Convert(" + (Object)((Object)this.fromType) + "->" + this.toTypeRef.getName() + ":" + (Object)((Object)this.toType) + ")";
    }

    public String getFromType() {
        return this.fromType.toString();
    }

    public String getToType() {
        return this.toTypeRef.getName().toString();
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public short getOpcode() {
        return -1;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.toTypeRef.getName().toString();
    }

    public byte getPushedWordSize() {
        return this.toTypeRef == CLRTypeReference.Int64 || this.toTypeRef == CLRTypeReference.UInt64 || this.toTypeRef == CLRTypeReference.Float64 ? (byte)2 : 1;
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return this.flags.contains((Object)Bytecode.Flag.flag_ovf);
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitConversion((IConversionInstruction)this);
    }

    public boolean throwsExceptionOnOverflow() {
        return this.flags.contains((Object)Bytecode.Flag.flag_ovf);
    }
}

