/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.LanguageImpl;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.dotnet.Constants;
import com.ibm.wala.dotnet.analysis.typeInference.CLRPrimitiveType;
import com.ibm.wala.dotnet.cil.CILArrayStoreInstruction;
import com.ibm.wala.dotnet.cil.CILBinaryOpInstruction;
import com.ibm.wala.dotnet.cil.CILInvokeInstruction;
import com.ibm.wala.dotnet.cil.CILUnaryOpInstruction;
import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadIndirectInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreIndirectInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class CLRLanguage
extends LanguageImpl
implements BytecodeLanguage {
    public static final Language lang = new CLRLanguage();
    public static final Collection<TypeReference> ArithmeticExceptions = Collections.singleton(CLRTypeReference.ArithmeticException);
    public static final Collection<TypeReference> ArrayAccessExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.NullReferenceException, CLRTypeReference.IndexOutOfRangeException));
    public static final Collection<TypeReference> ArrayObjectStoreAndElementAddressExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.NullReferenceException, CLRTypeReference.IndexOutOfRangeException, CLRTypeReference.ArrayTypeMismatchException));
    public static final Collection<TypeReference> CallExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.SecurityException, CLRTypeReference.MethodAccessException, CLRTypeReference.MissingMethodException));
    public static final Collection<TypeReference> CalliExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.SecurityException));
    public static final Collection<TypeReference> CallvirtExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.SecurityException, CLRTypeReference.MissingMethodException, CLRTypeReference.NullReferenceException));
    public static final Collection<TypeReference> CastclassExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.InvalidCastException, CLRTypeReference.TypeLoadException));
    public static final Collection<TypeReference> DivideByZeroExceptions = Collections.singleton(CLRTypeReference.DivideByZeroException);
    public static final Collection<TypeReference> FieldAccessExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.NullReferenceException, CLRTypeReference.FieldAccessException, CLRTypeReference.MissingFieldException));
    public static final Collection<TypeReference> IntegralDivideExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.DivideByZeroException, CLRTypeReference.ArithmeticException));
    public static final Collection<TypeReference> NewArrayExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.OutOfMemoryException, CLRTypeReference.OverflowException));
    public static final Collection<TypeReference> NewObjectExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.InvalidOperationException, CLRTypeReference.MissingMethodException, CLRTypeReference.OutOfMemoryException));
    public static final Collection<TypeReference> NullReferenceExceptions = Collections.singleton(CLRTypeReference.NullReferenceException);
    public static final Collection<TypeReference> ObjectOpExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.TypeLoadException, CLRTypeReference.OutOfMemoryException));
    public static final Collection<TypeReference> OverflowExceptions = Collections.singleton(CLRTypeReference.OverflowException);
    public static final Collection<TypeReference> StaticFieldAccessExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.FieldAccessException, CLRTypeReference.MissingFieldException));
    public static final Collection<TypeReference> TypeLoadExceptions = Collections.singleton(CLRTypeReference.TypeLoadException);
    public static final Collection<TypeReference> UnboxExceptions = Collections.unmodifiableCollection(Arrays.asList(CLRTypeReference.InvalidCastException, CLRTypeReference.NullReferenceException, CLRTypeReference.TypeLoadException));
    private static final SSAInstructionFactory cilInstructionFactory = new SSAInstructionFactory(){

        public SSAArrayLengthInstruction ArrayLengthInstruction(int iindex, int result, int arrayref) {
            return new SSAArrayLengthInstruction(iindex, result, arrayref){

                public Collection<TypeReference> getExceptionTypes() {
                    return NullReferenceExceptions;
                }
            };
        }

        public SSAArrayLoadInstruction ArrayLoadInstruction(int iindex, int result, int arrayref, int index, TypeReference declaredType) {
            return new SSAArrayLoadInstruction(iindex, result, arrayref, index, declaredType){

                public Collection<TypeReference> getExceptionTypes() {
                    return ArrayAccessExceptions;
                }
            };
        }

        public SSAArrayStoreInstruction ArrayStoreInstruction(int iindex, int arrayref, int index, int value, TypeReference declaredType) {
            return new SSAArrayStoreInstruction(iindex, arrayref, index, value, declaredType){

                public Collection<TypeReference> getExceptionTypes() {
                    return CLRLanguage.arrayStoreExceptions(this.getElementType());
                }
            };
        }

        public SSABinaryOpInstruction BinaryOpInstruction(int iindex, IBinaryOpInstruction.IOperator operator, final boolean overflow, final boolean unsigned, int result, int val1, int val2, final boolean mayBeInteger) {
            return new SSABinaryOpInstruction(iindex, operator, result, val1, val2, mayBeInteger){

                public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
                    return insts.BinaryOpInstruction(this.iindex, this.getOperator(), overflow, unsigned, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], uses == null ? this.getUse(1) : uses[1], this.mayBeIntegerOp());
                }

                public boolean isPEI() {
                    return overflow || (this.getOperator() == IBinaryOpInstruction.Operator.DIV || this.getOperator() == IBinaryOpInstruction.Operator.REM) && mayBeInteger;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    if (overflow) {
                        return OverflowExceptions;
                    }
                    if ((this.getOperator() == IBinaryOpInstruction.Operator.DIV || this.getOperator() == IBinaryOpInstruction.Operator.REM) && mayBeInteger) {
                        if (unsigned) {
                            return DivideByZeroExceptions;
                        }
                        return IntegralDivideExceptions;
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference[] types, boolean isPEI) {
            return new SSACheckCastInstruction(iindex, result, val, types, isPEI){

                public Collection<TypeReference> getExceptionTypes() {
                    return this.isPEI() ? CastclassExceptions : null;
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int[] typeValues, boolean isPEI) {
            throw new UnsupportedOperationException();
        }

        public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int typeValue, boolean isPEI) {
            return this.CheckCastInstruction(iindex, result, val, new int[]{typeValue}, isPEI);
        }

        public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference type, boolean isPEI) {
            return this.CheckCastInstruction(iindex, result, val, new TypeReference[]{type}, isPEI);
        }

        public SSAComparisonInstruction ComparisonInstruction(int iindex, IComparisonInstruction.Operator operator, int result, int val1, int val2) {
            return new SSAComparisonInstruction(iindex, operator, result, val1, val2);
        }

        public SSAConditionalBranchInstruction ConditionalBranchInstruction(int iindex, IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2, int target) {
            return new SSAConditionalBranchInstruction(iindex, operator, type, val1, val2, target);
        }

        public SSAConversionInstruction ConversionInstruction(int iindex, int result, int val, TypeReference fromType, TypeReference toType, final boolean overflow) {
            return new SSAConversionInstruction(iindex, result, val, fromType, toType){

                public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
                    return insts.ConversionInstruction(this.iindex, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], this.getFromType(), this.getToType(), false);
                }

                public boolean isPEI() {
                    return overflow;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    if (overflow) {
                        return OverflowExceptions;
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSAGetCaughtExceptionInstruction GetCaughtExceptionInstruction(int iindex, int bbNumber, int exceptionValueNumber) {
            return new SSAGetCaughtExceptionInstruction(iindex, bbNumber, exceptionValueNumber);
        }

        public SSAGetInstruction GetInstruction(int iindex, int result, FieldReference field) {
            return new SSAGetInstruction(iindex, result, field){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return StaticFieldAccessExceptions;
                }
            };
        }

        public SSAGetInstruction GetInstruction(int iindex, int result, int ref, FieldReference field) {
            return new SSAGetInstruction(iindex, result, ref, field){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return FieldAccessExceptions;
                }
            };
        }

        public SSAGotoInstruction GotoInstruction(int iindex, int target) {
            return new SSAGotoInstruction(iindex, target);
        }

        public SSAInstanceofInstruction InstanceofInstruction(int iindex, int result, int ref, TypeReference checkedType) {
            return new SSAInstanceofInstruction(iindex, result, ref, checkedType){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return TypeLoadExceptions;
                }
            };
        }

        public SSAInvokeInstruction InvokeInstruction(int iindex, int result, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod m) {
            return new SSAInvokeInstruction(iindex, result, params, exception, site){

                public Collection<TypeReference> getExceptionTypes() {
                    return CLRLanguage.invokeExceptions(this.getInvocationCode());
                }
            };
        }

        public SSAInvokeInstruction InvokeInstruction(int iindex, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod m) {
            return new SSAInvokeInstruction(iindex, params, exception, site){

                public Collection<TypeReference> getExceptionTypes() {
                    return CLRLanguage.invokeExceptions(this.getInvocationCode());
                }
            };
        }

        public SSAMonitorInstruction MonitorInstruction(int iindex, int ref, boolean isEnter) {
            throw new UnsupportedOperationException();
        }

        public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site) {
            return new SSANewInstruction(iindex, result, site){

                public Collection<TypeReference> getExceptionTypes() {
                    if (this.getNewSite().getDeclaredType().isArrayType()) {
                        return NewArrayExceptions;
                    }
                    return NewObjectExceptions;
                }
            };
        }

        public SSAPhiInstruction PhiInstruction(int iindex, int result, int[] params) throws IllegalArgumentException {
            return new SSAPhiInstruction(iindex, result, params);
        }

        public SSAPutInstruction PutInstruction(int iindex, int ref, int value, FieldReference field) {
            return new SSAPutInstruction(iindex, ref, value, field){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return FieldAccessExceptions;
                }
            };
        }

        public SSAPutInstruction PutInstruction(int iindex, int value, FieldReference field) {
            return new SSAPutInstruction(iindex, value, field){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return StaticFieldAccessExceptions;
                }
            };
        }

        public SSAReturnInstruction ReturnInstruction(int iindex) {
            return new SSAReturnInstruction(iindex);
        }

        public SSAReturnInstruction ReturnInstruction(int iindex, int result, boolean isPrimitive) {
            return new SSAReturnInstruction(iindex, result, isPrimitive);
        }

        public SSASwitchInstruction SwitchInstruction(int iindex, int val, int defaultLabel, int[] casesAndLabels) {
            return new SSASwitchInstruction(iindex, val, defaultLabel, casesAndLabels);
        }

        public SSAThrowInstruction ThrowInstruction(int iindex, int exception) {
            return new SSAThrowInstruction(iindex, exception){

                public Collection<TypeReference> getExceptionTypes() {
                    return NullReferenceExceptions;
                }
            };
        }

        public SSAUnaryOpInstruction UnaryOpInstruction(int iindex, IUnaryOpInstruction.IOperator operator, int result, int val) {
            return new SSAUnaryOpInstruction(iindex, operator, result, val);
        }

        public SSALoadMetadataInstruction LoadMetadataInstruction(int iindex, int lval, TypeReference entityType, Object token) {
            return new SSALoadMetadataInstruction(iindex, lval, entityType, token){

                public Collection<TypeReference> getExceptionTypes() {
                    return TypeLoadExceptions;
                }
            };
        }

        public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site, int[] params) {
            return new SSANewInstruction(iindex, result, site, params){

                public Collection<TypeReference> getExceptionTypes() {
                    return NewArrayExceptions;
                }
            };
        }

        public SSAPiInstruction PiInstruction(int iindex, int result, int val, int piBlock, int successorBlock, SSAInstruction cause) {
            return new SSAPiInstruction(iindex, result, val, piBlock, successorBlock, cause);
        }

        public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, TypeReference pointeeType) {
            return new SSAAddressOfInstruction(iindex, lval, local, pointeeType);
        }

        public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, int indexVal, TypeReference pointeeType) {
            return new SSAAddressOfInstruction(iindex, lval, local, indexVal, pointeeType){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return ArrayObjectStoreAndElementAddressExceptions;
                }
            };
        }

        public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, FieldReference field, TypeReference pointeeType) {
            return new SSAAddressOfInstruction(iindex, lval, local, field, pointeeType){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return FieldAccessExceptions;
                }
            };
        }

        public SSALoadIndirectInstruction LoadIndirectInstruction(int iindex, int lval, TypeReference t, int addressVal) {
            return new SSALoadIndirectInstruction(iindex, lval, t, addressVal){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return NullReferenceExceptions;
                }
            };
        }

        public SSAStoreIndirectInstruction StoreIndirectInstruction(int iindex, int addressVal, int rval, TypeReference pointeeType) {
            return new SSAStoreIndirectInstruction(iindex, addressVal, rval, pointeeType){

                public boolean isPEI() {
                    return true;
                }

                public Collection<TypeReference> getExceptionTypes() {
                    return NullReferenceExceptions;
                }
            };
        }
    };

    private CLRLanguage() {
        CLRPrimitiveType.init();
    }

    public TypeReference[] getArrayInterfaces() {
        return new TypeReference[0];
    }

    public Collection<TypeReference> getExceptionTypes(ClassLoaderReference loader, IInstruction pei, IClassHierarchy cha) {
        if (pei instanceof IInvokeInstruction) {
            return Collections.singletonList(CLRTypeReference.SystemException);
        }
        return this.getImplicitExceptionTypes(pei);
    }

    private static Collection<TypeReference> arrayStoreExceptions(TypeReference elementType) {
        if (elementType.isPrimitiveType()) {
            return ArrayAccessExceptions;
        }
        return ArrayObjectStoreAndElementAddressExceptions;
    }

    private static Collection<TypeReference> invokeExceptions(IInvokeInstruction.IDispatch code) {
        if (code == IInvokeInstruction.Dispatch.SPECIAL || code == IInvokeInstruction.Dispatch.STATIC) {
            return CallExceptions;
        }
        if (code == IInvokeInstruction.Dispatch.VIRTUAL || code == IInvokeInstruction.Dispatch.INTERFACE) {
            return CallvirtExceptions;
        }
        if (code == CILInvokeInstruction.Dispatch.CALLI) {
            return CalliExceptions;
        }
        assert (false);
        return null;
    }

    public Collection<TypeReference> getImplicitExceptionTypes(final IInstruction pei) {
        return (new IInstruction.Visitor(){
            private Collection<TypeReference> result = Collections.emptySet();

            private Collection<TypeReference> doit() {
                pei.visit((IInstruction.Visitor)this);
                assert (!this.result.isEmpty());
                return this.result;
            }

            public void visitArrayLength(ArrayLengthInstruction instruction) {
                this.result = NullReferenceExceptions;
            }

            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                this.result = ArrayAccessExceptions;
            }

            public void visitArrayStore(IArrayStoreInstruction instruction) {
                this.result = CLRLanguage.arrayStoreExceptions(((CILArrayStoreInstruction)instruction).getElementType());
            }

            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                CILBinaryOpInstruction inst = (CILBinaryOpInstruction)instruction;
                if (inst.isOverflow()) {
                    this.result = OverflowExceptions;
                }
                if ((inst.getOperator() == IBinaryOpInstruction.Operator.DIV || inst.getOperator() == IBinaryOpInstruction.Operator.REM) && inst.getRuntimeType() != Translator.RuntimeType.F) {
                    this.result = inst.isUnsigned() ? DivideByZeroExceptions : IntegralDivideExceptions;
                }
            }

            public void visitCheckCast(ITypeTestInstruction instruction) {
                this.result = CastclassExceptions;
            }

            public void visitComparison(IComparisonInstruction instruction) {
                assert (false);
            }

            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                assert (false);
            }

            public void visitConstant(ConstantInstruction instruction) {
                assert (false);
            }

            public void visitConversion(IConversionInstruction instruction) {
                if (instruction.isPEI()) {
                    this.result = OverflowExceptions;
                } else assert (false);
            }

            public void visitDup(DupInstruction instruction) {
                assert (false);
            }

            public void visitGet(IGetInstruction instruction) {
                this.result = instruction.isStatic() ? StaticFieldAccessExceptions : FieldAccessExceptions;
            }

            public void visitGoto(GotoInstruction instruction) {
                assert (false);
            }

            public void visitInstanceof(IInstanceofInstruction instruction) {
                this.result = TypeLoadExceptions;
            }

            public void visitInvoke(IInvokeInstruction instruction) {
                this.result = CLRLanguage.invokeExceptions(instruction.getInvocationCode());
            }

            public void visitLoadIndirect(ILoadIndirectInstruction instruction) {
                this.result = NullReferenceExceptions;
            }

            public void visitLocalLoad(ILoadInstruction instruction) {
                assert (false);
            }

            public void visitLocalStore(IStoreInstruction instruction) {
                assert (false);
            }

            public void visitMonitor(MonitorInstruction instruction) {
                assert (false);
            }

            public void visitNew(NewInstruction instruction) {
                this.result = instruction.getArrayBoundsCount() == 0 ? NewObjectExceptions : NewArrayExceptions;
            }

            public void visitPop(PopInstruction instruction) {
                assert (false);
            }

            public void visitPut(IPutInstruction instruction) {
                this.result = instruction.isStatic() ? StaticFieldAccessExceptions : FieldAccessExceptions;
            }

            public void visitReturn(ReturnInstruction instruction) {
                assert (false);
            }

            public void visitShift(IShiftInstruction instruction) {
                assert (false);
            }

            public void visitStoreIndirect(IStoreIndirectInstruction instruction) {
                this.result = NullReferenceExceptions;
            }

            public void visitSwap(SwapInstruction instruction) {
                assert (false);
            }

            public void visitSwitch(SwitchInstruction instruction) {
                assert (false);
            }

            public void visitThrow(ThrowInstruction instruction) {
                this.result = NullReferenceExceptions;
            }

            public void visitUnaryOp(IUnaryOpInstruction instruction) {
                IUnaryOpInstruction.IOperator op = instruction.getOperator();
                if (op == CILUnaryOpInstruction.Operator.BOX || op == CILUnaryOpInstruction.Operator.CPOBJ) {
                    this.result = ObjectOpExceptions;
                } else if (op == CILUnaryOpInstruction.Operator.CK_FINITE) {
                    this.result = ArithmeticExceptions;
                } else if (op == CILUnaryOpInstruction.Operator.UNBOX) {
                    this.result = UnboxExceptions;
                } else assert (false);
            }
        }).doit();
    }

    public SSAInstructionFactory instructionFactory() {
        return cilInstructionFactory;
    }

    public Atom getName() {
        return Constants.langName;
    }

    public TypeReference getRootType() {
        return CLRTypeReference.SystemObject;
    }

    public TypeReference getThrowableType() {
        return CLRTypeReference.SystemException;
    }

    public Collection<TypeReference> inferInvokeExceptions(MethodReference target, IClassHierarchy cha) throws InvalidClassFileException {
        return Collections.singletonList(CLRTypeReference.SystemException);
    }

    public TypeName lookupPrimitiveType(String name) {
        if (name.equals("void")) {
            return TypeReference.Void.getName();
        }
        assert (CLRTypeReference.getPrimitive(name) != null) : name;
        return CLRTypeReference.getPrimitive(name).getName();
    }

    public TypeReference getConstantType(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return CLRTypeReference.Int64;
        }
        if (o instanceof Double) {
            return CLRTypeReference.Float64;
        }
        if (o instanceof Float) {
            return CLRTypeReference.Float32;
        }
        if (o instanceof Number) {
            return CLRTypeReference.Int32;
        }
        if (o instanceof Boolean) {
            return CLRTypeReference.Boolean;
        }
        if (o instanceof String) {
            return CLRTypeReference.SystemString;
        }
        if (o instanceof TypeReference) {
            return CLRTypeReference.SystemType;
        }
        if (o instanceof MethodReference) {
            return CLRTypeReference.SystemReflectionMethodBase;
        }
        if (o instanceof FieldReference) {
            return CLRTypeReference.SystemReflectionFieldInfo;
        }
        assert (false);
        return null;
    }

    public Object getMetadataToken(Object value) {
        return value;
    }

    public boolean isNullType(TypeReference type) {
        return type == null || type == TypeReference.Void;
    }

    public boolean isDoubleType(TypeReference type) {
        return type == CLRTypeReference.Float64;
    }

    public boolean isFloatType(TypeReference type) {
        return type == CLRTypeReference.Float32;
    }

    public boolean isIntType(TypeReference type) {
        return type == CLRTypeReference.Int32;
    }

    public boolean isLongType(TypeReference type) {
        return type == CLRTypeReference.Int64;
    }

    public boolean isVoidType(TypeReference type) {
        return type == CLRTypeReference.Void;
    }

    public boolean isMetadataType(TypeReference type) {
        return type == CLRTypeReference.SystemType || type == CLRTypeReference.SystemReflectionFieldInfo || type == CLRTypeReference.SystemReflectionMethodBase;
    }

    public boolean isStringType(TypeReference type) {
        return type == CLRTypeReference.SystemString;
    }

    public boolean isBooleanType(TypeReference type) {
        return type == CLRTypeReference.Boolean;
    }

    public boolean isCharType(TypeReference type) {
        return type == CLRTypeReference.Char;
    }

    public boolean isObjectType(TypeReference type) {
        return type == CLRTypeReference.SystemObject;
    }

    public TypeReference getPointerType(TypeReference pointee) throws UnsupportedOperationException {
        return CLRTypeReference.IntPtr;
    }

    public TypeReference getMetadataType() {
        return CLRTypeReference.SystemType;
    }

    public TypeReference getStringType() {
        return CLRTypeReference.SystemString;
    }

    public PrimitiveType getPrimitive(TypeReference reference) {
        if (reference.getClassLoader() != CLRTypeReference.systemLoader) {
            reference = TypeReference.findOrCreate((ClassLoaderReference)CLRTypeReference.systemLoader, (TypeName)reference.getName());
        }
        return CLRPrimitiveType.getPrimitive((TypeReference)reference);
    }
}

