/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.php;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.php.IPHPConstants;
import com.ibm.appscan.internal.discovery.php.PHPStrategy;
import com.ibm.appscan.internal.discovery.php.SymphonyXmlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class PHPCollector
extends BaseCustomCollector
implements IPHPConstants {
    private static final String PHP_TAG = "<?";
    private List<String> phpExtensions = Arrays.asList("php", "ctp", "phtml", "inc", "module", "yaml");
    private static final String SCRIPT_TAG = "<php";
    private static final String PHP_TAG1 = "php:";
    private static boolean phpFileExists = false;

    public PHPCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "PhpCollector";
    }

    protected String getFileExtensionSetName() {
        return "php";
    }

    protected boolean acceptFile(File file) {
        String extension = FileUtil.getFileExtension((File)file);
        if (extension.startsWith("php")) {
            phpFileExists = true;
        }
        if (extension.equalsIgnoreCase("xml")) {
            return this.isValidSymphonyXml(file);
        }
        if (extension.equalsIgnoreCase("yaml")) {
            return phpFileExists;
        }
        return file.getName().equalsIgnoreCase("php.ini") || file.getName().equalsIgnoreCase("httpd.conf") || file.getName().toLowerCase().endsWith(".user.ini") || super.acceptFile(file) && this.containsPhp(file);
    }

    private boolean isValidSymphonyXml(File file) {
        SymphonyXmlReader reader = new SymphonyXmlReader(file);
        try {
            reader.read();
            return reader.isSymphony();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    private boolean containsPhp(File file) {
        String extension = FileUtil.getFileExtension((File)file);
        boolean containsPHP = true;
        if (!this.phpExtensions.contains(extension.toLowerCase()) && (extension.equalsIgnoreCase("html") || extension.equalsIgnoreCase("yml"))) {
            try {
                if (!(IOUtil.readFileIntoString((File)file).contains(PHP_TAG) && IOUtil.readFileIntoString((File)file).contains(SCRIPT_TAG) && IOUtil.readFileIntoString((File)file).contains(PHP_TAG1))) {
                    containsPHP = false;
                }
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
        return containsPHP;
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new PHPStrategy(root, this.getScanFiles());
    }
}

