/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.cloud.service.data;

import com.hcl.appscan.cloud.service.data.ArrayOfKeyValueOfstringstring;
import com.hcl.appscan.cloud.service.data.ScanData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SastScanData
extends ScanData {
    protected XMLGregorianCalendar createdAt;
    protected String irFileName;

    public SastScanData() {
    }

    public SastScanData(JSONObject json) throws JSONException, DatatypeConfigurationException {
        this.createdAt = this.getDate(json.getString("createdAt"));
        this.irFileName = json.getString("appFileName");
        this.isInteractiveMode = json.getBoolean("isInteractiveMode");
        this.isPSS = json.getBoolean("isPSS");
        this.locale = json.getString("locale");
        this.scanName = json.getString("scanName");
        this.trial = json.getBoolean("trial");
        this.reportParameters = new ArrayOfKeyValueOfstringstring();
        JSONObject reportParams = json.getJSONObject("reportParameters");
        Iterator keys = reportParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            ArrayOfKeyValueOfstringstring.KeyValueOfstringstring keyValue = new ArrayOfKeyValueOfstringstring.KeyValueOfstringstring();
            keyValue.setKey(key);
            keyValue.setValue(reportParams.getString(key));
            this.reportParameters.getKeyValueOfstringstring().add(keyValue);
        }
    }

    public XMLGregorianCalendar getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(XMLGregorianCalendar value) {
        this.createdAt = value;
    }

    public String getIRFileName() {
        return this.irFileName;
    }

    public void setIRFileName(String value) {
        this.irFileName = value;
    }

    private XMLGregorianCalendar getDate(String date) throws DatatypeConfigurationException {
        if (!date.endsWith("Z")) {
            date = date + "Z";
        }
        TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(date);
        Instant i = Instant.from(ta);
        Date d = Date.from(i);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
    }
}

