/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.cloud.service.data;

import com.hcl.appscan.cloud.service.ISastAgentServices1;
import com.hcl.appscan.cloud.service.Messages;
import com.hcl.appscan.cloud.service.data.SastEngineExitCode;
import com.hcl.appscan.cloud.service.data.SastScanData;
import com.hcl.appscan.cloud.service.error.AgentException;
import java.io.File;
import java.io.IOException;

public class SastScanDataWrapper {
    private SastScanData m_data;
    private File m_file;

    public SastScanDataWrapper(SastScanData data, File file) {
        this.m_data = data;
        this.m_file = file;
    }

    public SastScanDataWrapper(String jobID, ISastAgentServices1 service, File workingDir) throws IOException, AgentException {
        this.m_data = service.getSastScanData(jobID);
        this.m_file = new File(workingDir, this.m_data.getIRFileName());
        workingDir.mkdirs();
        this.writeFile(jobID, service);
    }

    public SastScanDataWrapper(String jobID, ISastAgentServices1 service, String irx) throws IOException, AgentException {
        this.m_data = service.getSastScanData(jobID);
        this.m_file = new File(irx);
    }

    private void writeFile(String jobID, ISastAgentServices1 service) throws IOException, AgentException {
        service.downloadApplicationFile(jobID, this.m_file);
        if (!this.m_file.isFile()) {
            throw new AgentException(Messages.getMessage("err.unpack", new Object[0]), SastEngineExitCode.UNPACK_ERROR);
        }
    }

    public SastScanData getData() {
        return this.m_data;
    }

    public File getFile() {
        return this.m_file;
    }
}

