/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IGrammarVisitor;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SingletonGrammar
extends SimpleGrammar
implements IContextFreeGrammar {
    private IVariable start;
    private final IValueSymbol[] val;
    private final IProductionRule rule;

    @Override
    public Object clone() {
        return super.clone();
    }

    public SingletonGrammar(IVariable start, IValueSymbol val) {
        this.start = (IVariable)start.clone();
        this.val = new IValueSymbol[]{(IValueSymbol)val.clone()};
        this.rule = new ProductionRule(start, (ISymbol)val);
    }

    public SingletonGrammar(IVariable start, IValueSymbol[] val) {
        this.start = (IVariable)start.clone();
        this.val = new IValueSymbol[val.length];
        System.arraycopy(val, 0, this.val, 0, val.length);
        this.rule = new ProductionRule(start, val);
    }

    public SingletonGrammar(IVariable start, List<? extends IValueSymbol> val) {
        this.start = (IVariable)start.clone();
        this.val = new IValueSymbol[val.size()];
        val.toArray(this.val);
        this.rule = new ProductionRule(start, val);
    }

    @Override
    public Set<IVariable> getNonterminals() {
        return Collections.singleton(this.start);
    }

    @Override
    public Set<IProductionRule> getRules() {
        return Collections.singleton(this.rule);
    }

    @Override
    public Set<IProductionRule> getRules(IVariable v) {
        if (v.equals(this.start)) {
            return Collections.singleton(this.rule);
        }
        return new HashSet<IProductionRule>();
    }

    @Override
    public IVariable getStartSymbol() {
        return this.start;
    }

    @Override
    public IGrammar copy(IGrammarCopier copier) {
        IValueSymbol[] s = new IValueSymbol[this.val.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (IValueSymbol)this.val[i].copy(copier);
        }
        return new SingletonGrammar((IVariable)this.start.copy(copier), s);
    }

    @Override
    public SimpleGrammar toSimple() {
        return new SimpleGrammar(this.start, new IProductionRule[]{this.rule});
    }

    @Override
    public void addRule(IProductionRule rule) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addRules(Collection<? extends IProductionRule> rules) {
    }

    @Override
    public void addRules(Iterator<? extends IProductionRule> rules) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void setStartSymbol(IVariable symbol) {
        this.start = symbol;
    }

    @Override
    public void traverse(IGrammarVisitor visitor) {
        visitor.onVisit(this);
        this.traverseSymbols(visitor);
        this.traverseRules(visitor);
    }

    @Override
    public void traverseRules(IRuleVisitor visitor) {
        this.rule.traverse(visitor);
    }

    @Override
    public void traverseSymbols(ISymbolVisitor visitor) {
        this.start.traverse(visitor);
        for (IValueSymbol v : this.val) {
            v.traverse(visitor);
        }
    }

    public IValueSymbol[] getTheValue() {
        return this.val;
    }
}

