/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IAutomatonVisitor;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateTransitionSystem;
import com.ibm.wala.automaton.string.IStateVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionVisitor;
import com.ibm.wala.automaton.string.TransitionSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StateTransitionSystem
implements IStateTransitionSystem {
    private IState initialState = null;
    protected TransitionSet transitions = new TransitionSet();

    public StateTransitionSystem(IState initialState, Collection<? extends ITransition> transitions) {
        this();
        this.setInitialState(initialState);
        this.transitions.addAll(transitions);
    }

    public StateTransitionSystem(IState initialState, ITransition[] transitions) {
        this(initialState, AUtil.set(transitions));
    }

    public StateTransitionSystem(IStateTransitionSystem automaton) {
        this(automaton.getInitialState(), automaton.getTransitions());
    }

    public StateTransitionSystem() {
    }

    @Override
    public IState getInitialState() {
        return this.initialState;
    }

    @Override
    public void setInitialState(IState state) {
        this.initialState = state;
    }

    @Override
    public Set<ITransition> getTransitions() {
        return this.transitions;
    }

    @Override
    public Set<ITransition> getTransitions(IState preState) {
        return this.transitions.getSet(preState);
    }

    @Override
    public Set<ITransition> getPredTransitions(IState postState) {
        HashSet<ITransition> l = new HashSet<ITransition>();
        for (ITransition transition : this.getTransitions()) {
            if (!transition.getPostState().equals(postState)) continue;
            l.add(transition);
        }
        return l;
    }

    @Override
    public Set<ITransition> getTransitions(IState preState, ISymbol symbol) {
        HashSet<ITransition> l = new HashSet<ITransition>(this.getTransitions(preState));
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ITransition transition = (ITransition)i.next();
            if (transition.getInputSymbol().equals(symbol)) continue;
            i.remove();
        }
        return l;
    }

    @Override
    public Set<ITransition> getAcceptTransitions(IState preState, ISymbol symbol) {
        HashSet<ITransition> l = new HashSet<ITransition>();
        for (ITransition transition : this.getTransitions(preState)) {
            if (!transition.accept(symbol, IMatchContext.DummyContext)) continue;
            l.add(transition);
        }
        return l;
    }

    public Set<ITransition> getEpsilonTransitions(IState preState) {
        HashSet<ITransition> l = new HashSet<ITransition>(this.getTransitions(preState));
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ITransition transition = (ITransition)i.next();
            if (transition.isEpsilonTransition()) continue;
            i.remove();
        }
        return l;
    }

    @Override
    public Set<IState> getStates() {
        HashSet<IState> states = new HashSet<IState>();
        if (this.initialState != null) {
            states.add(this.initialState);
        }
        for (ITransition transition : this.getTransitions()) {
            states.add(transition.getPreState());
            states.add(transition.getPostState());
        }
        return states;
    }

    @Override
    public void traverseTransitions(ITransitionVisitor visitor) {
        for (ITransition transition : this.getTransitions()) {
            visitor.onVisit(transition);
        }
    }

    @Override
    public void traverseStates(final IStateVisitor visitor) {
        visitor.onVisit(this.getInitialState());
        this.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                visitor.onVisit(transition.getPreState());
                visitor.onVisit(transition.getPostState());
            }
        });
    }

    @Override
    public void traverse(IAutomatonVisitor visitor) {
        this.traverseStates(visitor);
        this.traverseTransitions(visitor);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        StateTransitionSystem sts = (StateTransitionSystem)obj;
        return this.initialState.equals(sts.initialState) && this.transitions.equals(sts.transitions);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IStateTransitionSystem copy(ISTSCopier copier) {
        IStateTransitionSystem ists = copier.copy(this);
        if (ists instanceof StateTransitionSystem) {
            StateTransitionSystem sts = (StateTransitionSystem)ists;
            sts.initialState = copier.copy(sts.initialState);
            sts.transitions = (TransitionSet)copier.copyTransitions(sts.transitions, new TransitionSet());
        }
        return ists;
    }

    public String toString() {
        StringBuffer transitions = new StringBuffer();
        Iterator<ITransition> i = AUtil.sort(this.getTransitions()).iterator();
        while (i.hasNext()) {
            ITransition t = i.next();
            transitions.append(t.toString());
            if (!i.hasNext()) continue;
            transitions.append(", ");
        }
        return "{init:" + this.getInitialState() + ", transitions:{" + transitions + "}}";
    }
}

