/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.util.collections.Pair;
import java.util.Comparator;

public class LexicographicComparatorForPair<T extends Comparable<T>, U extends Comparable<U>>
implements Comparator<Pair<? extends T, ? extends U>> {
    private final Comparator<? super T> compFst;
    private final Comparator<? super U> compSnd;

    public LexicographicComparatorForPair() {
        this.compFst = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
        this.compSnd = new Comparator<U>(){

            @Override
            public int compare(U o1, U o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public LexicographicComparatorForPair(Comparator<? super T> c1, Comparator<? super U> c2) {
        this.compFst = c1;
        this.compSnd = c2;
    }

    @Override
    public int compare(Pair<? extends T, ? extends U> o1, Pair<? extends T, ? extends U> o2) {
        int x = this.compFst.compare(o1.fst, o2.fst);
        if (x == 0) {
            return this.compSnd.compare(o1.snd, o2.snd);
        }
        return x;
    }
}

