/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.intgraph.impl;

import com.ibm.wala.automaton.util.collections.TinyOrderdIntSet;
import com.ibm.wala.automaton.util.intgraph.IntGraph;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Arrays;

public class TinyIntGraph
extends TinyOrderdIntSet
implements IntGraph {
    private final int nodeCount;
    private final MutableIntSet[] predCache;
    private final MutableIntSet[] succCache;
    private boolean[] edges;

    public TinyIntGraph(int[] nodes) {
        super(nodes);
        int len;
        this.nodeCount = len = nodes.length;
        this.edges = new boolean[len * len];
        Arrays.fill(this.edges, false);
        this.predCache = new BitVectorIntSet[len];
        this.succCache = new BitVectorIntSet[len];
    }

    public TinyIntGraph(int[] nodes, boolean[] edges) {
        super(nodes);
        int len;
        this.nodeCount = len = nodes.length;
        edges = new boolean[len * len];
        System.arraycopy(edges, 0, this.edges, 0, len * len);
        this.predCache = new BitVectorIntSet[len];
        this.succCache = new BitVectorIntSet[len];
    }

    @Override
    public void removeNodeAndEdges(int N) {
        Assertions.UNREACHABLE((String)"TinyIntGraph is immutable for nodes.");
    }

    @Override
    public void addNode(int n) {
        Assertions.UNREACHABLE((String)"TinyIntGraph is immutable for nodes.");
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeCount;
    }

    @Override
    public void removeNode(int n) {
        Assertions.UNREACHABLE((String)"TinyIntGraph is immutable for nodes.");
    }

    @Override
    public void addEdge(int src, int dst) {
        this.edges[src * this.nodeCount + dst] = true;
        MutableIntSet s = this.predCache[dst];
        if (s != null) {
            s.add(src);
        }
        if ((s = this.succCache[src]) != null) {
            s.add(dst);
        }
    }

    private int initPredNodes(int N) {
        this.predCache[N] = new BitVectorIntSet();
        BitVectorIntSet s = this.predCache[N];
        int count = 0;
        for (int src = 0; src < this.nodeCount * this.nodeCount; src += this.nodeCount) {
            if (!this.edges[src + N]) continue;
            s.add(src);
            ++count;
        }
        return count;
    }

    @Override
    public int getPredNodeCount(int N) {
        MutableIntSet s = this.predCache[N];
        if (s != null) {
            return s.size();
        }
        return this.initPredNodes(N);
    }

    @Override
    public IntIterator getPredNodes(int N) {
        MutableIntSet s = this.predCache[N];
        if (s != null) {
            return s.intIterator();
        }
        this.initPredNodes(N);
        return this.predCache[N].intIterator();
    }

    private int initSuccNodes(int N) {
        this.succCache[N] = new BitVectorIntSet();
        BitVectorIntSet s = this.succCache[N];
        int count = 0;
        int src = N * this.nodeCount;
        for (int dest = 0; dest < this.nodeCount; ++dest) {
            if (!this.edges[src + dest]) continue;
            s.add(dest);
            ++count;
        }
        return count;
    }

    @Override
    public int getSuccNodeCount(int N) {
        MutableIntSet s = this.succCache[N];
        if (s != null) {
            return s.size();
        }
        return this.initSuccNodes(N);
    }

    @Override
    public IntIterator getSuccNodes(int N) {
        MutableIntSet s = this.succCache[N];
        if (s != null) {
            return s.intIterator();
        }
        this.initSuccNodes(N);
        return this.succCache[N].intIterator();
    }

    @Override
    public boolean hasEdge(int src, int dst) {
        return this.edges[src * this.nodeCount + dst];
    }

    @Override
    public void removeAllIncidentEdges(int node) {
        this.removeIncomingEdges(node);
        this.removeOutgoingEdges(node);
    }

    @Override
    public void removeEdge(int src, int dst) {
        this.edges[src * this.nodeCount + dst] = false;
        MutableIntSet s = this.predCache[dst];
        if (s != null) {
            s.remove(src);
        }
        if ((s = this.succCache[src]) != null) {
            s.remove(dst);
        }
    }

    @Override
    public void removeIncomingEdges(int node) {
        IntIterator pred = this.getPredNodes(node);
        BitVectorIntSet newPredCache = new BitVectorIntSet((IntSet)this.predCache[node]);
        while (pred.hasNext()) {
            int src = pred.next() * this.nodeCount;
            this.edges[src + node] = false;
            newPredCache.remove(src);
        }
        this.predCache[node] = newPredCache;
    }

    @Override
    public void removeOutgoingEdges(int node) {
        IntIterator succ = this.getSuccNodes(node);
        BitVectorIntSet newSuccCache = new BitVectorIntSet((IntSet)this.succCache[node]);
        int src = node * this.nodeCount;
        while (succ.hasNext()) {
            this.edges[src + succ.next()] = false;
            newSuccCache.remove(src);
        }
        this.succCache[node] = newSuccCache;
    }

    @Override
    public boolean containsNode(int N) {
        return super.contains(N);
    }

    @Override
    public IntIterator iterateNodes() {
        return super.intIterator();
    }
}

