/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class AzureBlobStorageCache {
    private String m_cacheStorageUri;
    private HttpClient m_httpClient;

    public AzureBlobStorageCache(String cacheStorageUri) {
        this.m_cacheStorageUri = cacheStorageUri.replace("^", "");
        this.m_httpClient = new HttpClient();
    }

    protected boolean insertCacheEntry(String key, File source) throws IOException {
        byte[] data = Files.readAllBytes(Paths.get(source.getAbsolutePath(), new String[0]));
        HttpResponse response = this.m_httpClient.put(this.getUrlForCacheEntry(key), this.getHeadersForUpload(data), data);
        if (!response.isSuccess()) {
            throw new IOException(Messages.getMessage("error.insert.cache.entry", key, source.getName(), this.getUrlForCacheEntry(key), this.getError(response)));
        }
        return true;
    }

    protected InputStream getCacheEntry(String key) throws IOException {
        HttpResponse response = this.m_httpClient.get(this.getUrlForCacheEntry(key), new HashMap(), null);
        if (response.isSuccess() && response.hasResponseBody()) {
            this.touchCacheFile(key);
            return new ByteArrayInputStream(response.getRawContent());
        }
        if (SystemUtil.isDebug()) {
            CommonCore.getLogManager().log(new Message(1, Messages.getMessage("error.get.cache.entry", key, this.getUrlForCacheEntry(key), this.getError(response))));
        }
        return null;
    }

    private void touchCacheFile(String key) throws IOException {
        byte[] data = new byte[]{};
        String url = this.getUrlForCacheEntry(key) + "&comp=properties";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-blob-content-type", "text/plain;charset=UTF-8");
        headers.put("Content-Length", "0");
        this.m_httpClient.put(url, headers, data);
    }

    private Map<String, String> getHeadersForUpload(byte[] data) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-blob-type", "BlockBlob");
        headers.put("Content-Length", String.valueOf(data.length));
        headers.put("Content-Type", "application/octet-stream");
        return headers;
    }

    private String getUrlForCacheEntry(String key) {
        return this.m_cacheStorageUri.replace("{CacheKey}", key);
    }

    private String getError(HttpResponse response) {
        return response.hasResponseBody() ? response.getResponseBodyAsString() : "Response code " + response.getResponseCode();
    }
}

