/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.IrxMinorCache;
import com.hcl.irx.slice.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FileIrxMinorCache
extends IrxMinorCache {
    private File m_cache_path;
    private File m_previous_bucket_cache;

    protected synchronized File getIrxMinorCacheHome() {
        if (this.m_cache_path == null) {
            String cacheRootDirectory = null;
            if (SystemUtil.isPropertySet((String)"IRX_MINOR_CACHE_HOME")) {
                cacheRootDirectory = System.getProperty("IRX_MINOR_CACHE_HOME");
                File currentFile = new File(cacheRootDirectory);
                if (!currentFile.exists()) {
                    cacheRootDirectory = System.getProperty("user.home");
                }
            } else {
                cacheRootDirectory = System.getProperty("user.home");
            }
            this.m_cache_path = Paths.get(cacheRootDirectory, ".appscan", "irx_cache").toFile();
            if (!this.m_cache_path.mkdirs() && !this.m_cache_path.exists()) {
                String ms = Messages.getMessage("error.creating.dir", this.m_cache_path.toString());
                System.err.println(ms);
                CommonCore.getLogManager().log(new Message(4, ms));
                System.exit(-1);
            }
        }
        return this.m_cache_path;
    }

    private synchronized File getPreviousBucketFile() {
        if (this.m_previous_bucket_cache == null) {
            this.m_previous_bucket_cache = new File(this.getIrxMinorCacheHome(), "buckets.json");
        }
        return this.m_previous_bucket_cache;
    }

    @Override
    protected void deleteAllFilesInCache() {
        Path cachePath = this.getIrxMinorCacheHome().toPath();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
            for (Path file : files) {
                File currentFile = file.toFile();
                currentFile.delete();
            }
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
    }

    @Override
    protected long getUsedSpaceInCache() {
        long irxCacheUsedSpace = 0L;
        Path cachePath = this.getIrxMinorCacheHome().toPath();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
            for (Path file : files) {
                File currentFile = file.toFile();
                irxCacheUsedSpace += currentFile.length();
            }
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        return irxCacheUsedSpace;
    }

    @Override
    protected long getMaxEntriesAllowed_() {
        return 30000L;
    }

    @Override
    protected boolean insertCacheEntry(String key, File source) {
        try {
            File file = new File(this.getIrxMinorCacheHome(), key);
            IOUtil.copy((File)source, (File)file);
            return true;
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
            return false;
        }
    }

    @Override
    protected long getCacheEntryCount() {
        if (this.getIrxMinorCacheHome().exists()) {
            return this.getIrxMinorCacheHome().listFiles().length;
        }
        return 0L;
    }

    @Override
    protected void reduceCacheEntry() {
        if (this.getIrxMinorCacheHome().exists()) {
            Path cachePath = this.getIrxMinorCacheHome().toPath();
            try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
                for (Path file : files) {
                    if (new Random().nextInt(100) % 2 != 0) continue;
                    file.toFile().delete();
                }
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
    }

    @Override
    protected InputStream getCacheEntry(String key) throws AppScanException {
        File entry = new File(this.getIrxMinorCacheHome(), key);
        if (entry.exists()) {
            try {
                entry.setLastModified(new Date().getTime());
                return new FileInputStream(entry);
            }
            catch (FileNotFoundException e) {
                throw new AppScanException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap<String, HashSet<String>> getPreviousBuckets(boolean locked_already) throws IOException, JSONException {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        if (this.getPreviousBucketFile().exists()) {
            BufferedInputStream bis;
            block8: {
                if (!locked_already) {
                    this.getLock();
                }
                bis = null;
                try {
                    bis = new BufferedInputStream(new FileInputStream(this.getPreviousBucketFile()));
                    JSONObject in = new JSONObject((InputStream)bis);
                    if (!in.containsKey((Object)"classes")) break block8;
                    JSONArray classes = in.getJSONArray("classes");
                    for (int i = 0; i < classes.length(); ++i) {
                        HashSet<String> peers_set = new HashSet<String>();
                        JSONObject clazz = classes.getJSONObject(i);
                        JSONArray peers = clazz.getJSONArray("peers");
                        for (int k = 0; k < peers.length(); ++k) {
                            peers_set.add(peers.getJSONObject(k).getString("class"));
                        }
                        ret.put(clazz.getString("class"), peers_set);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(bis);
                    if (!locked_already) {
                        this.releaseLock();
                    }
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)bis);
            if (!locked_already) {
                this.releaseLock();
            }
        }
        return ret;
    }

    private synchronized void getLock() throws IOException {
        File lock = new File(this.getIrxMinorCacheHome(), "bucket.lock");
        if (!lock.exists()) {
            lock.createNewFile();
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!lock.exists()) {
                lock.createNewFile();
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        lock.createNewFile();
    }

    private synchronized void releaseLock() {
        File lock = new File(this.getIrxMinorCacheHome(), "bucket.lock");
        lock.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updatePreviousBuckets(HashMap<String, HashSet<String>> data) throws JSONException, IOException {
        this.getLock();
        HashMap<String, HashSet<String>> previous = this.getPreviousBuckets(true);
        for (String key : data.keySet()) {
            if (!previous.containsKey(key)) {
                previous.put(key, new HashSet());
            }
            previous.get(key).addAll((Collection<String>)data.get(key));
        }
        try {
            ArrayList<String> keys = new ArrayList<String>(previous.keySet());
            Collections.sort(keys);
            JSONObject out = new JSONObject();
            for (String key : keys) {
                JSONObject parent = new JSONObject();
                parent.put("class", (Object)key);
                for (String peer : previous.get(key)) {
                    JSONObject child = new JSONObject();
                    child.put("class", (Object)peer);
                    parent.append("peers", (Object)child);
                }
                out.append("classes", (Object)parent);
            }
            IOUtil.write((String)out.toString(true), (File)this.getPreviousBucketFile());
        }
        finally {
            this.releaseLock();
        }
    }
}

