/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.nlp.model.Trace;

import com.hcl.appscan.ifa.nlp.model.Trace.BaseTraceModel;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.ifa.common.IfaException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.http.client.utils.URIBuilder;

public class RemoteTraceModel
extends BaseTraceModel {
    static final int BATCH_SIZE = 8;
    static final int PARALLEL_REQUESTS = 4;
    private static final int RETRY_LIMIT = 10;
    private int m_temp_int = 0;
    private final HashMap<String, String> m_HEADER = new HashMap();
    static final String INFER_PATH = "/v2/models/ifa-trace/infer";
    static final String HEALTH_PATH = "/v2/health/live";
    static final String INFO_PATH = "/v2/models/ifa-trace";
    static final String SERVICE_NAME = "ifa-trace-service";
    final String m_INFER_URL;
    final String m_HEALTH_URL;
    final String m_INFO_URL;
    static boolean DO_HEALTH_CHECK = true;

    public RemoteTraceModel() throws Exception {
        this("127.0.0.1", null);
    }

    public RemoteTraceModel(String namespace) throws Exception {
        this("ifa-trace-service." + namespace, null);
    }

    public RemoteTraceModel(String host, String path) throws Exception {
        this.m_HEADER.put("Content-Type", "application/json");
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(host);
        uriBuilder.setScheme("http");
        if (path == null) {
            path = "";
        }
        this.m_INFER_URL = new URL(uriBuilder.setPath(path + INFER_PATH).toString()).toString();
        this.m_HEALTH_URL = new URL(uriBuilder.setPath(path + HEALTH_PATH).toString()).toString();
        this.m_INFO_URL = new URL(uriBuilder.setPath(path + INFO_PATH).toString()).toString();
        if (DO_HEALTH_CHECK && new HttpClient().get(this.m_HEALTH_URL, this.m_HEADER, null).getResponseCode() != 200) {
            throw new IfaException("Failed to get response from server");
        }
    }

    public static void main(String[] args) throws Exception {
        try (RemoteTraceModel model = new RemoteTraceModel();){
            model._main(args);
        }
    }

    @Override
    public void close() throws Exception {
    }

    private Map<Finding, Float> processBatch(HttpClient client, Collection<Finding> batch) throws Exception {
        HttpResponse response;
        HashMap<Finding, Float> values = new HashMap<Finding, Float>(batch.size());
        List queries = batch.stream().map(f -> this.getFeatures((Finding)f).iterator().next()).collect(Collectors.toList());
        ArrayList<Integer> shape = new ArrayList<Integer>(2);
        shape.add(queries.size());
        shape.add(1);
        String body = new JSONObject().put("inputs", (Object[])new JSONObject[]{new JSONObject().put("name", (Object)"findings").put("shape", shape).put("datatype", (Object)"BYTES").put("parameters", (Map)new JSONObject().put("content_type", (Object)"str")).put("data", queries)}).toString();
        int tries = 0;
        while ((response = client.post(this.m_INFER_URL, this.m_HEADER, body.toCharArray())).getResponseCode() == 503 || tries++ < 10 && response.getResponseCode() != 200) {
        }
        if (response.getResponseCode() != 200) {
            throw new IfaException("Failed to get response from server");
        }
        JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
        JSONArray results = json.getJSONArray("outputs").getJSONObject(0).getJSONArray("data");
        Iterator<Finding> i = batch.iterator();
        for (Object o : results) {
            values.put(i.next(), Float.valueOf(((Double)o).floatValue()));
        }
        return values;
    }

    @Override
    public Map<Finding, Float> getPredictedValue(Collection<Finding> findings) throws Exception {
        this.m_temp_int = 0;
        HashMap<Finding, Float> values = new HashMap<Finding, Float>(findings.size());
        HttpClient client = new HttpClient();
        ExecutorService service = Executors.newFixedThreadPool(4);
        List futures = findings.stream().collect(Collectors.groupingBy(f -> this.m_temp_int++ / 8)).values().stream().map(batch -> service.submit(() -> this.processBatch(client, (Collection<Finding>)batch))).collect(Collectors.toList());
        futures.stream().map(future -> {
            try {
                return (Map)future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).forEach(v -> values.putAll((Map<Finding, Float>)v));
        service.shutdown();
        return values;
    }

    @Override
    public String getVersion() {
        String s;
        try {
            HttpClient client = new HttpClient();
            HttpResponse response = client.get(this.m_INFO_URL, this.m_HEADER, null);
            JSONObject o = (JSONObject)response.getResponseBodyAsJSON();
            s = o.getJSONArray("versions").getString(0);
        }
        catch (Exception e) {
            s = null;
        }
        return s != null ? s : "Unknown";
    }

    public static String getServiceName() {
        return SERVICE_NAME;
    }
}

