/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator.java;

import com.ibm.wala.automaton.parser.JavaRegexParser;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.translator.repository.Base64EncodeTemplate;
import com.ibm.wala.samso.translator.repository.ConcatTemplate;
import com.ibm.wala.samso.translator.repository.ConstEqualsConstraint;
import com.ibm.wala.samso.translator.repository.ConstIndexOfCharConstraint;
import com.ibm.wala.samso.translator.repository.ContainsConstraint;
import com.ibm.wala.samso.translator.repository.DefaultTemplate;
import com.ibm.wala.samso.translator.repository.IM2LConstraint;
import com.ibm.wala.samso.translator.repository.IndexIncrementTemplate;
import com.ibm.wala.samso.translator.repository.IndexOfConstraint;
import com.ibm.wala.samso.translator.repository.IndexOfTemplate;
import com.ibm.wala.samso.translator.repository.IntersectionTemplate;
import com.ibm.wala.samso.translator.repository.JavaMatcherMatchesTemplate;
import com.ibm.wala.samso.translator.repository.LastIndexOfTemplate;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.samso.translator.repository.NotContainsConstraint;
import com.ibm.wala.samso.translator.repository.NotTemplate;
import com.ibm.wala.samso.translator.repository.ReadLineTemplate;
import com.ibm.wala.samso.translator.repository.ReplaceByRegexTemplate;
import com.ibm.wala.samso.translator.repository.ReplaceCharTemplate;
import com.ibm.wala.samso.translator.repository.ReplaceStrTemplate;
import com.ibm.wala.samso.translator.repository.RetAnyPosTemplate;
import com.ibm.wala.samso.translator.repository.RetBinaryStringTemplate;
import com.ibm.wala.samso.translator.repository.RetEmptyTemplate;
import com.ibm.wala.samso.translator.repository.RetFixedStringTemplate;
import com.ibm.wala.samso.translator.repository.RetHexStringTemplate;
import com.ibm.wala.samso.translator.repository.RetNthParameterTemplate;
import com.ibm.wala.samso.translator.repository.RetOctalStringTemplate;
import com.ibm.wala.samso.translator.repository.StringEqualsConstraint;
import com.ibm.wala.samso.translator.repository.SubstringTemplate;
import com.ibm.wala.samso.translator.repository.ToLowerCaseTemplate;
import com.ibm.wala.samso.translator.repository.ToUpperCaseTemplate;
import com.ibm.wala.samso.translator.repository.Trim;
import com.ibm.wala.samso.translator.repository.URLEncodeTemplate;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.java.translator.RepositoryUtil;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.types.ClassLoaderReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaM2LTranslatorRepository
extends M2LTranslatorRepository {
    private static String[] defaultStringClasses = new String[]{"Ljava/lang/String", "Ljava/lang/StringBuffer", "Ljava/lang/StringBuilder", "Ljava/io/File", "Ljava/io/FileInputStream", "Ljava/io/FileOutputStream", "Ljava/lang/System", "Ljava/net/URL", "Ljava/net/URI", "Ljava/util/regex/Pattern", "Ljava/util/regex/Matcher"};
    private final Set<String> stringClasses = new HashSet<String>();
    private static Map<String, String> specialSignatures = new HashMap<String, String>();
    private static final IRegexParser regexParser;

    public JavaM2LTranslatorRepository(IExtendedFormulaFactory ffactory) {
        super(ffactory);
        this.initTranslators();
        this.initMapTranslators();
        this.initStringClasses();
    }

    protected void initTranslators() {
        DefaultTemplate ANY = new DefaultTemplate();
        RetEmptyTemplate EMPTY = new RetEmptyTemplate();
        ConcatTemplate booleanConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Boolean.toString()Ljava/lang/String;"));
        ConcatTemplate charConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Character.toString()Ljava/lang/String;"));
        ConcatTemplate doubleConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Double.toString()Ljava/lang/String;"));
        ConcatTemplate floatConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Float.toString()Ljava/lang/String;"));
        ConcatTemplate intConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Integer.toString()Ljava/lang/String;"));
        ConcatTemplate longConcat = new ConcatTemplate(0, new SignatureSymbol("java.lang.Long.toString()Ljava/lang/String;"));
        this.put("op(add)", (ITranslator)new IndexIncrementTemplate());
        this.put("java.lang.Object.toString()Ljava/lang/String;", (ITranslator)ANY);
        this.put("java.util.Arrays.toString([B)Ljava/lang/String;", (ITranslator)ANY);
        this.put("java.lang.String.<init>()V", (ITranslator)new RetEmptyTemplate());
        this.put("java.lang.String.<init>(Ljava/lang/String;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.String.<init>(Ljava/lang/String;,Ljava/lang/String;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.String.substring(II)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1, 2));
        this.put("java.lang.String.substring(I)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1));
        this.put("java.lang.String.toUpperCase()Ljava/lang/String;", (ITranslator)new ToUpperCaseTemplate(0));
        this.put("java.lang.String.toLowerCase()Ljava/lang/String;", (ITranslator)new ToLowerCaseTemplate(0));
        this.put("java.lang.String.concat(Ljava/lang/String;)Ljava/lang/String;", (ITranslator)new ConcatTemplate());
        this.put("java.lang.String.trim()Ljava/lang/String;", (ITranslator)new Trim());
        this.put("java.lang.String.charAt(I)C", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)".", (int)-1));
        this.put("java.lang.String.replace(CC)Ljava/lang/String;", (ITranslator)new ReplaceCharTemplate(0, 1, 2));
        this.put("java.lang.String.replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", (ITranslator)new ReplaceStrTemplate(0, 1, 2));
        this.put("java.lang.String.replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", (ITranslator)new ReplaceByRegexTemplate(0, 1, 2));
        this.put("java.lang.String.indexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfTemplate(0, 1));
        this.put("java.lang.String.indexOf(I)I", (ITranslator)new IndexOfTemplate(0, 1));
        this.put("java.lang.String.indexOf(II)I", (ITranslator)new IndexOfTemplate(0, 1, 2));
        this.put("java.lang.String.indexOf(Ljava/lang/String;I)I", (ITranslator)new IndexOfTemplate(0, 1, 2));
        this.put("#const.java.lang.String.indexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfTemplate(0, 1));
        this.put("#const.java.lang.String.indexOf(I)I", (ITranslator)new IndexOfTemplate(0, 1));
        this.put("#const.java.lang.String.indexOf(II)I", (ITranslator)new IndexOfTemplate(0, 1, 2));
        this.put("#const.java.lang.String.indexOf(Ljava/lang/String;I)I", (ITranslator)new IndexOfTemplate(0, 1, 2));
        this.put("java.lang.String.lastIndexOf(Ljava/lang/String;)I", (ITranslator)new LastIndexOfTemplate(0, 1));
        this.put("java.lang.String.lastIndexOf(I)I", (ITranslator)new LastIndexOfTemplate(0, 1));
        this.put("java.lang.String.lastIndexOf(II)I", (ITranslator)new RetAnyPosTemplate());
        this.put("java.lang.String.lastIndexOf(Ljava/lang/String;I)I", (ITranslator)new RetAnyPosTemplate());
        this.put("java.lang.String.toString()Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(0));
        this.put("java.lang.String.valueOf(Z)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"(true)|(false)", (int)-1));
        this.put("java.lang.String.valueOf(C)Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.String.valueOf(D)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"(-?[0-9]+\\.[0-9]+)|(Infinity)|(-Infinity)|(NaN)", (int)-1));
        this.put("java.lang.String.valueOf(F)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"(-?[0-9]+\\.[0-9]+)|(Infinity)|(-Infinity)|(NaN)", (int)-1));
        this.put("java.lang.String.valueOf(I)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.String.valueOf(J)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.String.valueOf(Ljava/lang/Object;)Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuffer.<init>()V", (ITranslator)EMPTY);
        this.put("java.lang.StringBuffer.<init>(I)V", (ITranslator)EMPTY);
        this.put("java.lang.StringBuffer.<init>(Ljava/lang/String;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuffer.<init>(Ljava/lang/StringBuffer;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuffer.<init>(Ljava/lang/CharSequence;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuffer.substring(II)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1, 2));
        this.put("java.lang.StringBuffer.substring(I)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1));
        this.put("java.lang.StringBuffer.toString()Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(0));
        this.put("java.lang.StringBuffer.append(Ljava/lang/String;)Ljava/lang/StringBuffer;", (ITranslator)new ConcatTemplate());
        this.put("java.lang.StringBuffer.append(Z)Ljava/lang/StringBuffer;", (ITranslator)booleanConcat);
        this.put("java.lang.StringBuffer.append(C)Ljava/lang/StringBuffer;", (ITranslator)charConcat);
        this.put("java.lang.StringBuffer.append(D)Ljava/lang/StringBuffer;", (ITranslator)doubleConcat);
        this.put("java.lang.StringBuffer.append(F)Ljava/lang/StringBuffer;", (ITranslator)floatConcat);
        this.put("java.lang.StringBuffer.append(I)Ljava/lang/StringBuffer;", (ITranslator)intConcat);
        this.put("java.lang.StringBuffer.append(J)Ljava/lang/StringBuffer;", (ITranslator)longConcat);
        this.put("java.lang.StringBuffer.append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;", (ITranslator)new ConcatTemplate());
        this.put("java.lang.StringBuilder.<init>()V", (ITranslator)EMPTY);
        this.put("java.lang.StringBuilder.<init>(Ljava/lang/String;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuilder.<init>(Ljava/lang/StringBuilder;)V", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.StringBuilder.substring(II)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1, 2));
        this.put("java.lang.StringBuilder.substring(I)Ljava/lang/String;", (ITranslator)new SubstringTemplate(0, 1));
        this.put("java.lang.StringBuilder.toString()Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(0));
        this.put("java.lang.StringBuilder.append(Ljava/lang/String;)Ljava/lang/StringBuilder;", (ITranslator)new ConcatTemplate());
        this.put("java.lang.StringBuilder.append(Z)Ljava/lang/StringBuilder;", (ITranslator)booleanConcat);
        this.put("java.lang.StringBuilder.append(C)Ljava/lang/StringBuilder;", (ITranslator)charConcat);
        this.put("java.lang.StringBuilder.append(D)Ljava/lang/StringBuilder;", (ITranslator)doubleConcat);
        this.put("java.lang.StringBuilder.append(F)Ljava/lang/StringBuilder;", (ITranslator)floatConcat);
        this.put("java.lang.StringBuilder.append(I)Ljava/lang/StringBuilder;", (ITranslator)intConcat);
        this.put("java.lang.StringBuilder.append(J)Ljava/lang/StringBuilder;", (ITranslator)longConcat);
        this.put("java.lang.StringBuilder.append(Ljava/lang/StringBuilder;)Ljava/lang/StringBuilder;", (ITranslator)new ConcatTemplate());
        this.put("java.lang.Character.toString()Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(0));
        this.put("java.lang.Character.toString(C)Ljava/lang/String;", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.lang.Character.toLowerCase(C)C", (ITranslator)new ToLowerCaseTemplate(1));
        this.put("java.lang.Character.toUpperCase(C)C", (ITranslator)new ToUpperCaseTemplate(1));
        this.put("java.lang.Integer.toBinaryString(I)Ljava/lang/String;", (ITranslator)new RetBinaryStringTemplate());
        this.put("java.lang.Integer.toHexString(I)Ljava/lang/String;", (ITranslator)new RetHexStringTemplate());
        this.put("java.lang.Integer.toOctalString(I)Ljava/lang/String;", (ITranslator)new RetOctalStringTemplate());
        this.put("java.lang.Integer.toString()Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.Integer.toString(I)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.Long.toBinaryString(J)Ljava/lang/String;", (ITranslator)new RetBinaryStringTemplate());
        this.put("java.lang.Long.toHexString(J)Ljava/lang/String;", (ITranslator)new RetHexStringTemplate());
        this.put("java.lang.Long.toOctalString(J)Ljava/lang/String;", (ITranslator)new RetOctalStringTemplate());
        this.put("java.lang.Long.toString()Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.Long.toString(J)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.Short.toString()Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.lang.Short.toString(S)Ljava/lang/String;", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"-?[0-9]+", (int)-1));
        this.put("java.io.BufferedReader.readLine()Ljava/lang/String;", (ITranslator)new ReadLineTemplate());
        this.put("java.io.LineNumberReader.readLine()Ljava/lang/String;", (ITranslator)new ReadLineTemplate());
        this.put("java.net.URLEncoder.encode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", (ITranslator)new URLEncodeTemplate());
        this.put("java.net.URLDecoder.decode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", (ITranslator)ANY);
        this.put("sun.misc.BASE64Encoder.encode([B)Ljava/lang/String;", (ITranslator)new Base64EncodeTemplate());
        this.put("sun.misc.BASE64Encoder.encode(Ljava/nio/ByteBuffer;)Ljava/lang/String;", (ITranslator)new Base64EncodeTemplate());
        this.put("java.util.regex.Pattern.compile(Ljava/lang/String;)Ljava/util/regex/Pattern;", (ITranslator)new RetNthParameterTemplate(1));
        this.put("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/lang/util/regex/Matcher;", (ITranslator)new IntersectionTemplate());
        this.put("&java.lang.Character.isLetter(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[a-zA-Z]+", (int)0));
        this.put("!java.lang.Character.isLetter(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[^a-zA-Z]+", (int)0));
        this.put("&java.lang.Character.isDigit(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[0-9]+", (int)0));
        this.put("!java.lang.Character.isDigit(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[^0-9]+", (int)0));
        this.put("&java.lang.Character.isLetterOrDigit(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[0-9a-zA-Z]+", (int)0));
        this.put("!java.lang.Character.isLetterOrDigit(C)Z", (ITranslator)RetFixedStringTemplate.makeFromRegex((String)"[^0-9a-zA-Z]+", (int)0));
        this.put("&java.lang.Character.isWhitespace(C)Z", (ITranslator)RetFixedStringTemplate.makeFromPattern((IPattern)UnionPattern.make((IPattern)SymbolPattern.make((ISymbol)new RangeSymbol('\t', '\u000e')), (IPattern)SymbolPattern.make((ISymbol)new RangeSymbol('\u001c', '\u001f'))), (int)0));
        this.put("!java.lang.Character.isWhitespace(C)Z", (ITranslator)RetFixedStringTemplate.makeFromPattern((IPattern)ComplementPattern.make((IPattern)UnionPattern.make((IPattern)SymbolPattern.make((ISymbol)new RangeSymbol('\t', '\u000e')), (IPattern)SymbolPattern.make((ISymbol)new RangeSymbol('\u001c', '\u001f')))), (int)0));
        this.put("&java.lang.String.equals(Ljava/lang/Object;)Z", (ITranslator)new StringEqualsConstraint(0, 1));
        this.put("!java.lang.String.equals(Ljava/lang/Object;)Z", (ITranslator)new NotTemplate((IM2LConstraint)new StringEqualsConstraint(0, 1)));
        this.put("&java.lang.String.contains(Ljava/lang/CharSequence;)Z", (ITranslator)new ContainsConstraint(0, 1));
        this.put("!java.lang.String.contains(Ljava/lang/CharSequence;)Z", (ITranslator)new NotContainsConstraint(0, 1));
        this.put("&java.util.regex.Matcher.matches()Z", (ITranslator)new JavaMatcherMatchesTemplate());
        this.put("!java.util.regex.Matcher.matches()Z", (ITranslator)new NotTemplate((IM2LConstraint)new JavaMatcherMatchesTemplate()));
        this.put("&java.lang.String.indexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("&java.lang.String.indexOf(I)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("&java.lang.String.lastIndexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("&java.lang.String.lastIndexOf(I)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("!java.lang.String.indexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("!java.lang.String.indexOf(I)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("!java.lang.String.lastIndexOf(Ljava/lang/String;)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("!java.lang.String.lastIndexOf(I)I", (ITranslator)new IndexOfConstraint(0, 1));
        this.put("&#const.java.lang.String.indexOf(I)I", (ITranslator)new ConstIndexOfCharConstraint(0, 1));
        this.put("!#const.java.lang.String.indexOf(I)I", (ITranslator)new ConstIndexOfCharConstraint(0, 1));
        this.put("&#const.java.lang.String.equals(Ljava/lang/Object;)Z", (ITranslator)new ConstEqualsConstraint(0, 1));
        this.put("!#const.java.lang.String.equals(Ljava/lang/Object;)Z", (ITranslator)new NotTemplate((IM2LConstraint)new ConstEqualsConstraint(0, 1)));
    }

    protected void initMapTranslators() {
    }

    protected void initStringClasses() {
        for (int i = 0; i < defaultStringClasses.length; ++i) {
            this.stringClasses.add(defaultStringClasses[i]);
        }
    }

    public boolean isStringClass(String classSignature) {
        return this.stringClasses.contains(classSignature);
    }

    public int[] getParams(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        int[] params;
        if (invoke.isStatic()) {
            params = new int[invoke.getNumberOfParameters()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i);
            }
        } else {
            params = new int[invoke.getNumberOfParameters() - 1];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i + 1);
            }
        }
        return params;
    }

    public int getReceiver(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        if (invoke.isStatic()) {
            return -1;
        }
        return invoke.getReceiver();
    }

    public int[] getParams(IR ir) {
        int[] p = ir.getParameterValueNumbers();
        if (ir.getMethod().isStatic()) {
            return p;
        }
        int[] r = new int[p.length - 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = p[i + 1];
        }
        return r;
    }

    public int getReceiver(IR ir) {
        if (ir.getMethod().isStatic()) {
            return -1;
        }
        if (ir.getNumberOfParameters() > 0) {
            return ir.getParameter(0);
        }
        return -1;
    }

    public Set<String> getSignature(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        return RepositoryUtil.getSignature((SSAAbstractInvokeInstruction)invoke, (TranslationContext)ctx, (ITranslatorRepository)this);
    }

    protected String specialSignature(String sig, SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        if (specialSignatures.containsKey(sig)) {
            int recv = invoke.getReceiver();
            Value val = ctx.getIR().getSymbolTable().getValue(recv);
            if (val != null && val.isStringConstant()) {
                return specialSignatures.get(sig);
            }
        }
        return sig;
    }

    public boolean isBuiltin(String signature, SSAAbstractInvokeInstruction instruction, CallGraph cg) {
        Set nodes = cg.getNodes(instruction.getDeclaredTarget());
        if (nodes.isEmpty()) {
            return true;
        }
        if (this.hasSignature(signature)) {
            return true;
        }
        for (CGNode node : nodes) {
            if (this.isBuiltin(node, node.getMethod().getDeclaringClass().getClassLoader().getReference())) continue;
            return false;
        }
        return true;
    }

    public boolean isBuiltin(CGNode node, ClassLoaderReference loader) {
        return loader.equals((Object)ClassLoaderReference.Primordial);
    }

    public IRegexParser getRegexParser() {
        return regexParser;
    }

    public String getClassInitSignature() {
        return "<clinit>";
    }

    public String getInitSignature() {
        return "<init>";
    }

    static {
        specialSignatures.put("java.lang.String.indexOf(I)I", "#const.java.lang.String.indexOf(I)I");
        specialSignatures.put("java.lang.String.equals(Ljava/lang/Object;)Z", "#const.java.lang.String.equals(Ljava/lang/Object;)Z");
        regexParser = new IRegexParser(){
            JavaRegexParser parser = new JavaRegexParser();

            public IPattern parse(String str) {
                return this.parser.parse(str);
            }
        };
    }
}

