/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.docker;

import com.hcl.appscan.discovery.containers.IContainerEngine;
import com.hcl.appscan.discovery.containers.Messages;
import com.hcl.appscan.discovery.containers.docker.DockerRunner;
import com.ibm.appscan.common.error.AppScanException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class DockerEngine
implements IContainerEngine {
    private DockerRunner m_runner = new DockerRunner();

    @Override
    public void loadImage(File archive) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("load");
        args.add("--input");
        args.add("\"" + archive.getAbsolutePath() + "\"");
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.bind(Messages.DOCKER_LOAD_FAILED, archive.getAbsolutePath()));
        }
    }

    @Override
    public void pullImage(String imageName) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("pull");
        args.add(imageName);
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.bind(Messages.DOCKER_PULL_FAILED, imageName));
        }
    }

    @Override
    public void removeImage(String imageName) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("rmi");
        args.add("--force");
        args.add(imageName);
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.bind(Messages.DOCKER_RMI_FAILED, imageName));
        }
    }

    @Override
    public void createContainer(String imageName, String containerName) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("create");
        args.add("--name");
        args.add(containerName);
        args.add(imageName);
        args.add(".");
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.bind(Messages.DOCKER_CREATE_FAILED, imageName));
        }
    }

    @Override
    public void exportContainer(File archive, String containerName) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("export");
        args.add(containerName);
        args.add("--output");
        args.add("\"" + archive.getAbsolutePath() + "\"");
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.DOCKER_EXPORT_FAILED);
        }
    }

    @Override
    public void removeContainer(String containerName) throws IOException, AppScanException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("rm");
        args.add("--force");
        args.add(containerName);
        if (this.m_runner.run(args) != 0) {
            throw new AppScanException(Messages.bind(Messages.DOCKER_RM_FAILED, containerName));
        }
    }

    @Override
    public boolean imageExists(String name) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("inspect");
        args.add(name);
        return this.m_runner.run(args) == 0;
    }
}

