/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.nlp.model.Trace;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.ifa.common.IfaException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class IfaJavaService {
    public static final String TIMEOUT_SYS_PROPERTY = "IFA_JAVA_TIMEOUT_DURATION_MIN";
    public static final String DETACHED_PROPERTY = "KEEP_IFA_JAVA_SERVICE";
    private static final boolean IS_DETACHED = SystemUtil.defaultFalseProperty((String)"KEEP_IFA_JAVA_SERVICE");
    public static final String LOG_NAME = "IfaJavaService.log";
    private Process m_process;
    private XmlRpcClient m_client = new XmlRpcClient();
    private static Optional<IfaJavaService> s_static = Optional.empty();
    private static final String s_root_dir = CommonCore.getDirectoryLocator().getProductRoot();
    private static final String s_ml_dir = CommonCore.getDirectoryLocator().getMl() + "ifa/";
    private static final String s_ip = "127.0.0.1";
    private static final String s_winExt = ".exe";
    private static final String s_lnxExt = ".bin";
    private static final String s_service_name = "IfaJavaService";
    private static String s_port;
    private int m_timeout_after_n_min = IfaJavaService.parseTimeout(System.getProperty("IFA_JAVA_TIMEOUT_DURATION_MIN"));

    public static File getLogFile() {
        return new File(s_ml_dir, LOG_NAME);
    }

    public static IfaJavaService getService() throws Exception {
        if (!s_static.isPresent()) {
            s_static = Optional.of(new IfaJavaService());
        }
        return s_static.get();
    }

    static int parseTimeout(String timeoutStr) {
        if (timeoutStr == null) {
            return 1;
        }
        int i = 1;
        try {
            i = Integer.parseInt(timeoutStr);
        }
        catch (Exception e) {
            return 1;
        }
        if (i < 1) {
            return 1;
        }
        return i;
    }

    private IfaJavaService() throws Exception {
        Throwable throwable;
        File portFile = new File(s_ml_dir + ".port");
        String ext = "";
        ext = System.getProperty("os.name").toLowerCase().contains("windows") ? s_winExt : s_lnxExt;
        try {
            throwable = null;
            try (Scanner scanner = new Scanner(portFile);){
                this.setPort(scanner.nextInt());
                if (this.ping(0, 0)) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException scanner) {
            // empty catch block
        }
        throwable = null;
        try (ServerSocket sock = new ServerSocket(0);){
            this.setPort(sock.getLocalPort());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        throwable = null;
        try (FileWriter portFileWriter = new FileWriter(portFile, false);){
            portFileWriter.write(s_port);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        ProcessRunner runner = IS_DETACHED ? new ProcessRunner(new String[]{s_ml_dir + s_service_name + ext, s_port, "-d"}) : new ProcessRunner(new String[]{s_ml_dir + s_service_name + ext, s_port});
        runner.setDirectory(new File(s_root_dir));
        runner.environment().put("APPSCAN_INSTALL_DIR", s_root_dir);
        this.m_process = runner.startAsync();
    }

    public void close() throws Exception {
        if (IS_DETACHED) {
            return;
        }
        if (s_static.isPresent()) {
            IfaJavaService.s_static.get().m_client.execute("stop_server", new ArrayList());
            if (!FileUtils.readFileToString((File)IfaJavaService.getLogFile(), (Charset)Charset.defaultCharset()).contains("got stop signal")) {
                try {
                    Thread.sleep(10000L);
                    if (!FileUtils.readFileToString((File)IfaJavaService.getLogFile(), (Charset)Charset.defaultCharset()).contains("got stop signal")) {
                        if (System.getProperty("os.name").toLowerCase().contains("win")) {
                            Runtime.getRuntime().exec("TASKKILL /T /F /IM IfaJavaService.exe");
                        } else {
                            Runtime.getRuntime().exec("killall IfaJavaService.bin");
                        }
                        FileWriter writeServiceLog = new FileWriter(IfaJavaService.getLogFile(), true);
                        writeServiceLog.write("Service did not shutdown on time. Manually terminating.");
                        writeServiceLog.close();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            s_static = Optional.empty();
        }
    }

    public String[] predict(List<String> strings) throws Exception {
        ArrayList<List<String>> parameters = new ArrayList<List<String>>();
        parameters.add(strings);
        int n_retries = this.m_timeout_after_n_min;
        while (true) {
            try {
                String result = (String)IfaJavaService.s_static.get().m_client.execute("predict", parameters);
                return result.split(",");
            }
            catch (XmlRpcException e) {
                if (this.ping(60, 1000)) continue;
                if (n_retries <= 0) {
                    throw new IfaException("Failed to reach ifa server -> " + e.getMessage());
                }
                this.close();
                --n_retries;
                continue;
            }
            break;
        }
    }

    private boolean ping(int n_retries, int n_ms) {
        while (true) {
            try {
                this.m_client.execute("ping", new ArrayList());
                return true;
            }
            catch (XmlRpcException e) {
                if (n_retries <= 0) {
                    return false;
                }
                --n_retries;
                try {
                    Thread.sleep(n_ms);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void setPort(int port) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL("http", s_ip, port, "", null));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.m_client.setConfig((XmlRpcClientConfig)config);
        s_port = Integer.toString(port);
    }
}

