/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.dir;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.file.extension.ExtensionHelper;
import com.ibm.appscan.file.extension.FileExtensionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class FileCollectorStrategy
extends CrawlingStrategy {
    protected static final String STAGING = "staging";
    protected static final String STAGING_DIR = "staging/src";
    protected Set<String> m_fileExtensions = null;
    protected File m_stagingDir = null;

    protected void setStagingDirectory(File directory) {
        this.m_stagingDir = directory;
    }

    public File getStagingDirectory() {
        return this.m_stagingDir;
    }

    public boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        File target = this.getRoot(proxy);
        final ArrayList files = new ArrayList();
        final String scanHome = proxy.getScanHome().getName();
        try {
            DirectoryUtil.walk((File)target, (DirectoryUtil.TreeVisitor)new DirectoryUtil.TreeVisitor(){

                protected boolean preVisitDirectory(File directory) throws IOException {
                    return !directory.getName().equalsIgnoreCase(scanHome) && FileCollectorStrategy.this.shouldVisit(directory);
                }

                protected boolean visitFile(File file) throws IOException {
                    if (!file.getName().endsWith(".irx") && FileCollectorStrategy.this.acceptFile(file)) {
                        files.add(file);
                    }
                    return true;
                }
            });
            this.m_stagingDir = new File(proxy.getWorkingDirectory(), STAGING_DIR);
            this.m_stagingDir.mkdirs();
            for (File fileOrDirectory : files) {
                File destFile = new File(this.m_stagingDir, this.getStagePath(target, fileOrDirectory));
                destFile.getParentFile().mkdirs();
                if (!SystemUtil.isWindows()) {
                    destFile = new File(this.removeInvalidChar(destFile.getAbsolutePath()));
                }
                try {
                    IOUtil.copy((File)fileOrDirectory, (File)destFile);
                }
                catch (IOException e) {
                    proxy.getLogManager().log(new Message(2, Messages.getMessage("err.staging.file", FileUtil.getBaseName((File)fileOrDirectory)) + "\n" + e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("err.staging", new Object[0]), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean buildScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        File zip = new File(proxy.getWorkingDirectory(), "staging.zip");
        try {
            ArchiveUtil.zip((File)this.m_stagingDir.getParentFile(), (File)zip);
            new File(proxy.getScanHome(), ".sources").createNewFile();
            return true;
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("err.packaging", new Object[0]), (Throwable)e);
            return false;
        }
    }

    @Override
    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.getStagingDirectory();
    }

    @Override
    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        Set<Object> ret;
        File target = this.getRoot(proxy);
        if (target.isDirectory()) {
            ret = super.findScanFiles(proxy, progress);
        } else {
            ret = new LinkedHashSet();
            IScanFile scanFile = ScanModelFactory.newScanFile((File)new File(this.m_stagingDir, target.getName()));
            scanFile.setExcluded(this.isThirdPartyExclusion(scanFile, proxy));
            ret.add(scanFile);
        }
        for (IScanFile iScanFile : ret) {
            iScanFile.setSourcePath(PathUtil.makeRelative((File)this.m_stagingDir, (File)this.m_stagingDir, (File)iScanFile.getFile()).getPath());
        }
        try {
            DirectoryUtil.delete((File)this.m_stagingDir);
        }
        catch (IOException e) {
            proxy.getLogManager().log(new Message(Messages.getMessage("err.delete.staging", new Object[0]), (Throwable)e));
        }
        return ret;
    }

    protected boolean acceptFile(File file) {
        if (this.m_fileExtensions == null) {
            this.m_fileExtensions = new HashSet<String>();
            try {
                this.m_fileExtensions.addAll(ExtensionHelper.getFileExtensions((String)this.getExtensionGroup()));
            }
            catch (FileExtensionException e) {
                CommonCore.getLogManager().log(new Message(Messages.getMessage("err.read.file.extensions", this.getExtensionGroup()), (Throwable)e));
            }
        }
        String extension = FileUtil.getFileExtension((File)file).toLowerCase();
        return this.m_fileExtensions.contains(extension);
    }

    protected abstract String getExtensionGroup();

    public boolean collectsScanFiles() {
        return true;
    }

    public String removeInvalidChar(String dirPath) {
        String newDirPath = dirPath.replace("<", "lt").replace(">", "gt").replace(":", "cln").replace("\"", "dq").replace("|", "vb").replace("?", "qm").replace("*", "ast");
        return newDirPath;
    }

    protected String getStagePath(File directory, File sourceFile) {
        File sourceRoot = directory.getParent() == null ? directory : directory.getParentFile();
        String regExString = "(\\\\\\s+|\\s+\\\\)|(\\/\\s+|\\s+\\/)";
        String relativePath = PathUtil.makeRelative((File)directory, (File)sourceRoot, (String)sourceFile.getPath());
        File parentDir = sourceFile.getParentFile();
        int numParts = Paths.get(relativePath, new String[0]).getNameCount();
        if (numParts == 1 && parentDir != null) {
            relativePath = parentDir.getName() + File.separator + relativePath;
            numParts = 2;
        }
        if (numParts == 2 && parentDir.getParent() != null) {
            relativePath = parentDir.getParentFile().getName() + File.separator + relativePath;
        }
        if (relativePath.contains(" ")) {
            relativePath = relativePath.replaceAll(regExString, File.separator);
        }
        return FileUtil.checkAndModifyWinReservedName((String)relativePath).toString();
    }
}

