/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.dir;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.util.ThirdPartyDirUtil;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DirectoryStrategy
extends CrawlingStrategy {
    private StrategyFactoryRegistry m_registry;
    private boolean m_outputsOnly = true;
    private IScanTarget thirdPartyLibTarget = null;
    private List<File> m_targetDirectories = new ArrayList<File>();

    public DirectoryStrategy(File directory, IScanTarget _thirdPartyLibTarget, StrategyFactoryRegistry registry) {
        this.init(directory, registry);
        this.m_registry = registry;
        this.thirdPartyLibTarget = _thirdPartyLibTarget;
    }

    protected StrategyFactoryRegistry getRegistry() {
        return this.m_registry;
    }

    public IScanTarget getThirdPartyLibTarget() {
        return this.thirdPartyLibTarget;
    }

    public void setOutputsOnly(boolean outputsOnly) {
        this.m_outputsOnly = outputsOnly;
    }

    public String getType() {
        return Messages.getMessage("directory", new Object[0]);
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public void findScanTargets(final IScanTargetProxy proxy, IProgress progress) {
        if (this.m_outputsOnly) {
            return;
        }
        try {
            DirectoryUtil.walk((File)this.getRoot((IScanTargetMinProxy)proxy), (DirectoryUtil.TreeVisitor)new DirectoryUtil.TreeVisitor(){

                private boolean createTarget(File fileOrDirectory) {
                    ScanTargetStrategy strategy = DirectoryStrategy.this.m_registry.getStrategy(fileOrDirectory, StrategyFactoryRegistry.StrategyType.NON_OUTPUTS);
                    if (strategy != null) {
                        proxy.newScanTarget(strategy);
                        if (fileOrDirectory.isDirectory()) {
                            DirectoryStrategy.this.m_targetDirectories.add(fileOrDirectory);
                        }
                        return true;
                    }
                    if (DirectoryStrategy.this.thirdPartyLibTarget != null) {
                        DirectoryStrategy.this.thirdPartyLibTarget.inject(fileOrDirectory.getAbsolutePath());
                    }
                    return false;
                }

                protected boolean preVisitDirectory(File directory) throws IOException {
                    if (ThirdPartyDirUtil.isThirdPartyDir(directory) && !SystemUtil.isThirdParty()) {
                        if (DirectoryStrategy.this.thirdPartyLibTarget != null) {
                            DirectoryStrategy.this.thirdPartyLibTarget.inject(directory.getAbsolutePath());
                        }
                        return false;
                    }
                    return !this.createTarget(directory);
                }

                protected boolean visitFile(File file) throws IOException {
                    this.createTarget(file);
                    return true;
                }
            });
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        proxy.getProperties().put("isDirStrategy", true);
        Set<IScanFile> files = super.findScanFiles(proxy, progress);
        return files;
    }

    @Override
    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.getRoot(proxy);
    }

    @Override
    protected String[] getCategories(IBuildInfo buildInfo) {
        String categories = buildInfo.getProperty("categories");
        return categories == null ? null : categories.split(",");
    }

    @Override
    protected boolean shouldVisit(File directory) {
        return super.shouldVisit(directory) && !this.m_targetDirectories.contains(directory);
    }
}

