/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.composer;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComposerDependencyCollector
implements IDependencyCollector {
    private File m_composerJson;
    private ILogManager m_log;
    private boolean m_shouldRunTrivy = true;
    private static boolean stopProcessing = false;

    public ComposerDependencyCollector(File composerJson, ILogManager logManager) {
        this.m_composerJson = composerJson;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "Composer".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return "trivy";
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_composerJson.getParentFile();
    }

    @Override
    public String getToolName() {
        return "Composer";
    }

    @Override
    public Map<File, String> getDependencies(File location, String uuid) throws IOException {
        Map<File, String> files = new HashMap<File, String>();
        if (!stopProcessing) {
            List<File> composerJsonFiles = new ArrayList<File>();
            String outputFile = uuid + "_trivy_cyclon_report.json";
            File rootLocation = ThirdPartyLibUtils.getRootLocation(location);
            composerJsonFiles = ThirdPartyLibUtils.findAllConfigFiles(rootLocation, composerJsonFiles, "composer.json");
            for (File file : composerJsonFiles) {
                File composerLockFile = new File(file.getParentFile(), "composer.lock");
                if (!composerLockFile.isFile()) {
                    if (this.createdLockFile(file)) {
                        this.m_log.log(new Message(1, Messages.getMessage("created.composer.lock.file", new File(file.getParent()))));
                        continue;
                    }
                    this.m_log.log(new Message(1, Messages.getMessage("composer.lock.file.creation.failed", new File(file.getParent()))));
                    continue;
                }
                this.m_log.log(new Message(1, Messages.getMessage("composer.lock.file.exists", new File(file.getParent()))));
            }
            ThirdPartyLibUtils.createTrivyStagingDir(location, this.m_log);
            File rootComposerJson = new File(rootLocation, "composer.json");
            if (rootComposerJson.isFile()) {
                this.m_composerJson = rootComposerJson;
            }
            files = ThirdPartyLibUtils.runTrivyAndCollectOutputFile(location, outputFile, this.m_composerJson, this.m_shouldRunTrivy, this.m_log);
            stopProcessing = true;
            this.m_shouldRunTrivy = true;
        }
        return files;
    }

    private boolean createdLockFile(File file) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("update");
        args.add("--no-install");
        args.add("--no-scripts");
        args.add("--ignore-platform-reqs");
        try {
            this.run(this.getExecutableName(), args, null, file.getParentFile());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return new File(file.getParentFile(), "composer.lock").isFile();
    }

    @Override
    public boolean shouldProcessDependencies() {
        return true;
    }
}

