/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.poetry;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PoetryDependencyCollector
implements IDependencyCollector {
    private File m_pyprojectToml;
    private ILogManager m_log;

    public PoetryDependencyCollector(File pyprojectToml, ILogManager logManager) {
        this.m_pyprojectToml = pyprojectToml;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "Poetry".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return this.getExecutableName();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_pyprojectToml.getParentFile();
    }

    @Override
    public String getToolName() {
        return "Poetry";
    }

    @Override
    public Map<File, String> getDependencies(File location, String name) throws IOException {
        HashMap<File, String> files = null;
        int success = 0;
        if (!location.isDirectory() && !location.mkdirs()) {
            this.m_log.log(new Message(1, Messages.getMessage("staging.creation.error", new Object[0])));
            throw new IOException(Messages.getMessage("staging.creation.error", new Object[0]));
        }
        File poetryLockFile = new File(this.getWorkingDirectory(), "poetry.lock");
        File poetryLockStagingCopy = new File(location, name + "_poetry.lock");
        ArrayList<String> args = new ArrayList<String>();
        args.add("lock");
        try {
            if (!poetryLockFile.isFile()) {
                success = this.run(args, poetryLockStagingCopy);
                if (success == 0) {
                    this.m_log.log(new Message(1, Messages.getMessage("poetry.lock.succeeded", this.m_pyprojectToml)));
                } else {
                    this.m_log.log(new Message(1, Messages.getMessage("poetry.lock.failed", this.m_pyprojectToml)));
                }
            } else {
                this.m_log.log(new Message(1, Messages.getMessage("poetry.lock.exists", poetryLockFile)));
            }
            if (success == 0) {
                files = new HashMap<File, String>();
                poetryLockStagingCopy = new File(location, name + "_poetry.lock");
                Files.copy(poetryLockFile.toPath(), poetryLockStagingCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                files.put(poetryLockStagingCopy, this.m_pyprojectToml.getAbsolutePath());
                File tomlStagingCopy = new File(location, name + "_pyproject.toml");
                Files.copy(this.m_pyprojectToml.toPath(), tomlStagingCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                files.put(tomlStagingCopy, this.m_pyprojectToml.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return files;
    }

    @Override
    public boolean isToolInstalled() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("Version".toLowerCase());
        try {
            return this.run(args, null) == 0;
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
            return false;
        }
    }

    @Override
    public boolean shouldProcessDependencies() {
        File pyproject_toml = new File(this.getWorkingDirectory(), "pyproject.toml");
        return this.m_pyprojectToml.equals(pyproject_toml);
    }
}

