/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.dotnet.translator;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.stringAnalysis.dotnet.translator.RepositoryUtil;
import com.ibm.wala.stringAnalysis.translator.DefUseChainBasedComposer;
import com.ibm.wala.stringAnalysis.translator.IInvocationSymbolComposer;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.translator.regular.RegularTranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.regular.repository.CollectionToString;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Concatenate;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Contains;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Empty;
import com.ibm.wala.stringAnalysis.translator.regular.repository.FileJoin;
import com.ibm.wala.stringAnalysis.translator.regular.repository.GetFullPathForDotnet;
import com.ibm.wala.stringAnalysis.translator.regular.repository.GetValidFileNameForWindows;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Identity;
import com.ibm.wala.stringAnalysis.translator.regular.repository.IntRange;
import com.ibm.wala.stringAnalysis.translator.regular.repository.NetUrlEncoder;
import com.ibm.wala.stringAnalysis.translator.regular.repository.NotContains;
import com.ibm.wala.stringAnalysis.translator.regular.repository.NotStringEquals;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringEquals;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Strreplace;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Substring;
import com.ibm.wala.stringAnalysis.translator.regular.repository.SubstringByIndex;
import com.ibm.wala.stringAnalysis.translator.regular.repository.ToLowerCase;
import com.ibm.wala.stringAnalysis.translator.regular.repository.ToString;
import com.ibm.wala.stringAnalysis.translator.regular.repository.ToUpperCase;
import com.ibm.wala.types.ClassLoaderReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DotnetRegularTranslatorRepository
extends RegularTranslatorRepository {
    private static String[] defaultStringClasses = new String[]{"LSystem/String", "LSystem/Text/StringBuilder", "LSystem/Text/RegularExpressions/Regex"};
    private ClassLoader loader = null;
    private Set<String> stringClasses;
    private static String[] builtinPackages = new String[]{"System."};

    public DotnetRegularTranslatorRepository(ClassLoader loader) {
        this.loader = loader;
        this.stringClasses = new HashSet<String>();
        this.initTranslators();
        this.initMapTranslators();
        this.initStringClasses();
        this.initComposers();
    }

    public DotnetRegularTranslatorRepository() {
        this(null);
    }

    public void initComposers() {
        this.putComposer("System.String.Substring(II)LSystem/String;", (IInvocationSymbolComposer)new DefUseChainBasedComposer(2, Arrays.asList("System.String.IndexOf(Ljava/lang/String;)I", "System.String.IndexOf(Ljava/lang/String;I)I")));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    protected void initTranslators() {
        this.translatorMap.put("op(add)", new Concatenate());
        this.translatorMap.put("System.Int32.ToString()LSystem/String;", new ToString(-1, JavaPrimitiveType.INT));
        this.translatorMap.put("System.IO.Path.Combine(LSystem/String;LSystem/String;)LSystem/String;", new FileJoin(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.IO.Path.GetDirectoryName(LSystem/String;)LSystem/String;", new GetValidFileNameForWindows());
        this.translatorMap.put("System.IO.Path.GetFullPath(LSystem/String;)LSystem/String;", new GetFullPathForDotnet(0));
        this.translatorMap.put("System.Object.ToString()LSystem/String;", new Identity(-1));
        this.translatorMap.put("System.String..ctor([PSystem/Char;)PSystem/Void;", new CollectionToString(0));
        this.translatorMap.put("System.String.Substring(PSystem/Int32;PSystem/Int32;)LSystem/String;", new Substring(0, 1));
        this.translatorMap.put("System.String.Substring(PSystem/Int32;)LSystem/String;", new Substring(0, 1));
        this.translatorMap.put("System.String.Substring(PSystem/Int32;)LSystem/String;System.String.IndexOf(LSystem/String;)PSystem/Int32;", new SubstringByIndex(0, 1, 2));
        this.translatorMap.put("System.String.ToUpper()Ljava/lang/String;", new ToUpperCase());
        this.translatorMap.put("System.String.ToLower()Ljava/lang/String;", new ToLowerCase());
        this.translatorMap.put("System.String.Concat(LSystem/String;)LSystem/String;", new Concatenate(-1, new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;)LSystem/String;", new Concatenate(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new Concatenate(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new Concatenate(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.String.Replace(LSystem/String;LSystem/String;)LSystem/String;", new Strreplace(-1, 0, 1, false));
        this.translatorMap.put("System.Text.RegularExpressions.Regex.Replace(LSystem/String;LSystem/String;)LSystem/String;", new Strreplace(0, -1, 1, true));
        this.translatorMap.put("System.Text.RegularExpressions.Regex.Replace(LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new Strreplace(0, 1, 2, true));
        this.translatorMap.put("System.Text.StringBuilder..ctor()PSystem/Void;", new Empty());
        this.translatorMap.put("System.Text.StringBuilder.Append(LSystem/String;)LSystem/Text/StringBuilder;", new Concatenate(-1, new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("System.Text.StringBuilder.Replace(LSystem/String;LSystem/String;)LSystem/Text/StringBuilder;", new Strreplace(-1, 0, 1, false));
        this.translatorMap.put("System.Text.StringBuilder.ToString()LSystem/String;", new Identity(-1));
        this.translatorMap.put("System.Web.HttpUtility.UrlEncode(LSystem/String;)LSystem/String;", new NetUrlEncoder());
        this.translatorMap.put("&System.String.Equals(LSystem/Object;)Z", new StringEquals(0, 0));
        this.translatorMap.put("!System.String.Equals(LSystem/Object;)Z", new NotStringEquals(0, 0));
        this.translatorMap.put("&System.String.Equals(LSystem/String;)Z", new StringEquals(0, 0));
        this.translatorMap.put("!System.String.Equals(LSystem/String;)Z", new NotStringEquals(0, 0));
        this.translatorMap.put("&System.String.Contains(LSystem/String;)Z", new Contains(-1, 0));
        this.translatorMap.put("!System.String.Contains(LSystem/String;)Z", new NotContains(-1, 0));
        this.translatorMap.put("System.Text.RegularExpressions.Regex..ctor(LSystem/String;)PSystem/Void;", new Identity(0));
        this.translatorMap.put("System.Text.RegularExpressions.Regex..ctor(LSystem/String;LSystem/Text/RegularExpressions/RegexOptions;)PSystem/Void;", new Identity(0));
    }

    protected void initMapTranslators() {
    }

    protected void initStringClasses() {
        for (int i = 0; i < defaultStringClasses.length; ++i) {
            this.stringClasses.add(defaultStringClasses[i]);
        }
    }

    public boolean isStringClass(String classSignature) {
        return this.stringClasses.contains(classSignature);
    }

    public int[] getParams(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        int[] params;
        if (invoke.isStatic()) {
            params = new int[invoke.getNumberOfParameters()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i);
            }
        } else {
            params = new int[invoke.getNumberOfParameters() - 1];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i + 1);
            }
        }
        return params;
    }

    public int getReceiver(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        if (invoke.isStatic()) {
            return -1;
        }
        return invoke.getReceiver();
    }

    public int[] getParams(IR ir) {
        int[] p = ir.getParameterValueNumbers();
        if (ir.getMethod().isStatic()) {
            return p;
        }
        int[] r = new int[p.length - 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = p[i + 1];
        }
        return r;
    }

    public int getReceiver(IR ir) {
        if (ir.getMethod().isStatic()) {
            return -1;
        }
        if (ir.getNumberOfParameters() > 0) {
            return ir.getParameter(0);
        }
        return -1;
    }

    public Set<String> getSignature(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        return RepositoryUtil.getSignature(invoke, ctx, this);
    }

    private boolean containsBuiltinPackageName(String s) {
        for (String b : builtinPackages) {
            if (!s.startsWith(b)) continue;
            return true;
        }
        return false;
    }

    public boolean isBuiltin(String signature, SSAAbstractInvokeInstruction instruction, CallGraph cg) {
        if (this.containsBuiltinPackageName(signature)) {
            return true;
        }
        Set nodes = cg.getNodes(instruction.getDeclaredTarget());
        if (nodes.isEmpty()) {
            return true;
        }
        if (this.hasSignature(signature)) {
            return true;
        }
        for (CGNode node : nodes) {
            if (this.isBuiltin(node, node.getMethod().getDeclaringClass().getClassLoader().getReference())) continue;
            return false;
        }
        return true;
    }

    public boolean isBuiltin(CGNode node, ClassLoaderReference loader) {
        return loader.equals((Object)ClassLoaderReference.Primordial) || this.containsBuiltinPackageName(node.getMethod().getSignature());
    }

    public IRegexParser getRegexParser() {
        return RepositoryUtil.getRegexParser();
    }

    public String getClassInitSignature() {
        return ".cctor";
    }

    public String getInitSignature() {
        return ".ctor";
    }
}

