/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.was.compilers;

import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import com.ibm.appscan.discovery.was.IVersionConstants;
import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ServerInfo
extends XMLFileReader {
    private static final String PRODUCT_MARKER = "properties/version/WAS.product";
    private static final String E_VERSION = "version";
    private String m_version = null;

    static ServerInfo readServerInfo(File serverHome) {
        File productMarker = new File(serverHome, PRODUCT_MARKER);
        if (productMarker.isFile()) {
            ServerInfo server = new ServerInfo(productMarker);
            try {
                server.read();
                if (server.getVersion() != null) {
                    return server;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (XMLStreamException e) {
                return null;
            }
        }
        return null;
    }

    private ServerInfo(File productMarker) {
        super(productMarker);
    }

    private void checkVersion(String version) {
        for (String supportedVersion : IVersionConstants.VERSIONS) {
            if (!(version + ".").startsWith(supportedVersion + ".")) continue;
            this.m_version = supportedVersion;
            return;
        }
    }

    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) throws XMLStreamException {
        if (E_VERSION.equals(element.getName().getLocalPart())) {
            this.checkVersion(value.getText());
            return false;
        }
        return true;
    }

    String getVersion() {
        return this.m_version;
    }
}

