/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Map;

public class AbstractTICallGraph {
    protected final AnalysisCache analysisCache;
    protected final Map<CGNode, TypeAbstraction[]> node2ta = HashMapFactory.make();
    private Collection<IRKey> failedIRs = HashSetFactory.make();

    public AbstractTICallGraph(AnalysisCache analysisCache) {
        this.analysisCache = analysisCache;
    }

    public TypeAbstraction getType(CGNode node, int valueNumber) {
        try {
            TypeAbstraction[] typeAbstractions = this.node2ta.get(node);
            if (null == typeAbstractions) {
                typeAbstractions = this.getTypeAbstractions(node.getIR());
                this.node2ta.put(node, typeAbstractions);
            }
            return typeAbstractions[valueNumber];
        }
        catch (UnimplementedError e) {
            return TypeAbstraction.TOP;
        }
    }

    private TypeAbstraction[] getTypeAbstractions(IR ir) {
        TypeInference typeInference = TypeInference.make((IR)ir, (boolean)false);
        TypeAbstraction[] result = typeInference.extractAllResults();
        return result;
    }

    public DefUse getDU(IMethod m, Context c) {
        AnalysisOptions options = new AnalysisOptions();
        DefUse du = this.analysisCache.getSSACache().findOrCreateDU(m, c, options.getSSAOptions());
        return du;
    }

    public DefUse getDU(CGNode n) {
        AnalysisOptions options = new AnalysisOptions();
        DefUse du = this.analysisCache.getSSACache().findOrCreateDU(n.getMethod(), n.getContext(), options.getSSAOptions());
        return du;
    }

    public IR getIR(IMethod m, Context c) {
        AnalysisOptions options = new AnalysisOptions();
        IRKey key = new IRKey(m, c);
        IR ir = null;
        if (!this.failedIRs.contains(key)) {
            try {
                ir = this.analysisCache.getSSACache().findOrCreateIR(m, c, options.getSSAOptions());
            }
            catch (EmptyStackException e) {
                this.failedIRs.add(key);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.failedIRs.add(key);
            }
            catch (UnimplementedError e) {
                this.failedIRs.add(key);
            }
            catch (RuntimeException e) {
                this.failedIRs.add(key);
            }
            catch (AssertionError e) {
                this.failedIRs.add(key);
            }
        }
        return ir;
    }

    public IR getIR(CGNode n) {
        return this.getIR(n.getMethod(), n.getContext());
    }

    private static final class IRKey {
        private final Context c;
        private final IMethod m;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            result = 31 * result + (this.m == null ? 0 : this.m.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IRKey other = (IRKey)obj;
            if (this.c == null ? other.c != null : !this.c.equals(other.c)) {
                return false;
            }
            return !(this.m == null ? other.m != null : !this.m.equals(other.m));
        }

        public IRKey(IMethod m, Context c) {
            this.m = m;
            this.c = c;
        }
    }
}

